/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathJar
extends ClasspathLocation {
    private File file;
    private ZipFile zipFile;
    private boolean closeZipFileAtEnd;
    private Hashtable packageCache;

    public ClasspathJar(File file) throws IOException {
        this(file, true, null);
    }

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void initialize() throws IOException {
        this.zipFile = new ZipFile(this.file);
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put("", "");
        Enumeration<? extends ZipEntry> e2 = this.zipFile.entries();
        block0: while (e2.hasMoreElements()) {
            String fileName = e2.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (this.packageCache.containsKey(packageName)) continue block0;
                this.packageCache.put(packageName, packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(qualifiedPackageName);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public String normalizedPath() {
        String rawName = this.file.getPath();
        return rawName.substring(0, rawName.lastIndexOf(46));
    }

    public String getPath() {
        return this.file.getPath();
    }
}

