/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

public class MethodNameAndTypeCache {
    public MethodBinding[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public MethodNameAndTypeCache() {
        this(13);
    }

    public MethodNameAndTypeCache(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.66f);
        this.keyTable = new MethodBinding[initialCapacity];
        this.valueTable = new int[initialCapacity];
    }

    public void clear() {
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            this.keyTable[i2] = null;
            this.valueTable[i2] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(MethodBinding key) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public boolean equalsForNameAndType(MethodBinding method1, MethodBinding method2) {
        return CharOperation.equals(method1.selector, method2.selector) && CharOperation.equals(method1.signature(), method2.signature());
    }

    public int get(MethodBinding key) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    public int hashCode(MethodBinding key) {
        return CharOperation.hashCode(key.selector) % this.keyTable.length;
    }

    public int put(MethodBinding key, int value) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.equalsForNameAndType(this.keyTable[index], key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        MethodNameAndTypeCache newHashtable = new MethodNameAndTypeCache(this.keyTable.length * 2);
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            if (this.keyTable[i2] == null) continue;
            newHashtable.put(this.keyTable[i2], this.valueTable[i2]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i2 = 0;
        while (i2 < max) {
            if (this.keyTable[i2] != null) {
                buf.append(this.keyTable[i2]).append("->").append(this.valueTable[i2]);
            }
            if (i2 < max) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append("}");
        return buf.toString();
    }
}

