/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.base.AbstractBoot;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.log.PadMessage;
import org.jfree.base.modules.DefaultModuleInfo;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageSorter;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public final class PackageManager {
    private static final int RETURN_MODULE_LOADED = 0;
    private static final int RETURN_MODULE_UNKNOWN = 1;
    private static final int RETURN_MODULE_ERROR = 2;
    private final PackageConfiguration packageConfiguration;
    private final ArrayList modules;
    private final ArrayList initSections;
    private AbstractBoot booter;
    private static HashMap instances;

    public static PackageManager createInstance(AbstractBoot booter) {
        if (instances == null) {
            instances = new HashMap();
            PackageManager manager = new PackageManager(booter);
            instances.put(booter, manager);
            return manager;
        }
        PackageManager manager = (PackageManager)instances.get(booter);
        if (manager == null) {
            manager = new PackageManager(booter);
            instances.put(booter, manager);
        }
        return manager;
    }

    private PackageManager(AbstractBoot booter) {
        if (booter == null) {
            throw new NullPointerException();
        }
        this.booter = booter;
        this.packageConfiguration = new PackageConfiguration();
        this.modules = new ArrayList();
        this.initSections = new ArrayList();
    }

    public boolean isModuleAvailable(ModuleInfo moduleDescription) {
        PackageState[] packageStates = this.modules.toArray(new PackageState[this.modules.size()]);
        for (int i2 = 0; i2 < packageStates.length; ++i2) {
            PackageState state = packageStates[i2];
            if (!state.getModule().getModuleClass().equals(moduleDescription.getModuleClass())) continue;
            return state.getState() == 2;
        }
        return false;
    }

    public void load(String modulePrefix) {
        if (this.initSections.contains(modulePrefix)) {
            return;
        }
        this.initSections.add(modulePrefix);
        Configuration config = this.booter.getGlobalConfig();
        Iterator it = config.findPropertyKeys(modulePrefix);
        int count = 0;
        while (it.hasNext()) {
            String moduleClass;
            String key = (String)it.next();
            if (!key.endsWith(".Module") || (moduleClass = config.getConfigProperty(key)) == null || moduleClass.length() <= 0) continue;
            this.addModule(moduleClass);
            ++count;
        }
        Log.debug("Loaded a total of " + count + " modules under prefix: " + modulePrefix);
    }

    public synchronized void initializeModules() {
        PackageState mod;
        int i2;
        PackageSorter.sort(this.modules);
        for (i2 = 0; i2 < this.modules.size(); ++i2) {
            mod = (PackageState)this.modules.get(i2);
            if (!mod.configure(this.booter)) continue;
            Log.debug(new Log.SimpleMessage("Conf: ", new PadMessage(mod.getModule().getModuleClass(), 70), " [", mod.getModule().getSubSystem(), "]"));
        }
        for (i2 = 0; i2 < this.modules.size(); ++i2) {
            mod = (PackageState)this.modules.get(i2);
            if (!mod.initialize(this.booter)) continue;
            Log.debug(new Log.SimpleMessage("Init: ", new PadMessage(mod.getModule().getModuleClass(), 70), " [", mod.getModule().getSubSystem(), "]"));
        }
    }

    public synchronized void addModule(String modClass) {
        DefaultModuleInfo modInfo = new DefaultModuleInfo(modClass, null, null, null);
        ArrayList loadModules = new ArrayList();
        if (this.loadModule(modInfo, new ArrayList(), loadModules, false)) {
            for (int i2 = 0; i2 < loadModules.size(); ++i2) {
                Module mod = (Module)loadModules.get(i2);
                this.modules.add(new PackageState(mod));
            }
        }
    }

    private int containsModule(ArrayList tempModules, ModuleInfo module) {
        int i2;
        if (tempModules != null) {
            ModuleInfo[] mods = tempModules.toArray(new ModuleInfo[tempModules.size()]);
            for (i2 = 0; i2 < mods.length; ++i2) {
                if (!mods[i2].getModuleClass().equals(module.getModuleClass())) continue;
                return 0;
            }
        }
        PackageState[] packageStates = this.modules.toArray(new PackageState[this.modules.size()]);
        for (i2 = 0; i2 < packageStates.length; ++i2) {
            if (!packageStates[i2].getModule().getModuleClass().equals(module.getModuleClass())) continue;
            if (packageStates[i2].getState() == -2) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    private void dropFailedModule(PackageState state) {
        if (!this.modules.contains(state)) {
            this.modules.add(state);
        }
    }

    private boolean loadModule(ModuleInfo moduleInfo, ArrayList incompleteModules, ArrayList modules, boolean fatal) {
        try {
            Class<?> c2 = ObjectUtilities.getClassLoader(this.getClass()).loadClass(moduleInfo.getModuleClass());
            Module module = (Module)c2.newInstance();
            if (!this.acceptVersion(moduleInfo, module)) {
                Log.warn("Module " + module.getName() + ": required version: " + moduleInfo + ", but found Version: \n" + module);
                PackageState state = new PackageState(module, -2);
                this.dropFailedModule(state);
                return false;
            }
            int moduleContained = this.containsModule(modules, module);
            if (moduleContained == 2) {
                Log.debug("Indicated failure for module: " + module.getModuleClass());
                PackageState state = new PackageState(module, -2);
                this.dropFailedModule(state);
                return false;
            }
            if (moduleContained == 1) {
                if (incompleteModules.contains(module)) {
                    Log.error(new Log.SimpleMessage("Circular module reference: This module definition is invalid: ", module.getClass()));
                    PackageState state = new PackageState(module, -2);
                    this.dropFailedModule(state);
                    return false;
                }
                incompleteModules.add(module);
                ModuleInfo[] required = module.getRequiredModules();
                for (int i2 = 0; i2 < required.length; ++i2) {
                    if (this.loadModule(required[i2], incompleteModules, modules, true)) continue;
                    Log.debug("Indicated failure for module: " + module.getModuleClass());
                    PackageState state = new PackageState(module, -2);
                    this.dropFailedModule(state);
                    return false;
                }
                ModuleInfo[] optional = module.getOptionalModules();
                for (int i3 = 0; i3 < optional.length; ++i3) {
                    if (this.loadModule(optional[i3], incompleteModules, modules, true)) continue;
                    Log.debug(new Log.SimpleMessage("Optional module: ", optional[i3].getModuleClass(), " was not loaded."));
                }
                if (this.containsModule(modules, module) == 1) {
                    modules.add(module);
                }
                incompleteModules.remove(module);
            }
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            if (fatal) {
                Log.warn(new Log.SimpleMessage("Unresolved dependency for package: ", moduleInfo.getModuleClass()));
            }
            Log.debug(new Log.SimpleMessage("ClassNotFound: ", cnfe.getMessage()));
            return false;
        }
        catch (Exception e2) {
            Log.warn(new Log.SimpleMessage("Exception while loading module: ", moduleInfo), e2);
            return false;
        }
    }

    private boolean acceptVersion(ModuleInfo moduleRequirement, Module module) {
        int compare;
        if (moduleRequirement.getMajorVersion() == null) {
            return true;
        }
        if (module.getMajorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a major version.");
        } else {
            compare = this.acceptVersion(moduleRequirement.getMajorVersion(), module.getMajorVersion());
            if (compare > 0) {
                return false;
            }
            if (compare < 0) {
                return true;
            }
        }
        if (moduleRequirement.getMinorVersion() == null) {
            return true;
        }
        if (module.getMinorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a minor version.");
        } else {
            compare = this.acceptVersion(moduleRequirement.getMinorVersion(), module.getMinorVersion());
            if (compare > 0) {
                return false;
            }
            if (compare < 0) {
                return true;
            }
        }
        if (moduleRequirement.getPatchLevel() == null) {
            return true;
        }
        if (module.getPatchLevel() == null) {
            Log.debug("Module " + module.getName() + " does not define a patch level.");
        } else if (this.acceptVersion(moduleRequirement.getPatchLevel(), module.getPatchLevel()) > 0) {
            Log.debug("Did not accept patchlevel: " + moduleRequirement.getPatchLevel() + " - " + module.getPatchLevel());
            return false;
        }
        return true;
    }

    private int acceptVersion(String modVer, String depModVer) {
        char[] depVerArray;
        char[] modVerArray;
        int mLength = Math.max(modVer.length(), depModVer.length());
        if (modVer.length() > depModVer.length()) {
            modVerArray = modVer.toCharArray();
            depVerArray = new char[mLength];
            int delta = modVer.length() - depModVer.length();
            Arrays.fill(depVerArray, 0, delta, ' ');
            System.arraycopy(depVerArray, delta, depModVer.toCharArray(), 0, depModVer.length());
        } else if (modVer.length() < depModVer.length()) {
            depVerArray = depModVer.toCharArray();
            modVerArray = new char[mLength];
            char[] b1 = new char[mLength];
            int delta = depModVer.length() - modVer.length();
            Arrays.fill(b1, 0, delta, ' ');
            System.arraycopy(b1, delta, modVer.toCharArray(), 0, modVer.length());
        } else {
            depVerArray = depModVer.toCharArray();
            modVerArray = modVer.toCharArray();
        }
        return new String(modVerArray).compareTo(new String(depVerArray));
    }

    public PackageConfiguration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Module[] getAllModules() {
        Module[] mods = new Module[this.modules.size()];
        for (int i2 = 0; i2 < this.modules.size(); ++i2) {
            PackageState state = (PackageState)this.modules.get(i2);
            mods[i2] = state.getModule();
        }
        return mods;
    }

    public Module[] getActiveModules() {
        ArrayList<Module> mods = new ArrayList<Module>();
        for (int i2 = 0; i2 < this.modules.size(); ++i2) {
            PackageState state = (PackageState)this.modules.get(i2);
            if (state.getState() != 2) continue;
            mods.add(state.getModule());
        }
        return mods.toArray(new Module[mods.size()]);
    }

    public void printUsedModules(PrintStream p2) {
        int i2;
        Module[] allMods = this.getAllModules();
        ArrayList<Module> activeModules = new ArrayList<Module>();
        ArrayList<Module> failedModules = new ArrayList<Module>();
        for (i2 = 0; i2 < allMods.length; ++i2) {
            if (this.isModuleAvailable(allMods[i2])) {
                activeModules.add(allMods[i2]);
                continue;
            }
            failedModules.add(allMods[i2]);
        }
        p2.print("Active modules: ");
        p2.println(activeModules.size());
        p2.println("----------------------------------------------------------");
        for (i2 = 0; i2 < activeModules.size(); ++i2) {
            Module mod = (Module)activeModules.get(i2);
            p2.print(new PadMessage(mod.getModuleClass(), 70));
            p2.print(" [");
            p2.print(mod.getSubSystem());
            p2.println("]");
            p2.print("  Version: ");
            p2.print(mod.getMajorVersion());
            p2.print("-");
            p2.print(mod.getMinorVersion());
            p2.print("-");
            p2.print(mod.getPatchLevel());
            p2.print(" Producer: ");
            p2.println(mod.getProducer());
            p2.print("  Description: ");
            p2.println(mod.getDescription());
        }
    }

    public static class PackageConfiguration
    extends PropertyFileConfiguration {
        public void insertConfiguration(HierarchicalConfiguration config) {
            super.insertConfiguration(config);
        }
    }
}

