/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.ui.NumberCellRenderer;

public class RefineryUtilities {
    static /* synthetic */ Class class$java$awt$GraphicsEnvironment;
    static /* synthetic */ Class class$java$lang$Number;

    private RefineryUtilities() {
    }

    public static Point getCenterPoint() {
        GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = (class$java$awt$GraphicsEnvironment == null ? (class$java$awt$GraphicsEnvironment = RefineryUtilities.class$("java.awt.GraphicsEnvironment")) : class$java$awt$GraphicsEnvironment).getMethod("getCenterPoint", null);
            return (Point)method.invoke((Object)localGraphicsEnvironment, (Object[])null);
        }
        catch (Exception e2) {
            Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
            return new Point(s2.width / 2, s2.height / 2);
        }
    }

    public static Rectangle getMaximumWindowBounds() {
        GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = (class$java$awt$GraphicsEnvironment == null ? (class$java$awt$GraphicsEnvironment = RefineryUtilities.class$("java.awt.GraphicsEnvironment")) : class$java$awt$GraphicsEnvironment).getMethod("getMaximumWindowBounds", null);
            return (Rectangle)method.invoke((Object)localGraphicsEnvironment, (Object[])null);
        }
        catch (Exception e2) {
            Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(0, 0, s2.width, s2.height);
        }
    }

    public static void centerFrameOnScreen(Window frame2) {
        RefineryUtilities.positionFrameOnScreen(frame2, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window frame2, double horizontalPercent, double verticalPercent) {
        Rectangle s2 = RefineryUtilities.getMaximumWindowBounds();
        Dimension f2 = frame2.getSize();
        int w = Math.max(s2.width - f2.width, 0);
        int h7 = Math.max(s2.height - f2.height, 0);
        int x = (int)(horizontalPercent * (double)w) + s2.x;
        int y = (int)(verticalPercent * (double)h7) + s2.y;
        frame2.setBounds(x, y, f2.width, f2.height);
    }

    public static void positionFrameRandomly(Window frame2) {
        RefineryUtilities.positionFrameOnScreen(frame2, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Dimension d2 = dialog.getSize();
        Container parent = dialog.getParent();
        Dimension p2 = parent.getSize();
        int baseX = parent.getX() - d2.width;
        int baseY = parent.getY() - d2.height;
        int w = d2.width + p2.width;
        int h7 = d2.height + p2.height;
        int x = baseX + (int)(horizontalPercent * (double)w);
        int y = baseY + (int)(verticalPercent * (double)h7);
        Rectangle s2 = RefineryUtilities.getMaximumWindowBounds();
        x = Math.min(x, s2.width - d2.width);
        x = Math.max(x, 0);
        y = Math.min(y, s2.height - d2.height);
        y = Math.max(y, 0);
        dialog.setBounds(x + s2.x, y + s2.y, d2.width, d2.height);
    }

    public static JPanel createTablePanel(TableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table2 = new JTable(model);
        for (int columnIndex = 0; columnIndex < model.getColumnCount(); ++columnIndex) {
            TableColumn column = table2.getColumnModel().getColumn(columnIndex);
            Class<?> c2 = model.getColumnClass(columnIndex);
            if (!c2.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) continue;
            column.setCellRenderer(new NumberCellRenderer());
        }
        panel.add(new JScrollPane(table2));
        return panel;
    }

    public static JLabel createJLabel(String text, Font font2) {
        JLabel result = new JLabel(text);
        result.setFont(font2);
        return result;
    }

    public static JLabel createJLabel(String text, Font font2, Color color) {
        JLabel result = new JLabel(text);
        result.setFont(font2);
        result.setForeground(color);
        return result;
    }

    public static JButton createJButton(String label2, Font font2) {
        JButton result = new JButton(label2);
        result.setFont(font2);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

