/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Bank;
import org.compiere.acct.DocLine_BankCharge;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementCharge;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MTax;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Bank
extends Doc {
    private int m_C_BankAccount_ID = 0;
    protected DocLine[] p_lineCharge;

    public Doc_Bank(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MBankStatement.class, rs, "CMB", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getStatementDate());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_Bank> list = new ArrayList<DocLine_Bank>();
        MBankStatementLine[] lines = bs.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MPeriod period;
            MBankStatementLine line = lines[i];
            DocLine_Bank docLine = new DocLine_Bank(line, this);
            if (i == 0) {
                this.setDateAcct(line.getDateAcct());
            }
            if ((period = MPeriod.get(this.getCtx(), line.getDateAcct())) != null && period.isOpen("CMB")) {
                docLine.setC_Period_ID(period.getC_Period_ID());
            }
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        for (int i = 0; i < this.p_lines.length; ++i) {
            BigDecimal lineBalance = ((DocLine_Bank)this.p_lines[i]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        FactLine fl = null;
        int AD_Org_ID = this.getBank_Org_ID();
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine_Bank line = (DocLine_Bank)this.p_lines[i];
            int C_BPartner_ID = line.getC_BPartner_ID();
            fl = fact.createLine(line, this.getAccount(40, as), line.getC_Currency_ID(), line.getStmtAmt());
            if (fl != null && AD_Org_ID != 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
            if (fl != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            if ((fl = fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getTrxAmt().negate())) != null) {
                if (C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if (AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                } else {
                    fl.setAD_Org_ID(line.getAD_Org_ID(true));
                }
            }
            if ((fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getChargeAmt().negate(), null)) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            this.p_lineCharge = this.loadCharges((MBankStatementLine)line.p_po);
            for (int j = 0; j < this.p_lineCharge.length; ++j) {
                FactLine tl;
                BigDecimal taxAmt;
                DocLine_BankCharge lineCharge = (DocLine_BankCharge)this.p_lineCharge[j];
                fl = lineCharge.getChargeAmtNoTax().signum() < 0 ? fact.createLine((DocLine)lineCharge, lineCharge.getChargeAccount(as, lineCharge.getChargeAmtNoTax().negate()), line.getC_Currency_ID(), lineCharge.getChargeAmtNoTax().negate(), null) : fact.createLine((DocLine)lineCharge, lineCharge.getChargeAccount(as, lineCharge.getChargeAmtNoTax()), line.getC_Currency_ID(), null, lineCharge.getChargeAmtNoTax());
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if (fl != null && line.getAD_OrgTrx_ID() != 0) {
                    fl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                }
                if (fl != null && line.getC_Project_ID() != 0) {
                    fl.setC_Project_ID(line.getC_Project_ID());
                }
                if (fl != null && line.getC_Activity_ID() != 0) {
                    fl.setC_Activity_ID(line.getC_Activity_ID());
                }
                if (fl != null && line.getC_Campaign_ID() != 0) {
                    fl.setC_Campaign_ID(line.getC_Campaign_ID());
                }
                if (fl != null && line.getUser1_ID() != 0) {
                    fl.setUser1_ID(line.getUser1_ID());
                }
                if (fl != null && line.getC_Campaign_ID() != 0) {
                    fl.setUser2_ID(line.getUser2_ID());
                }
                if ((taxAmt = lineCharge.getTaxAmt()) == null || taxAmt.signum() == 0) continue;
                boolean isSalesTax = false;
                if (taxAmt.signum() > 0) {
                    isSalesTax = true;
                }
                MTax tax = MTax.get(this.getCtx(), lineCharge.getC_Tax_ID());
                DocTax taxLine = new DocTax(tax.getC_Tax_ID(), tax.getName(), tax.getRate(), lineCharge.getChargeAmtNoTax(), taxAmt, isSalesTax);
                if (taxAmt.signum() > 0) {
                    tl = fact.createLine(null, taxLine.getAccount(0, as), this.getC_Currency_ID(), null, taxAmt);
                    if (tl == null) continue;
                    tl.setC_Tax_ID(lineCharge.getC_Tax_ID());
                    if (this.getC_BPartner_ID() != 0) {
                        tl.setC_BPartner_ID(this.getC_BPartner_ID());
                    }
                    if (line.getAD_OrgTrx_ID() != 0) {
                        tl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                    }
                    if (line.getC_Project_ID() != 0) {
                        tl.setC_Project_ID(line.getC_Project_ID());
                    }
                    if (line.getC_Activity_ID() != 0) {
                        tl.setC_Activity_ID(line.getC_Activity_ID());
                    }
                    if (line.getC_Campaign_ID() != 0) {
                        tl.setC_Campaign_ID(line.getC_Campaign_ID());
                    }
                    if (line.getUser1_ID() != 0) {
                        tl.setUser1_ID(line.getUser1_ID());
                    }
                    if (line.getC_Campaign_ID() == 0) continue;
                    tl.setUser2_ID(line.getUser2_ID());
                    continue;
                }
                tl = fact.createLine(null, taxLine.getAccount(taxLine.getAPTaxType(), as), this.getC_Currency_ID(), taxAmt.negate(), null);
                if (tl == null) continue;
                tl.setC_Tax_ID(lineCharge.getC_Tax_ID());
                if (this.getC_BPartner_ID() != 0) {
                    tl.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (line.getAD_OrgTrx_ID() != 0) {
                    tl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                }
                if (line.getC_Project_ID() != 0) {
                    tl.setC_Project_ID(line.getC_Project_ID());
                }
                if (line.getC_Activity_ID() != 0) {
                    tl.setC_Activity_ID(line.getC_Activity_ID());
                }
                if (line.getC_Campaign_ID() != 0) {
                    tl.setC_Campaign_ID(line.getC_Campaign_ID());
                }
                if (line.getUser1_ID() != 0) {
                    tl.setUser1_ID(line.getUser1_ID());
                }
                if (line.getC_Campaign_ID() == 0) continue;
                tl.setUser2_ID(line.getUser2_ID());
            }
            fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate());
            if (fl == null || C_BPartner_ID == 0) continue;
            fl.setC_BPartner_ID(C_BPartner_ID);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }

    private DocLine[] loadCharges(MBankStatementLine bsl) {
        ArrayList<DocLine_BankCharge> list = new ArrayList<DocLine_BankCharge>();
        MBankStatementCharge[] charges = bsl.getCharges(false);
        for (int i = 0; i < charges.length; ++i) {
            MPeriod period;
            MBankStatementCharge charge = charges[i];
            DocLine_BankCharge docLineCharge = new DocLine_BankCharge(charge, this);
            if (i == 0) {
                this.setDateAcct(bsl.getDateAcct());
            }
            if ((period = MPeriod.get(this.getCtx(), bsl.getDateAcct())) != null && period.isOpen("CMB")) {
                docLineCharge.setC_Period_ID(period.getC_Period_ID());
            }
            list.add(docLineCharge);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }
}

