/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Cash;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MTax;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Cash
extends Doc {
    public Doc_Cash(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MCash.class, rs, "CMC", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MCash cash = (MCash)this.getPO();
        this.setDateDoc(cash.getStatementDate());
        this.setAmount(0, cash.getStatementDifference());
        MCashBook cb = MCashBook.get(this.getCtx(), cash.getC_CashBook_ID());
        this.setC_CashBook_ID(cb.getC_CashBook_ID());
        this.setC_Currency_ID(cb.getC_Currency_ID());
        this.p_lines = this.loadLines(cash, cb);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MCash cash, MCashBook cb) {
        ArrayList<DocLine_Cash> list = new ArrayList<DocLine_Cash>();
        MCashLine[] lines = cash.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MCashLine line = lines[i];
            DocLine_Cash docLine = new DocLine_Cash(line, this);
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        for (int i = 0; i < this.p_lines.length; ++i) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        if (this.getC_CashBook_ID() == 0) {
            this.p_Error = "C_CashBook_ID not set";
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        Fact fact = new Fact(this, as, "A");
        BigDecimal assetAmt = Env.ZERO;
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine_Cash line = (DocLine_Cash)this.p_lines[i];
            String CashType = line.getCashType();
            if (CashType.equals("E")) {
                fact.createLine((DocLine)line, this.getAccount(22, as), this.getC_Currency_ID(), line.getAmount().negate(), null);
                assetAmt = assetAmt.subtract(line.getAmount().negate());
                continue;
            }
            if (CashType.equals("R")) {
                assetAmt = assetAmt.add(line.getAmount());
                fact.createLine((DocLine)line, this.getAccount(23, as), this.getC_Currency_ID(), null, line.getAmount());
                continue;
            }
            if (CashType.equals("C")) {
                FactLine tl;
                BigDecimal taxAmt;
                BigDecimal amount = line.getAmountNoTax().negate();
                FactLine fl = null;
                fl = amount.signum() > 0 ? fact.createLine((DocLine)line, line.getChargeAccount(as, amount), this.getC_Currency_ID(), amount, null) : fact.createLine((DocLine)line, line.getChargeAccount(as, amount), this.getC_Currency_ID(), null, amount.negate());
                assetAmt = assetAmt.subtract(line.getAmountNoTax().negate());
                if (fl != null && this.getC_BPartner_ID() != 0) {
                    fl.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (fl != null && line.getAD_OrgTrx_ID() != 0) {
                    fl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                }
                if (fl != null && line.getC_Project_ID() != 0) {
                    fl.setC_Project_ID(line.getC_Project_ID());
                }
                if (fl != null && line.getC_Activity_ID() != 0) {
                    fl.setC_Activity_ID(line.getC_Activity_ID());
                }
                if (fl != null && line.getC_Campaign_ID() != 0) {
                    fl.setC_Campaign_ID(line.getC_Campaign_ID());
                }
                if (fl != null && line.getUser1_ID() != 0) {
                    fl.setUser1_ID(line.getUser1_ID());
                }
                if (fl != null && line.getC_Campaign_ID() != 0) {
                    fl.setUser2_ID(line.getUser2_ID());
                }
                if ((taxAmt = line.getTaxAmt()) == null || taxAmt.signum() == 0) continue;
                assetAmt = assetAmt.subtract(taxAmt.negate());
                boolean isSalesTax = false;
                if (taxAmt.signum() > 0) {
                    isSalesTax = true;
                }
                MTax tax = MTax.get(this.getCtx(), line.getC_Tax_ID());
                DocTax taxLine = new DocTax(tax.getC_Tax_ID(), tax.getName(), tax.getRate(), line.getAmountNoTax(), taxAmt, isSalesTax);
                if (taxAmt.signum() > 0) {
                    tl = fact.createLine(null, taxLine.getAccount(0, as), this.getC_Currency_ID(), null, taxAmt);
                    if (tl == null) continue;
                    tl.setC_Tax_ID(line.getC_Tax_ID());
                    if (this.getC_BPartner_ID() != 0) {
                        tl.setC_BPartner_ID(this.getC_BPartner_ID());
                    }
                    if (line.getAD_OrgTrx_ID() != 0) {
                        tl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                    }
                    if (line.getC_Project_ID() != 0) {
                        tl.setC_Project_ID(line.getC_Project_ID());
                    }
                    if (line.getC_Activity_ID() != 0) {
                        tl.setC_Activity_ID(line.getC_Activity_ID());
                    }
                    if (line.getC_Campaign_ID() != 0) {
                        tl.setC_Campaign_ID(line.getC_Campaign_ID());
                    }
                    if (line.getUser1_ID() != 0) {
                        tl.setUser1_ID(line.getUser1_ID());
                    }
                    if (line.getC_Campaign_ID() == 0) continue;
                    tl.setUser2_ID(line.getUser2_ID());
                    continue;
                }
                tl = fact.createLine(null, taxLine.getAccount(taxLine.getAPTaxType(), as), this.getC_Currency_ID(), taxAmt.negate(), null);
                if (tl == null) continue;
                tl.setC_Tax_ID(line.getC_Tax_ID());
                if (this.getC_BPartner_ID() != 0) {
                    tl.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (line.getAD_OrgTrx_ID() != 0) {
                    tl.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
                }
                if (line.getC_Project_ID() != 0) {
                    tl.setC_Project_ID(line.getC_Project_ID());
                }
                if (line.getC_Activity_ID() != 0) {
                    tl.setC_Activity_ID(line.getC_Activity_ID());
                }
                if (line.getC_Campaign_ID() != 0) {
                    tl.setC_Campaign_ID(line.getC_Campaign_ID());
                }
                if (line.getUser1_ID() != 0) {
                    tl.setUser1_ID(line.getUser1_ID());
                }
                if (line.getC_Campaign_ID() == 0) continue;
                tl.setUser2_ID(line.getUser2_ID());
                continue;
            }
            if (CashType.equals("D")) {
                fact.createLine(line, this.getAccount(24, as), this.getC_Currency_ID(), line.getAmount().negate());
                assetAmt = assetAmt.add(line.getAmount());
                continue;
            }
            if (CashType.equals("I")) {
                if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                    assetAmt = assetAmt.add(line.getAmount());
                } else {
                    fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
                }
                fact.createLine(line, this.getAccount(21, as), line.getC_Currency_ID(), line.getAmount().negate());
                continue;
            }
            if (!CashType.equals("T")) continue;
            int temp = this.getC_BankAccount_ID();
            this.setC_BankAccount_ID(line.getC_BankAccount_ID());
            fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getAmount().negate());
            this.setC_BankAccount_ID(temp);
            if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                assetAmt = assetAmt.add(line.getAmount());
                continue;
            }
            fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
        }
        fact.createLine(null, this.getAccount(20, as), this.getC_Currency_ID(), assetAmt);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

