/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import com.sun.mail.util.LineInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.SecuritySupport;
import javax.mail.Store;
import javax.mail.StreamLoader;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private final Properties props;
    private final Authenticator authenticator;
    private final Hashtable authTable = new Hashtable();
    private boolean debug = false;
    private PrintStream out;
    private final Vector providers = new Vector();
    private final Hashtable providersByProtocol = new Hashtable();
    private final Hashtable providersByClassName = new Hashtable();
    private final Properties addressMap = new Properties();
    private static Session defaultSession = null;
    private static final String version = "1.3.1";

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized void setDebug(boolean debug) {
        this.debug = debug;
        if (debug) {
            this.pr("DEBUG: setDebug: JavaMail version 1.3.1");
        }
    }

    private void loadProvidersFromStream(InputStream is) throws IOException {
        if (is != null) {
            String currLine;
            LineInputStream lis = new LineInputStream(is);
            while ((currLine = lis.readLine()) != null) {
                if (currLine.startsWith("#")) continue;
                Provider.Type type = null;
                String protocol = null;
                String className = null;
                String vendor = null;
                String version = null;
                StringTokenizer tuples = new StringTokenizer(currLine, ";");
                while (tuples.hasMoreTokens()) {
                    String currTuple = tuples.nextToken().trim();
                    int sep = currTuple.indexOf("=");
                    if (currTuple.startsWith("protocol=")) {
                        protocol = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (currTuple.startsWith("type=")) {
                        String strType = currTuple.substring(sep + 1);
                        if (strType.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!strType.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (currTuple.startsWith("class=")) {
                        className = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (currTuple.startsWith("vendor=")) {
                        vendor = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (!currTuple.startsWith("version=")) continue;
                    version = currTuple.substring(sep + 1);
                }
                if (type == null || protocol == null || className == null || protocol.length() <= 0 || className.length() <= 0) {
                    if (!this.debug) continue;
                    this.pr("DEBUG: Bad provider entry: " + currLine);
                    continue;
                }
                Provider provider = new Provider(type, protocol, className, vendor, version);
                this.addProvider(provider);
            }
        }
    }

    public synchronized PrintStream getDebugOut() {
        if (this.out == null) {
            return System.out;
        }
        return this.out;
    }

    public synchronized void setDebugOut(PrintStream out) {
        this.out = out;
    }

    private void loadAddressMap(Class cl) {
        block4: {
            StreamLoader loader = new StreamLoader(){

                public void load(InputStream is) throws IOException {
                    Session.this.addressMap.load(is);
                }
            };
            this.loadResource("/META-INF/javamail.default.address.map", cl, loader);
            this.loadAllResources("META-INF/javamail.address.map", cl, loader);
            try {
                String res = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.address.map";
                this.loadFile(res, loader);
            }
            catch (SecurityException sex) {
                if (!this.debug) break block4;
                this.pr("DEBUG: can't get java.home: " + sex);
            }
        }
        if (this.addressMap.isEmpty()) {
            if (this.debug) {
                this.pr("DEBUG: failed to load address map, using defaults");
            }
            this.addressMap.put("rfc822", "smtp");
        }
    }

    private void loadProviders(Class cl) {
        StreamLoader loader;
        block5: {
            loader = new StreamLoader(){

                public void load(InputStream is) throws IOException {
                    Session.this.loadProvidersFromStream(is);
                }
            };
            try {
                String res = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.providers";
                this.loadFile(res, loader);
            }
            catch (SecurityException sex) {
                if (!this.debug) break block5;
                this.pr("DEBUG: can't get java.home: " + sex);
            }
        }
        this.loadAllResources("META-INF/javamail.providers", cl, loader);
        this.loadResource("/META-INF/javamail.default.providers", cl, loader);
        if (this.providers.size() == 0) {
            if (this.debug) {
                this.pr("DEBUG: failed to load any providers, using defaults");
            }
            this.addProvider(new Provider(Provider.Type.STORE, "imap", "com.sun.mail.imap.IMAPStore", "Sun Microsystems, Inc.", version));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3", "com.sun.mail.pop3.POP3Store", "Sun Microsystems, Inc.", version));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtp", "com.sun.mail.smtp.SMTPTransport", "Sun Microsystems, Inc.", version));
        }
        if (this.debug) {
            this.pr("DEBUG: Tables of loaded providers");
            this.pr("DEBUG: Providers Listed By Class Name: " + this.providersByClassName.toString());
            this.pr("DEBUG: Providers Listed By Protocol: " + this.providersByProtocol.toString());
        }
    }

    private void pr(String str) {
        this.getDebugOut().println(str);
    }

    public Properties getProperties() {
        return this.props;
    }

    public synchronized Provider[] getProviders() {
        Object[] _providers = new Provider[this.providers.size()];
        this.providers.copyInto(_providers);
        return _providers;
    }

    private void addProvider(Provider provider) {
        this.providers.addElement(provider);
        this.providersByClassName.put(provider.getClassName(), provider);
        if (!this.providersByProtocol.containsKey(provider.getProtocol())) {
            this.providersByProtocol.put(provider.getProtocol(), provider);
        }
    }

    public synchronized void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        this.props.put("mail." + provider.getProtocol() + ".class", provider.getClassName());
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    private Session(Properties props, Authenticator authenticator) {
        this.props = props;
        this.authenticator = authenticator;
        if (Boolean.valueOf(props.getProperty("mail.debug")).booleanValue()) {
            this.debug = true;
        }
        if (this.debug) {
            this.pr("DEBUG: JavaMail version 1.3.1");
        }
        Class<?> cl = authenticator != null ? authenticator.getClass() : this.getClass();
        this.loadProviders(cl);
        this.loadAddressMap(cl);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        Store store = this.getStore(url);
        store.connect();
        return store.getFolder(url);
    }

    public PasswordAuthentication getPasswordAuthentication(URLName url) {
        return (PasswordAuthentication)this.authTable.get(url);
    }

    public void setPasswordAuthentication(URLName url, PasswordAuthentication pw) {
        if (pw == null) {
            this.authTable.remove(url);
        } else {
            this.authTable.put(url, pw);
        }
    }

    public synchronized Provider getProvider(String protocol) throws NoSuchProviderException {
        if (protocol == null || protocol.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider _provider = null;
        String _className = this.props.getProperty("mail." + protocol + ".class");
        if (_className != null) {
            if (this.debug) {
                this.pr("DEBUG: mail." + protocol + ".class property exists and points to " + _className);
            }
            _provider = (Provider)this.providersByClassName.get(_className);
        }
        if (_provider != null) {
            return _provider;
        }
        _provider = (Provider)this.providersByProtocol.get(protocol);
        if (_provider == null) {
            throw new NoSuchProviderException("No provider for " + protocol);
        }
        if (this.debug) {
            this.pr("DEBUG: getProvider() returning " + _provider.toString());
        }
        return _provider;
    }

    public static Session getDefaultInstance(Properties props) {
        return Session.getDefaultInstance(props, null);
    }

    public static Session getInstance(Properties props) {
        return new Session(props, null);
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        return this.getStore(new URLName(protocol, null, -1, null, null, null));
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider p = this.getProvider(protocol);
        return this.getStore(p, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFile(String name, StreamLoader loader) {
        block19: {
            BufferedInputStream clis;
            block18: {
                clis = null;
                clis = new BufferedInputStream(new FileInputStream(name));
                if (clis != null) {
                    loader.load(clis);
                    if (this.debug) {
                        this.pr("DEBUG: successfully loaded file: " + name);
                    }
                    break block18;
                }
                if (!this.debug) break block18;
                this.pr("DEBUG: not loading file: " + name);
            }
            Object var6_4 = null;
            try {
                if (clis != null) {
                    ((InputStream)clis).close();
                }
                break block19;
            }
            catch (IOException ex) {}
            break block19;
            {
                catch (IOException e) {
                    if (this.debug) {
                        this.pr("DEBUG: " + e);
                    }
                    Object var6_5 = null;
                    try {
                        if (clis != null) {
                            ((InputStream)clis).close();
                        }
                        break block19;
                    }
                    catch (IOException ex) {}
                    break block19;
                }
                catch (SecurityException sex) {
                    if (this.debug) {
                        this.pr("DEBUG: " + sex);
                    }
                    Object var6_6 = null;
                    try {
                        if (clis != null) {
                            ((InputStream)clis).close();
                        }
                        break block19;
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (clis != null) {
                        ((InputStream)clis).close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        return this.getTransport(new URLName(protocol, null, -1, null, null, null));
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String transportProtocol = (String)this.addressMap.get(address.getType());
        if (transportProtocol == null) {
            throw new NoSuchProviderException("No provider for Address type: " + address.getType());
        }
        return this.getTransport(transportProtocol);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider p = this.getProvider(protocol);
        return this.getTransport(p, url);
    }

    private Object getService(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (url == null) {
            url = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Object service = null;
        ClassLoader cl = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        Class<?> serviceClass = null;
        try {
            ClassLoader ccl = SecuritySupport.getInstance().getContextClassLoader();
            if (ccl != null) {
                try {
                    serviceClass = ccl.loadClass(provider.getClassName());
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            if (serviceClass == null) {
                serviceClass = cl.loadClass(provider.getClassName());
            }
        }
        catch (Exception ex1) {
            try {
                serviceClass = Class.forName(provider.getClassName());
            }
            catch (Exception ex) {
                if (this.debug) {
                    ex.printStackTrace(this.getDebugOut());
                }
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            Class[] c = new Class[]{Session.class, URLName.class};
            Constructor<?> cons = serviceClass.getConstructor(c);
            Object[] o = new Object[]{this, url};
            service = cons.newInstance(o);
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace(this.getDebugOut());
            }
            throw new NoSuchProviderException(provider.getProtocol());
        }
        return service;
    }

    public static synchronized Session getDefaultInstance(Properties props, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(props, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public static Session getInstance(Properties props, Authenticator authenticator) {
        return new Session(props, authenticator);
    }

    private Store getStore(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, url);
        }
        catch (ClassCastException cce) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAllResources(String name, Class cl, StreamLoader loader) {
        boolean anyLoaded;
        block22: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getInstance().getContextClassLoader();
                if (cld == null) {
                    cld = cl.getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getInstance().getResources(cld, name) : SecuritySupport.getInstance().getSystemResources(name)) == null) break block22;
                for (int i = 0; i < urls.length; ++i) {
                    InputStream clis;
                    block23: {
                        URL url = urls[i];
                        clis = null;
                        if (this.debug) {
                            this.pr("DEBUG: URL " + url);
                        }
                        clis = SecuritySupport.getInstance().openStream(url);
                        if (clis != null) {
                            loader.load(clis);
                            anyLoaded = true;
                            if (this.debug) {
                                this.pr("DEBUG: successfully loaded resource: " + url);
                            }
                            break block23;
                        }
                        if (!this.debug) break block23;
                        this.pr("DEBUG: not loading resource: " + url);
                    }
                    Object var12_14 = null;
                    try {
                        if (clis == null) continue;
                        clis.close();
                    }
                    catch (IOException cex) {}
                    continue;
                    {
                        catch (IOException ioex) {
                            if (this.debug) {
                                this.pr("DEBUG: " + ioex);
                            }
                            var12_14 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                        catch (SecurityException sex) {
                            if (this.debug) {
                                this.pr("DEBUG: " + sex);
                            }
                            var12_14 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var12_14 = null;
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException cex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception ex) {
                if (!this.debug) break block22;
                this.pr("DEBUG: " + ex);
            }
        }
        if (!anyLoaded) {
            if (this.debug) {
                this.pr("DEBUG: !anyLoaded");
            }
            this.loadResource("/" + name, cl, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadResource(String name, Class cl, StreamLoader loader) {
        block19: {
            InputStream clis;
            block18: {
                clis = null;
                clis = SecuritySupport.getInstance().getResourceAsStream(cl, name);
                if (clis != null) {
                    loader.load(clis);
                    if (this.debug) {
                        this.pr("DEBUG: successfully loaded resource: " + name);
                    }
                    break block18;
                }
                if (!this.debug) break block18;
                this.pr("DEBUG: not loading resource: " + name);
            }
            Object var7_5 = null;
            try {
                if (clis != null) {
                    clis.close();
                }
                break block19;
            }
            catch (IOException ex) {}
            break block19;
            {
                catch (IOException e) {
                    if (this.debug) {
                        this.pr("DEBUG: " + e);
                    }
                    Object var7_6 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block19;
                    }
                    catch (IOException ex) {}
                    break block19;
                }
                catch (SecurityException sex) {
                    if (this.debug) {
                        this.pr("DEBUG: " + sex);
                    }
                    Object var7_7 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block19;
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (clis != null) {
                        clis.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private Transport getTransport(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, url);
        }
        catch (ClassCastException cce) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress addr, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(addr, port, protocol, prompt, defaultUserName);
        }
        return null;
    }
}

