/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.compiere.common.Response;
import org.compiere.util.Ctx;

public class ChangeVO
extends Response {
    private static final long serialVersionUID = 1L;
    public String newConfirmedFieldValue = null;
    public HashMap changedFields = null;
    public HashMap changedDropDowns = null;
    public HashMap changedContext = null;
    public HashMap changedComponents = null;
    public String[] rowData = null;

    public ChangeVO() {
    }

    public ChangeVO(String message) {
        this(false, message);
    }

    public ChangeVO(boolean error, String message) {
        if (error) {
            this.addError(message);
        } else {
            this.addSuccess(message);
        }
    }

    public String addChangedComponent(String tableName, String value) {
        if (tableName != null) {
            if (this.changedComponents == null) {
                this.changedComponents = new HashMap();
            }
            String s = this.changedComponents.put(tableName, value);
            return s;
        }
        return null;
    }

    public String addChangedValue(String columnName, Object value) {
        if (columnName != null) {
            if (this.changedFields == null) {
                this.changedFields = new HashMap();
            }
            if (value == null || value instanceof String) {
                return (String)this.changedFields.put(columnName, value);
            }
            String stringValue = value.toString();
            if (value instanceof Date) {
                long longValue = ((Date)value).getTime();
                stringValue = String.valueOf(longValue);
            } else if (value instanceof Boolean) {
                stringValue = (Boolean)value != false ? "Y" : "N";
            }
            return this.changedFields.put(columnName, stringValue);
        }
        return null;
    }

    public String addChangedValue(String columnName, boolean value) {
        return this.addChangedValue(columnName, value ? "Y" : "N");
    }

    public String addChangedValue(String columnName, int value) {
        String stringValue = String.valueOf(value);
        if (value < 0) {
            stringValue = null;
        }
        return this.addChangedValue(columnName, stringValue);
    }

    public String addChangedValue(String columnName, byte[] value) {
        return null;
    }

    public ArrayList addChangedDropDown(String columnName, ArrayList data) {
        if (columnName != null) {
            if (this.changedDropDowns == null) {
                this.changedDropDowns = new HashMap();
            }
            ArrayList l = this.changedDropDowns.put(columnName, data);
            return l;
        }
        return null;
    }

    public String setContext(Ctx ctx, int windowNo, String columnName, String value) {
        if (columnName != null) {
            ctx.setContext(windowNo, columnName, value);
            if (this.changedContext == null) {
                this.changedContext = new HashMap();
            }
            String s = this.changedContext.put(columnName, value);
            return s;
        }
        return null;
    }

    public String setContext(Ctx ctx, int windowNo, String columnName, int value) {
        return this.setContext(ctx, windowNo, columnName, String.valueOf(value));
    }

    public String setContext(Ctx ctx, int windowNo, String columnName, boolean value) {
        return this.setContext(ctx, windowNo, columnName, value ? "Y" : "N");
    }

    public String setContext(Ctx ctx, int windowNo, String columnName, Number value) {
        String stringValue = null;
        if (value != null) {
            stringValue = value.toString();
        }
        return this.setContext(ctx, windowNo, columnName, stringValue);
    }

    public void addContextAll(Ctx ctx, int windowNo) {
        if (this.changedContext != null) {
            Set keys = this.changedContext.keySet();
            for (String colName : keys) {
                Object value = this.changedContext.get(colName);
                String stringValue = null;
                if (value != null) {
                    stringValue = value.toString();
                }
                ctx.setContext(windowNo, colName, stringValue);
            }
        }
    }

    public void mergeTo(HashMap to) {
        if (this.changedContext != null) {
            to.putAll(this.changedContext);
        }
        if (this.changedFields != null) {
            to.putAll(this.changedFields);
        }
    }

    public void addAll(ChangeVO add) {
        if (add == null) {
            return;
        }
        if (add.changedDropDowns != null) {
            if (this.changedDropDowns == null) {
                this.changedDropDowns = add.changedDropDowns;
            } else {
                this.changedDropDowns.putAll(add.changedDropDowns);
            }
        }
        if (add.changedFields != null) {
            if (this.changedFields == null) {
                this.changedFields = add.changedFields;
            } else {
                this.changedFields.putAll(add.changedFields);
            }
        }
        if (add.changedContext != null) {
            if (this.changedContext == null) {
                this.changedContext = add.changedContext;
            } else {
                this.changedContext.putAll(add.changedContext);
            }
        }
        this.messages.addAll(add.messages);
        if (add.hasError) {
            this.hasError = true;
        }
        if (add.hasWarning) {
            this.hasWarning = true;
        }
    }

    public ChangeVO cleanup() {
        if (this.changedFields != null && this.changedFields.isEmpty()) {
            this.changedFields = null;
        }
        if (this.changedDropDowns != null && this.changedDropDowns.isEmpty()) {
            this.changedDropDowns = null;
        }
        return this;
    }

    public String toString() {
        StringBuffer sb0 = new StringBuffer("ChangeVO[").append(super.toString());
        return "changedFields: " + this.changedFields + " changedDropDowns:" + this.changedDropDowns + " changedContext:" + this.changedContext;
    }
}

