/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.compiere.common.FieldType;
import org.compiere.common.QueryRestrictionVO;

public class QueryVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String savedQueryName = null;
    public boolean saveQuery = false;
    public ArrayList restrictions = null;
    public int onlyCurrentDays = 0;
    public boolean onlyCurrentCreated = false;

    public boolean equals(QueryVO v) {
        if (v == null) {
            return false;
        }
        if (v == this) {
            return true;
        }
        if (this.onlyCurrentDays != v.onlyCurrentDays || this.onlyCurrentCreated != v.onlyCurrentCreated) {
            return false;
        }
        if (this.restrictions == null) {
            return v.restrictions == null;
        }
        if (v.restrictions == null) {
            return false;
        }
        if (this.restrictions.size() != v.restrictions.size()) {
            return false;
        }
        for (int i = 0; i < this.restrictions.size(); ++i) {
            if (this.restrictions.get(i).equals(v.restrictions.get(i))) continue;
            return false;
        }
        return true;
    }

    public void addRestrictions(QueryVO p_queryVO) {
        if (p_queryVO != null && p_queryVO.restrictions != null) {
            if (this.restrictions == null) {
                this.restrictions = new ArrayList();
            }
            this.restrictions.addAll(p_queryVO.restrictions);
        }
    }

    public void addRestriction(QueryRestrictionVO qVO) {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList();
        }
        this.restrictions.add(qVO);
    }

    public StringBuffer getWhereClause() {
        StringBuffer whereClauseBuf = new StringBuffer();
        if (this.restrictions != null) {
            whereClauseBuf = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this.restrictions.size(); ++i) {
                QueryRestrictionVO r = (QueryRestrictionVO)this.restrictions.get(i);
                if (first) {
                    whereClauseBuf.append(" WHERE ");
                } else {
                    whereClauseBuf.append(" AND ");
                }
                first = false;
                StringBuffer columnName = new StringBuffer();
                if (!FieldType.isCaseSensitive(r.DisplayType)) {
                    columnName.append("UPPER( ");
                }
                columnName.append(r.ColumnName);
                if (!FieldType.isCaseSensitive(r.DisplayType)) {
                    columnName.append(" ) ");
                }
                if (!r.Operator.equals(" BETWEEN ")) {
                    whereClauseBuf.append(columnName);
                    whereClauseBuf.append(r.Operator);
                    whereClauseBuf.append("? ");
                    continue;
                }
                if (r.Code != null && r.Code.length() > 0) {
                    whereClauseBuf.append(columnName);
                    whereClauseBuf.append(">=");
                    whereClauseBuf.append("? ");
                }
                if (r.Code != null && r.Code.length() > 0 && r.Code_to != null && r.Code_to.length() > 0) {
                    whereClauseBuf.append("AND ");
                }
                if (r.Code_to == null || r.Code_to.length() <= 0) continue;
                whereClauseBuf.append(columnName);
                whereClauseBuf.append("<=");
                whereClauseBuf.append("? ");
            }
        }
        return whereClauseBuf;
    }

    public Object[] getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < this.restrictions.size(); ++i) {
            QueryRestrictionVO r = (QueryRestrictionVO)this.restrictions.get(i);
            if (r.DisplayType == 11) {
                params.add(new Integer(r.Code));
                continue;
            }
            params.add(r.Code);
        }
        Object[] ret = new Object[params.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = params.get(i);
        }
        return ret;
    }
}

