/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.compiere.util.CLoggerSimple;
import org.compiere.util.CompiereLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Evaluatee;
import org.compiere.vos.WindowCtx;

public class Evaluator {
    public static CompiereLogger log = new CLoggerSimple(Evaluator.class);

    public static boolean isAllVariablesDefined(Evaluatee source, String logic) {
        if (logic == null || logic.length() == 0) {
            return true;
        }
        int pos = 0;
        while (pos < logic.length()) {
            int first = logic.indexOf(64, pos);
            if (first == -1) {
                return true;
            }
            int second = logic.indexOf(64, first + 1);
            if (second == -1) {
                log.severe("No second @ in Logic: " + logic);
                return false;
            }
            String variable = logic.substring(first + 1, second - 1);
            String eval = source.get_ValueAsString(variable);
            log.finest(variable + "=" + eval);
            if (eval == null || eval.length() == 0) {
                return false;
            }
            pos = second + 1;
        }
        return true;
    }

    public static boolean evaluateLogic(Evaluatee source, String logic) {
        StringTokenizer st = new StringTokenizer(logic.trim(), "&|", true);
        int it = st.countTokens();
        if (it / 2 - (it + 1) / 2 == 0) {
            log.severe("Logic does not comply with format '<expression> [<logic> <expression>]' => " + logic);
            return false;
        }
        boolean retValue = Evaluator.evaluateLogicTuple(source, st.nextToken());
        while (st.hasMoreTokens()) {
            String logOp = st.nextToken().trim();
            boolean temp = Evaluator.evaluateLogicTuple(source, st.nextToken());
            if (logOp.equals("&")) {
                retValue &= temp;
                continue;
            }
            if (logOp.equals("|")) {
                retValue |= temp;
                continue;
            }
            log.warning("Logic operant '|' or '&' expected => " + logic);
            return false;
        }
        return retValue;
    }

    private static boolean evaluateLogicTuple(Evaluatee source, String logic) {
        StringTokenizer st = new StringTokenizer(logic.trim(), "!=^><", true);
        if (st.countTokens() != 3) {
            log.warning("Logic tuple does not comply with format '@context@=value' where operand could be one of '=!^><' => " + logic);
            return false;
        }
        String first = st.nextToken().trim();
        String firstEval = first.trim();
        if (first.indexOf(64) != -1 && (firstEval = source.get_ValueAsString(first = first.replace('@', ' ').trim())) == null) {
            firstEval = "";
        }
        firstEval = firstEval.replace('\'', ' ').replace('\"', ' ').trim();
        String operand = st.nextToken();
        String second = st.nextToken();
        String secondEval = second.trim();
        if (second.indexOf(64) != -1 && (secondEval = source.get_ValueAsString(second = second.replace('@', ' ').trim())) == null) {
            secondEval = "";
        }
        secondEval = secondEval.replace('\'', ' ').replace('\"', ' ').trim();
        if (first.indexOf("_ID") != -1 && firstEval.length() == 0) {
            firstEval = "0";
        }
        if (second.indexOf("_ID") != -1 && secondEval.length() == 0) {
            secondEval = "0";
        }
        boolean result = Evaluator.evaluateLogicTuple(firstEval, operand, secondEval);
        if (log.isLevelFinest()) {
            log.finest(logic + " => \"" + firstEval + "\" " + operand + " \"" + secondEval + "\" => " + result);
        }
        return result;
    }

    public static boolean evaluateLogicTuple(String value1, String operand, String value2) {
        if (value1 == null || operand == null || value2 == null) {
            return false;
        }
        Double value1bd = null;
        Double value2bd = null;
        try {
            if (!value1.startsWith("'")) {
                value1bd = new Double(value1);
            }
            if (!value2.startsWith("'")) {
                value2bd = new Double(value2);
            }
        }
        catch (Exception e) {
            value1bd = null;
            value2bd = null;
        }
        if (operand.equals("=")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) == 0;
            }
            return value1.compareTo(value2) == 0;
        }
        if (operand.equals("<")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) < 0;
            }
            return value1.compareTo(value2) < 0;
        }
        if (operand.equals(">")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) > 0;
            }
            return value1.compareTo(value2) > 0;
        }
        if (value1bd != null && value2bd != null) {
            return value1bd.compareTo(value2bd) != 0;
        }
        return value1.compareTo(value2) != 0;
    }

    public static void parseDepends(ArrayList list, String parseString) {
        if (parseString == null || parseString.length() == 0) {
            return;
        }
        String s = parseString;
        while (s.indexOf("@") != -1) {
            int pos = s.indexOf("@");
            if ((pos = (s = s.substring(pos + 1)).indexOf("@")) == -1) continue;
            String variable = s.substring(0, pos);
            s = s.substring(pos + 1);
            if (list.contains(variable)) continue;
            list.add(variable);
        }
    }

    public static String replaceVariables(String raw, Ctx ctx, WindowCtx windowCtx) {
        String result = raw;
        ArrayList variables = new ArrayList();
        Evaluator.parseDepends(variables, raw);
        for (int i = 0; i < variables.size(); ++i) {
            String var = (String)variables.get(i);
            String param = null;
            if (windowCtx != null) {
                param = windowCtx.get(var);
            }
            if (param == null) {
                param = ctx.getContext(var);
            }
            if (param != null && param.length() > 0) {
                Double num = null;
                try {
                    num = new Double(param);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (num != null) {
                    result = result.replaceAll("@" + var + "@", num.toString());
                    continue;
                }
                result = result.replaceAll("@" + var + "@", param.replaceAll("'", "''"));
                continue;
            }
            result = result.replaceAll("@" + var + "@", "NULL");
        }
        return result;
    }

    public static String stripVariables(String raw) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(raw, "@");
        while (st.hasMoreTokens()) {
            buf.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            buf.append("?");
            st.nextToken();
        }
        return buf.toString();
    }

    public static ArrayList getVariables(String raw) {
        ArrayList<String> variables = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(raw, "@");
        while (st.hasMoreTokens()) {
            buf.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            buf.append("?");
            variables.add(st.nextToken());
        }
        return variables;
    }
}

