/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.vos;

import java.io.Serializable;
import org.compiere.common.constants.Build;
import org.compiere.util.CLoggerSimple;
import org.compiere.util.CompiereLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.vos.ComponentVO;
import org.compiere.vos.ListBoxVO;

public class FieldVO
implements Serializable {
    static final long serialVersionUID = 4385061125114436797L;
    public static CompiereLogger log = new CLoggerSimple(FieldVO.class);
    public static final int MAX_FIELD_LENGTH = 20;
    public static final int MAX_DISPLAY_LENGTH = 20;
    public int WindowNo;
    public int TabNo;
    public int AD_Window_ID;
    public int AD_Tab_ID;
    public boolean tabReadOnly = false;
    public boolean isProcess = false;
    public String ColumnName = "";
    public String ColumnSQL;
    public String Header = "";
    public int displayType = 0;
    public int AD_Table_ID = 0;
    public int AD_Column_ID = 0;
    public int DisplayLength = 0;
    public boolean IsSameLine = false;
    public boolean IsDisplayed = false;
    public String DisplayLogic = "";
    public String DefaultValue = "";
    public boolean IsMandatoryUI = false;
    public boolean IsReadOnly = false;
    public boolean IsUpdateable = false;
    public boolean IsAlwaysUpdateable = false;
    public boolean IsHeading = false;
    public boolean IsFieldOnly = false;
    public boolean IsEncryptedField = false;
    public boolean IsEncryptedColumn = false;
    public boolean IsSelectionColumn = false;
    public int SortNo = 0;
    public int FieldLength = 0;
    public String VFormat = "";
    public String ValueMin = "";
    public String ValueMax = "";
    public String FieldGroup = "";
    public boolean IsKey = false;
    public boolean IsParent = false;
    public int AD_Process_ID = 0;
    public String Description = "";
    public String Help = "";
    public String ReadOnlyLogic = "";
    public String ObscureType = null;
    public boolean IsDefaultFocus = false;
    public String ValidationCode = "";
    public int AD_Reference_Value_ID = 0;
    public boolean isRange = false;
    public String DefaultValue2 = "";
    public int AD_Field_ID;
    public int AD_Reference_ID;
    public int AD_Val_Rule_ID;
    public String name = "";
    public String label = "";
    public int seqNo;
    public boolean IsIdentifier = false;
    public boolean IsTranslated = false;
    public String mandatoryLogic = "";
    public boolean IsVirtualColumn = false;
    public String tableName = null;
    public int hotKey = 1;
    public int mrSeqNo = -1;
    public ListBoxVO listBoxVO = null;
    public boolean isImpactsValue = false;
    public boolean isImpactsUITab = false;
    public boolean isDependentValue = false;
    public boolean isImpactsUI = false;
    public boolean isQueryCriteria = false;
    public String selectClause = null;
    public String numberFormatPattern = "###,###,###,###,###,###.######";
    public String dateFormatPattern = "yyyy-MM-dd";
    public boolean isColumnAccess = true;

    public int maxDisplayLength() {
        if (this.DisplayLength <= 0) {
            return 20;
        }
        return 20 > this.DisplayLength ? this.DisplayLength : 20;
    }

    public boolean hasDisplayLogic() {
        return this.DisplayLogic != null && !this.DisplayLogic.trim().equals("");
    }

    public boolean canDisplay() {
        return this.hasDisplayLogic() || this.IsDisplayed;
    }

    public boolean hasReadOnlyLogic() {
        return this.ReadOnlyLogic != null && !this.ReadOnlyLogic.trim().equals("");
    }

    public boolean isEditable(Ctx ctx, Evaluatee eval, boolean tabReadOnly, boolean rowReadOnly, String tabLinkColumn, boolean inserting) {
        if (this.IsVirtualColumn) {
            return false;
        }
        if (this.ColumnName.equals("Posted") || this.ColumnName.equals("Record_ID") && this.displayType == 28) {
            return true;
        }
        if (this.IsAlwaysUpdateable) {
            return true;
        }
        if (tabReadOnly || this.IsReadOnly) {
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " NO - TabRO=" + tabReadOnly + ", FieldRO=" + this.IsReadOnly);
            }
            return false;
        }
        if (!this.IsUpdateable && !inserting) {
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " NO - FieldUpdateable=" + this.IsUpdateable);
            }
            return false;
        }
        String linkColumn = tabLinkColumn;
        if (this.ColumnName.equals(linkColumn)) {
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " NO - LinkColumn");
            }
            return false;
        }
        if (rowReadOnly) {
            return false;
        }
        if (!this.isColumnAccess) {
            return false;
        }
        String logic = this.ReadOnlyLogic;
        if (logic != null && logic.length() > 0) {
            boolean retValue;
            boolean bl = retValue = !Evaluator.evaluateLogic(eval, logic);
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " R/O(" + logic + ") => R/W-" + retValue);
            }
            if (!retValue) {
                return false;
            }
        }
        if (this.ColumnName.equals("Processing") || this.ColumnName.equals("DocAction") || this.ColumnName.equals("GenerateTo")) {
            return true;
        }
        if (ctx != null && (ctx.isProcessed(this.WindowNo) || ctx.isProcessing(this.WindowNo))) {
            return false;
        }
        if (this.ColumnName.equals("IsActive")) {
            return true;
        }
        if (ctx != null && !ctx.isActive(this.WindowNo)) {
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " Record not active");
            }
            return false;
        }
        if (inserting) {
            return true;
        }
        return this.isDisplayed(eval);
    }

    public boolean isMandatory(Evaluatee eval) {
        if (this.IsVirtualColumn) {
            return false;
        }
        String logic = this.mandatoryLogic;
        if (!(this.IsMandatoryUI || logic != null && logic.length() != 0)) {
            return false;
        }
        if (this.IsKey && this.ColumnName.endsWith("_ID") || this.ColumnName.startsWith("Created") || this.ColumnName.startsWith("Updated") || this.ColumnName.equals("Value") || this.ColumnName.equals("DocumentNo") || this.ColumnName.equals("M_AttributeSetInstance_ID")) {
            return false;
        }
        if (logic != null && logic.length() > 0 && Evaluator.evaluateLogic(eval, logic)) {
            return true;
        }
        return this.isDisplayed(eval);
    }

    public boolean isDisplayed(Evaluatee eval) {
        if (!this.IsDisplayed) {
            return false;
        }
        String logic = this.DisplayLogic;
        if (logic == null || logic.equals("")) {
            return true;
        }
        if (eval != null) {
            boolean retValue = Evaluator.evaluateLogic(eval, logic);
            if (Build.isVerbose()) {
                log.finest(this.ColumnName + " (" + logic + ") => " + retValue);
            }
            return retValue;
        }
        return true;
    }

    public FieldVO(String columnName, String name, int displayType) {
        this.ColumnName = columnName;
        this.name = name.replaceAll("&", "");
        this.displayType = displayType;
        this.IsDisplayed = true;
    }

    public FieldVO(String columnName, String name, int displayType, boolean isMandatoryUI) {
        this(columnName, name, displayType);
        this.IsMandatoryUI = isMandatoryUI;
    }

    public FieldVO(String columnName, String name, String colSQL, int displayType, boolean readOnly) {
        this(columnName, name, colSQL, displayType, readOnly, true, false);
    }

    public FieldVO(String columnName, String name, String colSQL, int displayType, boolean readOnly, boolean isDisplayed, boolean isKey) {
        this(columnName, name, displayType);
        this.ColumnSQL = colSQL;
        this.selectClause = colSQL;
        this.IsReadOnly = readOnly;
        this.IsDisplayed = isDisplayed;
        this.IsKey = isKey;
    }

    public FieldVO() {
    }

    public FieldVO copySearch() {
        FieldVO f = new FieldVO();
        f.AD_Column_ID = this.AD_Column_ID;
        f.AD_Field_ID = this.AD_Field_ID;
        f.AD_Tab_ID = this.AD_Tab_ID;
        f.AD_Table_ID = this.AD_Table_ID;
        f.ColumnName = this.ColumnName;
        f.tableName = this.tableName;
        f.displayType = this.displayType == 14 ? 10 : this.displayType;
        f.DisplayLength = this.DisplayLength;
        f.FieldLength = this.FieldLength;
        f.IsDisplayed = this.IsDisplayed;
        if (this.listBoxVO != null) {
            ListBoxVO searchList = new ListBoxVO(this.listBoxVO.getOptions(), this.listBoxVO.getDefaultKey());
            searchList.Column_ID = this.listBoxVO.Column_ID;
            searchList.TableName = this.listBoxVO.TableName;
            searchList.AD_Reference_Value_ID = this.listBoxVO.AD_Reference_Value_ID;
            searchList.IsCreadedUpdatedBy = this.listBoxVO.IsCreadedUpdatedBy;
            searchList.IsValidated = this.listBoxVO.IsValidated;
            searchList.IsParent = this.listBoxVO.IsParent;
            searchList.KeyColumn = this.listBoxVO.KeyColumn;
            searchList.QueryDirect = this.listBoxVO.QueryDirect;
            searchList.ValidationCode = this.listBoxVO.ValidationCode;
            searchList.zoomWindow = this.listBoxVO.zoomWindow;
            searchList.ZoomWindowPO = this.listBoxVO.ZoomWindowPO;
            f.listBoxVO = searchList;
        }
        f.name = this.name;
        f.Description = this.Description;
        f.Help = this.Help;
        f.isQueryCriteria = this.isQueryCriteria;
        f.AD_Reference_ID = this.AD_Reference_ID;
        f.isRange = this.isRange;
        f.selectClause = this.selectClause;
        f.DefaultValue = this.DefaultValue;
        f.isImpactsValue = this.isImpactsValue;
        f.IsIdentifier = this.IsIdentifier;
        f.WindowNo = this.WindowNo;
        f.TabNo = ComponentVO.SEARCH_TAB_NO;
        return f;
    }

    public FieldVO copySearchAdvanced() {
        FieldVO f = new FieldVO();
        f.AD_Column_ID = this.AD_Column_ID;
        f.AD_Field_ID = this.AD_Field_ID;
        f.AD_Tab_ID = this.AD_Tab_ID;
        f.AD_Table_ID = this.AD_Table_ID;
        f.ColumnName = this.ColumnName;
        f.tableName = this.tableName;
        f.displayType = this.displayType == 14 ? 10 : this.displayType;
        f.DisplayLength = this.DisplayLength;
        f.FieldLength = this.FieldLength;
        f.IsDisplayed = true;
        f.IsReadOnly = false;
        f.IsAlwaysUpdateable = this.IsAlwaysUpdateable;
        f.IsMandatoryUI = false;
        f.isDependentValue = this.isDependentValue;
        f.AD_Reference_Value_ID = this.AD_Reference_Value_ID;
        f.AD_Window_ID = this.AD_Window_ID;
        if (this.listBoxVO != null) {
            ListBoxVO searchList = new ListBoxVO(false);
            searchList.Column_ID = this.listBoxVO.Column_ID;
            searchList.TableName = this.listBoxVO.TableName;
            searchList.AD_Reference_Value_ID = this.listBoxVO.AD_Reference_Value_ID;
            searchList.IsCreadedUpdatedBy = this.listBoxVO.IsCreadedUpdatedBy;
            searchList.IsValidated = this.listBoxVO.IsValidated;
            searchList.IsParent = this.listBoxVO.IsParent;
            searchList.KeyColumn = this.listBoxVO.KeyColumn;
            searchList.QueryDirect = this.listBoxVO.QueryDirect;
            searchList.ValidationCode = this.listBoxVO.ValidationCode;
            searchList.zoomWindow = this.listBoxVO.zoomWindow;
            searchList.ZoomWindowPO = this.listBoxVO.ZoomWindowPO;
            f.listBoxVO = searchList;
        }
        f.name = this.name;
        f.Description = this.Description;
        f.Help = this.Help;
        f.isQueryCriteria = this.isQueryCriteria;
        f.AD_Reference_ID = this.AD_Reference_ID;
        f.isRange = this.isRange;
        f.selectClause = this.selectClause;
        f.DefaultValue = this.DefaultValue;
        f.isImpactsValue = this.isImpactsValue;
        f.IsIdentifier = this.IsIdentifier;
        f.WindowNo = this.WindowNo;
        f.TabNo = ComponentVO.SEARCH_TAB_NO;
        return f;
    }

    public static String getToColumnName(String columnName) {
        return columnName + "_2";
    }

    public String toString() {
        return this.ColumnName;
    }
}

