/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;

public class BaseConfiguration
implements Configuration {
    private Hashtable store = new Hashtable();
    protected Configuration defaults = null;
    protected ArrayList keysAsListed = new ArrayList();
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    public void addProperty(String key, Object token) {
        Vector<Object> tokenAdd = null;
        if (token instanceof String) {
            tokenAdd = this.processString((String)token);
        } else {
            if (token instanceof Collection) {
                Iterator it = ((Collection)token).iterator();
                while (it.hasNext()) {
                    this.addProperty(key, it.next());
                }
                return;
            }
            tokenAdd = new Vector<Object>(1);
            tokenAdd.add(token);
        }
        Object o = this.store.get(key);
        if (o instanceof Container) {
            Iterator it = tokenAdd.iterator();
            while (it.hasNext()) {
                ((Container)o).add(it.next());
            }
        } else {
            Container c = new Container();
            if (o != null) {
                c.add(o);
            }
            Iterator it = tokenAdd.iterator();
            while (it.hasNext()) {
                c.add(it.next());
            }
            if (o == null && c.size() == 1) {
                this.addPropertyDirect(key, c.get(0));
            } else {
                this.addPropertyDirect(key, c);
            }
        }
    }

    protected List processString(String token) {
        ArrayList<String> retList = new ArrayList<String>(2);
        if (token.indexOf(",") > 0) {
            PropertiesTokenizer tokenizer = new PropertiesTokenizer(token);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                retList.add(value);
            }
        } else {
            retList.add(token);
        }
        return retList;
    }

    protected void addPropertyDirect(String key, Object obj) {
        if (!this.store.containsKey(key)) {
            this.keysAsListed.add(key);
        }
        this.store.put(key, obj);
    }

    protected String interpolate(String base) {
        if (base == null) {
            return null;
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String variable = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            variable = base.substring(begin + START_TOKEN.length(), end);
            if (this.store.get(variable) != null) {
                result.append(this.store.get(variable));
            } else if (this.defaults != null && this.defaults.getString(variable) != null) {
                result.append(this.defaults.getString(variable));
            } else {
                result.append(START_TOKEN).append(variable).append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    public String testBoolean(String value) {
        String s = value.toLowerCase();
        if (s.equals("true") || s.equals("on") || s.equals("yes")) {
            return "true";
        }
        if (s.equals("false") || s.equals("off") || s.equals("no")) {
            return "false";
        }
        return null;
    }

    public Configuration subset(String prefix) {
        BaseConfiguration c = new BaseConfiguration();
        Iterator keys = this.getKeys();
        boolean validSubset = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            if (!validSubset) {
                validSubset = true;
            }
            String newKey = null;
            newKey = ((String)key).length() == prefix.length() ? prefix : ((String)key).substring(prefix.length() + 1);
            Object value = this.store.get(key);
            if (value instanceof String) {
                c.addPropertyDirect(newKey, this.interpolate((String)value));
                continue;
            }
            c.addPropertyDirect(newKey, value);
        }
        if (validSubset) {
            return c;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public void clearProperty(String key) {
        if (this.containsKey(key)) {
            int i = 0;
            while (i < this.keysAsListed.size()) {
                if (((String)this.keysAsListed.get(i)).equals(key)) {
                    this.keysAsListed.remove(i);
                    break;
                }
                ++i;
            }
            this.store.remove(key);
        }
    }

    public Iterator getKeys() {
        return this.keysAsListed.iterator();
    }

    public Iterator getKeys(String prefix) {
        Iterator keys = this.getKeys();
        ArrayList matchingKeys = new ArrayList();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            matchingKeys.add(key);
        }
        return matchingKeys.iterator();
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, new Properties());
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = new Properties(defaults);
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                throw new IllegalArgumentException('\'' + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            props.put(pkey, pvalue);
            ++i;
        }
        return props;
    }

    public Object getProperty(String key) {
        Object o = this.store.get(key);
        if (o == null && this.defaults != null) {
            o = this.defaults.getProperty(key);
        }
        if (o instanceof Container) {
            o = ((Container)o).asVector();
        }
        return o;
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = this.testBoolean((String)value);
            Boolean b = new Boolean(s);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Boolean object");
    }

    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b = new Byte((String)value);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Byte object");
    }

    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d = new Double((String)value);
            return d;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Double object");
    }

    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f = new Float((String)value);
            return f;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Float object");
    }

    public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Integer object");
    }

    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l = new Long((String)value);
            return l;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Long object");
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            return s;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Short object");
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(key, defaultValue));
            }
            return this.interpolate(defaultValue);
        }
        if (value instanceof Container) {
            return this.interpolate((String)((Container)value).get(0));
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a String object");
    }

    public String[] getStringArray(String key) {
        String[] tokens;
        Object value = this.store.get(key);
        if (value instanceof String) {
            tokens = new String[]{this.interpolate((String)value)};
        } else if (value instanceof Container) {
            tokens = new String[((Container)value).size()];
            int i = 0;
            while (i < tokens.length) {
                tokens[i] = this.interpolate((String)((Container)value).get(i));
                ++i;
            }
        } else if (value == null) {
            tokens = this.defaults != null ? this.defaults.getStringArray(key) : new String[]{};
        } else {
            throw new ClassCastException('\'' + key + "' doesn't map to a String/Vector object");
        }
        return tokens;
    }

    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    public Vector getVector(String key, Vector defaultValue) {
        Object value = this.store.get(key);
        Vector v = null;
        if (value instanceof String) {
            v = new Vector(1);
            v.addElement((String)value);
        } else if (value instanceof Container) {
            v = ((Container)value).asVector();
        } else if (value == null) {
            v = this.defaults != null ? this.defaults.getVector(key, defaultValue) : (defaultValue == null ? new Vector() : defaultValue);
        } else {
            throw new ClassCastException('\'' + key + "' doesn't map to a Vector object: " + value + ", a " + value.getClass().getName());
        }
        return v;
    }

    class Container {
        private List l = new Vector(2);

        public void add(Object o) {
            this.l.add(o);
        }

        public int size() {
            return this.l.size();
        }

        public Object get(int index) {
            return this.l.get(index);
        }

        public Iterator iterator() {
            return this.l.iterator();
        }

        public Vector asVector() {
            Vector v = new Vector(this.l.size());
            Iterator it = this.l.iterator();
            while (it.hasNext()) {
                v.add(it.next());
            }
            return v;
        }
    }

    class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (token.endsWith("\\")) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(DELIMITER);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }
}

