/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SimpleResourceTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;

public class JMSLister
extends AbstractPluginWrapper {
    protected static final String JMX_JSR77_DOMAIN = "jboss.management.local";

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            ObjectName objName = ((MBeanResource)resource).getObjectName();
            SimpleTreeNode node = this.createTreeNode(objName.getKeyProperty("name"), "", "images/spirale.gif", null, null, this.createDestinations(), null);
            node.setMasterNode(true);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.checker);
            return null;
        }
    }

    private TreeNode[] createDestinations() throws Exception {
        TreeNode[] destinations = new TreeNode[]{this.createTreeNode("Queues", "", "images/spirale.gif", null, null, null, this.createDestinationItems("Queue")), this.createTreeNode("Topics", "", "images/spirale.gif", null, null, null, this.createDestinationItems("Topic"))};
        return destinations;
    }

    private ResourceTreeNode[] createDestinationItems(String type) throws Exception {
        ObjectInstance[] insts = this.getMBeansForQuery("jboss.mq.destination:service=" + type + ",*", null);
        ResourceTreeNode[] destinations = new ResourceTreeNode[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            ObjectName objName = insts[i].getObjectName();
            destinations[i] = this.createDestinationItem(objName);
        }
        return destinations;
    }

    private ResourceTreeNode createDestinationItem(ObjectName objName) throws Exception {
        String destinationName = objName.getKeyProperty("name");
        String type = objName.getKeyProperty("service");
        String className = this.mbeanServer.getMBeanInfo(objName).getClassName();
        String fileName = "";
        if (type.equalsIgnoreCase("Queue")) {
            fileName = "Queue.jsp";
        } else if (type.equalsIgnoreCase("Topic")) {
            fileName = "Topic.jsp";
        }
        SimpleResourceTreeNode item = this.createResourceNode(destinationName, type, "images/serviceset.gif", fileName + "?ObjectName=" + this.encode(objName.toString()), null, null, null, objName.toString(), className);
        return item;
    }
}

