/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.util.ArrayList;
import org.compiere.controller.UIField;
import org.compiere.controller.UIFieldVO;
import org.compiere.controller.UIFieldVOFactory;
import org.compiere.controller.UITab;
import org.compiere.controller.UITabVO;
import org.compiere.controller.UIWindowVO;
import org.compiere.model.MSession;
import org.compiere.util.CContext;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWindow
extends UIWindowVO {
    private CContext m_ctx = null;
    private ArrayList<UIField> m_fields = null;
    private static int s_AD_Field_ID = 800000;

    public UIWindow(UIWindowVO vo, CContext ctx) {
        super(vo);
        this.m_ctx = ctx;
        MSession session = MSession.get(this.m_ctx, true);
        session.windowLog(this.m_ctx.getAD_Client_ID(), this.m_ctx.getAD_Org_ID(), this.getAD_Window_ID(), 0);
    }

    public ArrayList<UITab> getTabs() {
        if (this.p_vos == null) {
            return null;
        }
        ArrayList<UITab> retValue = new ArrayList<UITab>(this.p_vos.size());
        for (int i = 0; i < this.p_vos.size(); ++i) {
            UITab tab = (UITab)this.p_vos.get(i);
            retValue.add(tab);
        }
        return retValue;
    }

    public void setTabVOs(ArrayList<UITabVO> tabsVO, int WindowNo) {
        if (tabsVO == null) {
            this.p_vos = null;
        } else {
            this.p_vos = new ArrayList(tabsVO.size());
            for (int i = 0; i < tabsVO.size(); ++i) {
                ArrayList<UIField> fields;
                UITab tab = new UITab(tabsVO.get(i));
                ArrayList<UITab> previousTabs = this.getTabs();
                if (tab.getReferenced_Tab_ID() != 0) {
                    fields = this.getReferencedFields(tab.getReferenced_Tab_ID());
                    tab.initialize(fields, previousTabs, this.m_ctx, WindowNo, i, this.isSOTrx());
                } else {
                    fields = this.getFields(tab.getAD_Tab_ID());
                    tab.initialize(fields, previousTabs, this.m_ctx, WindowNo, i, this.isSOTrx());
                }
                this.p_vos.add(tab);
            }
        }
    }

    public ArrayList<UIField> getFields() {
        return this.m_fields;
    }

    private ArrayList<UIField> getFields(int AD_Tab_ID) {
        UIField created = null;
        UIField createdBy = null;
        UIField updated = null;
        UIField updatedBy = null;
        ArrayList<UIField> retValue = new ArrayList<UIField>();
        for (int i = 0; i < this.m_fields.size(); ++i) {
            UIField field = this.m_fields.get(i);
            if (field.getAD_Tab_ID() != AD_Tab_ID) continue;
            retValue.add(field);
            String columnName = field.getColumnName();
            if (columnName.equals("Created")) {
                created = field;
                continue;
            }
            if (columnName.equals("Updated")) {
                updated = field;
                continue;
            }
            if (columnName.equals("CreatedBy")) {
                createdBy = field;
                continue;
            }
            if (!columnName.equals("UpdatedBy")) continue;
            updatedBy = field;
        }
        if (created == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, true, false));
        }
        if (createdBy == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, true, true));
        }
        if (updated == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, false, false));
        }
        if (updatedBy == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, false, true));
        }
        return retValue;
    }

    private ArrayList<UIField> getReferencedFields(int AD_Tab_ID) {
        UIFieldVOFactory fieldFactory = new UIFieldVOFactory();
        ArrayList<UIFieldVO> fields = fieldFactory.getReferenced(this.m_ctx, AD_Tab_ID, this.getAD_UserDef_Win_ID());
        UIField created = null;
        UIField createdBy = null;
        UIField updated = null;
        UIField updatedBy = null;
        ArrayList<UIField> retValue = new ArrayList<UIField>();
        for (int i = 0; i < fields.size(); ++i) {
            UIField field = new UIField(fields.get(i));
            field.setAD_Window_ID(this.getAD_Window_ID());
            retValue.add(field);
            String columnName = field.getColumnName();
            if (columnName.equals("Created")) {
                created = field;
                continue;
            }
            if (columnName.equals("Updated")) {
                updated = field;
                continue;
            }
            if (columnName.equals("CreatedBy")) {
                createdBy = field;
                continue;
            }
            if (!columnName.equals("UpdatedBy")) continue;
            updatedBy = field;
        }
        if (created == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, true, false));
        }
        if (createdBy == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, true, true));
        }
        if (updated == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, false, false));
        }
        if (updatedBy == null) {
            retValue.add(this.createStdColumn(AD_Tab_ID, false, true));
        }
        return retValue;
    }

    private UIField createStdColumn(int AD_Tab_ID, boolean created, boolean by) {
        String columnName;
        UIFieldVO vo = new UIFieldVO();
        String string = columnName = created ? "Created" : "Updated";
        if (by) {
            columnName = columnName + "By";
        }
        vo.setColumnName(columnName);
        vo.setName(Msg.getElement(this.m_ctx, columnName));
        vo.setIsDisplayed(false);
        vo.setIsReadOnly(true);
        if (by) {
            vo.setAD_Reference_ID(18);
            int AD_Reference_Value_ID = 110;
            vo.setAD_Reference_Value_ID(AD_Reference_Value_ID);
        } else {
            vo.setAD_Reference_ID(16);
        }
        vo.setAD_Window_ID(this.getAD_Window_ID());
        vo.setAD_Tab_ID(AD_Tab_ID);
        int AD_Field_ID = s_AD_Field_ID++;
        vo.setAD_Field_ID(AD_Field_ID);
        UIField ui = new UIField(vo);
        return ui;
    }

    public void setFields(ArrayList<UIFieldVO> fields) {
        this.m_fields = new ArrayList(fields.size());
        this.addFields(fields);
    }

    public void addFields(ArrayList<UIFieldVO> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            this.m_fields.add(new UIField(fields.get(i)));
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("UIWindow[").append(this.getName());
        if (this.p_vos != null) {
            sb.append(";#Tabs=").append(this.p_vos.size());
        }
        if (this.m_fields != null) {
            sb.append(";#Fields=").append(this.m_fields.size());
        }
        sb.append("]");
        return sb.toString();
    }
}

