/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.util.TreeMap;

public class ConvertMap {
    private static TreeMap<String, String> s_pg = new TreeMap();
    private static TreeMap<String, String> s_db2 = new TreeMap();
    private static TreeMap<String, String> s_ms = new TreeMap();

    public static TreeMap getPGMap() {
        if (s_pg.size() == 0) {
            ConvertMap.initPG();
        }
        return s_pg;
    }

    public static TreeMap getDB2Map() {
        if (s_db2.size() == 0) {
            ConvertMap.initDB2();
        }
        return s_db2;
    }

    public static TreeMap getMSMap() {
        if (s_ms.size() == 0) {
            ConvertMap.initSQLServer();
        }
        return s_ms;
    }

    private static void initPG() {
        s_pg.put("\\bNUMBER\\b", "NUMERIC");
        s_pg.put("\\bDATE\\b", "TIMESTAMP");
        s_pg.put("\\bNVARCHAR\\b", "VARCHAR");
        s_pg.put("\\bNVARCHAR2\\b", "VARCHAR");
        s_pg.put("\\bVARCHAR2\\b", "VARCHAR");
        s_pg.put("\\bbpchar\\b", "CHAR");
        s_pg.put("\\bNCHAR\\b", "CHAR");
        s_pg.put("\\bBLOB\\b", "BYTEA");
        s_pg.put("\\bCLOB\\b", "TEXT");
        s_pg.put("\\bMODIFY\\b", "ALTER");
        s_pg.put("\\bUSING INDEX\\b", "");
        s_pg.put("\\bTABLESPACE\\s\\w+\\b", "");
        s_pg.put("\\bSTORAGE\\([\\w\\s]+\\)", "");
        s_pg.put("\\bBITMAP INDEX\\b", "INDEX");
        s_pg.put("\\bSysDate\\b", "CURRENT_TIMESTAMP");
        s_pg.put("\\bSYSDATE\\b", "CURRENT_TIMESTAMP");
        s_pg.put("\\bNVL\\b", "COALESCE");
        s_pg.put("\\bTO_DATE\\b", "TO_TIMESTAMP");
        s_pg.put("\\bTO_NCHAR\\b", "TO_CHAR");
        s_pg.put("\\bDBMS_OUTPUT.PUT_LINE\\b", "RAISE NOTICE");
        s_pg.put("\\bGLOBAL TEMPORARY\\b", "TEMPORARY");
        s_pg.put("\\bON COMMIT DELETE ROWS\\b", "");
        s_pg.put("\\bON COMMIT PRESERVE ROWS\\b", "");
        s_pg.put("\\bCASCADE CONSTRAINTS\\b", "");
        s_pg.put("\\bELSIF\\b", "ELSE IF");
        s_pg.put("\\bEND CASE\\b", "END");
        s_pg.put("\\bFROM DUAL\\b", "");
        s_pg.put("\\bSTART WITH\\b", "START");
        s_pg.put("\\bINCREMENT BY\\b", "INCREMENT");
    }

    private static void initDB2() {
        s_db2.put("\\bTO_NCHAR\\b", "CHAR");
        s_db2.put("\\bNUMBER\\b", "DECIMAL(31,6)");
        s_db2.put("\\bDATE\\b", "TIMESTAMP");
        s_db2.put("\\bVARCHAR2\\b", "VARCHAR");
        s_db2.put("\\bNVARCHAR2\\b", "VARCHAR");
        s_db2.put("\\bNCHAR\\b", "CHAR");
        s_db2.put("\\bCACHE\\b", "");
        s_db2.put("\\bUSING INDEX\\b", "");
        s_db2.put("\\bTABLESPACE\\s\\w+\\b", "");
        s_db2.put("\\bSTORAGE\\([\\w\\s]+\\)", "");
        s_db2.put("\\bBITMAP INDEX\\b", "INDEX");
        s_db2.put("\\bSysDate\\b", "CURRENT_TIMESTAMP");
        s_db2.put("\\bSYSDATE\\b", "CURRENT_TIMESTAMP");
        s_db2.put("\\bNVL\\b", "COALESCE");
        s_db2.put("\\bTO_DATE\\b", "TIMESTAMP");
        s_db2.put("\\bDBMS_OUTPUT.PUT_LINE\\b", "RAISE NOTICE");
        s_db2.put("\\bGLOBAL TEMPORARY\\b", "TEMPORARY");
        s_db2.put("\\bON COMMIT DELETE ROWS\\b", "");
        s_db2.put("\\bON COMMIT PRESERVE ROWS\\b", "");
        s_db2.put("\\bCASCADE CONSTRAINTS\\b", "");
        s_db2.put(",NULL\\b", ",'' ");
        s_db2.put(", NULL\\b", ",'' ");
        s_db2.put(",NULL,", ",'',");
        s_db2.put("SELECT NULL,", "SELECT '',");
        s_db2.put("\\sFROM\\s+DUAL\\b", " FROM SYSIBM.SYSDUMMY1 ");
        s_db2.put("\\bELSIF\\b", "ELSE IF");
        s_db2.put("\\bSTART WITH\\b", "START");
        s_db2.put("\\bINCREMENT BY\\b", "INCREMENT");
    }

    private static void initSQLServer() {
        s_ms.put("\\bNUMBER\\b", "NUMERIC");
        s_ms.put("\\bDATE\\b", "DATETIME");
        s_ms.put("\\bVARCHAR2\\b", "VARCHAR");
        s_ms.put("\\bNVARCHAR2\\b", "NVARCHAR");
        s_ms.put("\\bBLOB\\b", "VARBINARY(MAX)");
        s_ms.put("\\bCLOB\\b", "NTEXT");
        s_ms.put("\\bUSING INDEX\\b", "");
        s_ms.put("\\bTABLESPACE\\s\\w+\\b", "");
        s_ms.put("\\bSTORAGE\\([\\w\\s]+\\)", "");
        s_ms.put("\\bBITMAP INDEX\\b", "INDEX");
        s_ms.put("\\bSysDate\\b", "getdate()");
        s_ms.put("\\bsysDate\\b", "getdate()");
        s_ms.put("\\bacctBalance\\b", "[compiere].ACCTBALANCE");
        s_ms.put("\\baddDays\\b", "[compiere].ADDDAYS");
        s_ms.put("\\bbomPriceLimit\\b", "[compiere].BOMPRICELIMIT");
        s_ms.put("\\bbomPriceList\\b", "[compiere].BOMPRICELIST");
        s_ms.put("\\bbomPriceStd\\b", "[compiere].BOMPRICESTD");
        s_ms.put("\\bbomQtyAvailable\\b", "[compiere].BOMQTYAVAILABLE");
        s_ms.put("\\bbomQtyOnHand\\b", "[compiere].BOMQTYONHAND");
        s_ms.put("\\bbomQtyOrdered\\b", "[compiere].BOMQTYORDERED");
        s_ms.put("\\bbomQtyReserved\\b", "[compiere].BOMQTYRESERVED");
        s_ms.put("\\bbpartnerRemitLocation\\b", "[compiere].BPARTNERREMITLOCATION");
        s_ms.put("\\bcharAt\\b", "[compiere].CHARAT");
        s_ms.put("\\bcurrencyBase\\b", "[compiere].CURRENCYBASE");
        s_ms.put("\\bcurrencyConvert\\b", "[compiere].CURRENCYCONVERT");
        s_ms.put("\\bcurrencyRate\\(\\b", "[compiere].CURRENCYRATE(");
        s_ms.put("\\bcurrencyRound\\b", "[compiere].CURRENCYROUND");
        s_ms.put("\\bdaysBetween\\b", "[compiere].DAYSBETWEEN");
        s_ms.put("\\bfirstOf\\b", "[compiere].FIRSTOF");
        s_ms.put("\\bgetChars\\b", "[compiere].GETCHARS");
        s_ms.put("\\bgetDaysBetween\\b", "[compiere].GETDAYSBETWEEN");
        s_ms.put("\\binvoiceDiscount\\b", "[compiere].INVOICEDISCOUNT");
        s_ms.put("\\binvoiceOpen\\b", "[compiere].INVOICEOPEN");
        s_ms.put("\\binvoicePaid\\b", "[compiere].INVOICEPAID");
        s_ms.put("\\bpaymentAllocated\\b", "[compiere].PAYMENTALLOCATED");
        s_ms.put("\\bpaymentAvailable\\b", "[compiere].PAYMENTAVAILABLE");
        s_ms.put("\\bpaymentTermDiscount\\b", "[compiere].PAYMENTTERMDISCOUNT");
        s_ms.put("\\bpaymentTermDueDate\\b", "[compiere].PAYMENTTERMDUEDATE");
        s_ms.put("\\bpaymentTermDueDays\\b", "[compiere].PAYMENTTERMDUEDAYS");
        s_ms.put("\\bproductAttribute\\b", "[compiere].PRODUCTATTRIBUTE");
        s_ms.put("\\bTRUNC_DATE\\b", "[compiere].TRUNC_DATE");
        s_ms.put("\\bTRUNC2_DATE\\b", "[compiere].TRUNC2_DATE");
        s_ms.put("\\bDUMP\\b", "[compiere].STRDUMP");
        s_ms.put("\\bTO_NCHAR\\b", "STR");
        s_ms.put("\\bTO_CHAR\\b", "STR");
        s_ms.put("\\bNVL\\b", "COALESCE");
        s_ms.put("\\bTO_CHAR\\b", "[compiere].TO_CHAR");
        s_ms.put("\\bTO_DATE\\b", "[compiere].TO_DATE");
        s_ms.put("\\bTRIM\\b", "[compiere].TRIM");
        s_ms.put("\\bDBMS_OUTPUT.PUT_LINE\\b", "PRINT");
        s_ms.put("\\bGLOBAL TEMPORARY\\b", "TEMPORARY");
        s_ms.put("\\bON COMMIT DELETE ROWS\\b", "");
        s_ms.put("\\bON COMMIT PRESERVE ROWS\\b", "");
        s_ms.put("\\bCASCADE CONSTRAINTS\\b", "");
        s_ms.put("\\sFROM\\s+DUAL\\b", "");
        s_ms.put("\\bELSIF\\b", "ELSE IF");
        s_ms.put("\\bEND CASE\\b", "END");
        s_ms.put("\\bLineNo\\b", "[LineNo]");
    }
}

