/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.compiere.Compiere;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class DBUtils {
    private static CLogger log = CLogger.getCLogger(DBUtils.class);
    private static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

    public static String repRownum(String oraS) {
        if (oraS == null || oraS.length() == 0) {
            return oraS;
        }
        int irn = oraS.indexOf(" ROWNUM=1");
        if (irn == -1) {
            return oraS;
        }
        int isel = 0;
        int ire = 0;
        int iFrom = 0;
        String cid = null;
        ire = oraS.indexOf(")", irn);
        if (ire == -1) {
            ire = oraS.length();
        }
        String sq = oraS.substring(0, ire + 1);
        int iselt = isel;
        while (iselt < ire && isel != -1) {
            iselt = sq.indexOf("SELECT");
            if (iselt == -1) continue;
            isel = iselt;
        }
        iFrom = sq.indexOf(" FROM ", isel);
        String[] tabIDs = (sq = sq.substring(iFrom + 5, ire)).split(" ", 3);
        if (!tabIDs[1].equals(",") && !tabIDs.equals("WHERE")) {
            cid = tabIDs[1] + ".";
        }
        sq = oraS.substring(iFrom, oraS.charAt(ire) == ')' ? ire : ire + 1);
        String cid1 = null;
        if (cid != null) {
            cid1 = cid.substring(0, cid.length()) + "1.";
            sq = sq.replaceAll(cid, cid1);
        }
        StringBuffer sql = new StringBuffer(oraS.substring(0, irn));
        sql.append(cid + "UPDATED in ( SELECT MAX(" + cid1 + "UPDATED) " + sq + ") ");
        if (ire < oraS.length()) {
            sql.append(oraS.substring(ire + 1, oraS.length()));
        }
        return sql.toString();
    }

    public static String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "trunc(getdate(), 'DD')";
            }
            return "getdate()";
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        StringBuffer dateString = new StringBuffer("TIMESTAMP('");
        if (dayOnly) {
            int yyyy = cal.get(1);
            dateString.append(yyyy).append(DBUtils.getXX(cal.get(2) + 1)).append(DBUtils.getXX(cal.get(5))).append("000000").append("')");
        } else {
            int yyyy = cal.get(1);
            dateString.append(yyyy).append(DBUtils.getXX(cal.get(2) + 1)).append(DBUtils.getXX(cal.get(5))).append(DBUtils.getXX(cal.get(11))).append(DBUtils.getXX(cal.get(12))).append(DBUtils.getXX(cal.get(13))).append("')");
        }
        return dateString.toString();
    }

    private static String getXX(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return String.valueOf(x);
    }

    public static String TO_CHAR(String columnName, int displayType, String AD_Language) {
        if (DisplayType.isDate((int)displayType)) {
            return " Time2Chars(" + columnName + ") ";
        }
        if (DisplayType.isNumeric((int)displayType)) {
            return " getChars(" + columnName + ") ";
        }
        return "";
    }

    public static String nullValue(String sqlClause, int dataType) {
        if (sqlClause == "I") {
            switch (dataType) {
                case 4: {
                    return "nullif(0,0)";
                }
                case 3: {
                    return "nullif(0.1,0.1)";
                }
                case 93: {
                    return "nullif(Timestamp('20061012000000'),Timestamp('20061012000000'))";
                }
                case 12: {
                    return "nullif('a','a')";
                }
            }
            return "''";
        }
        return "''";
    }

    public static String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (number.scale() > scale) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception e) {
                log.severe("Number=" + number + ", Scale=" + " - " + e.getMessage());
            }
        }
        return result.toString();
    }

    public static String whereSelectList(String sql) {
        String s = DBUtils.whereSelectList1(sql, "IN");
        s = DBUtils.whereSelectList1(s, "NOT IN");
        return s;
    }

    private static String whereSelectList1(String sql, String notIn) {
        String keyword = null;
        keyword = notIn.equals("IN") ? ") IN (" : ") NOT IN (";
        int ixIn = sql.indexOf(keyword + "SELECT");
        if (ixIn == -1) {
            return sql;
        }
        StringBuffer newSQL = new StringBuffer();
        int copyBegin = 0;
        int isql = sql.length();
        while (ixIn > -1) {
            int iColEnd = ixIn;
            int iCol = iColEnd - 1;
            int iSelect = ixIn + keyword.length();
            int il = 1;
            int ir = 0;
            int iFrom = sql.indexOf(" FROM ", iSelect += 6);
            ir = 1;
            il = 0;
            while (il < ir && --iCol >= 0) {
                if (sql.charAt(iCol) == ')') {
                    ++ir;
                    continue;
                }
                if (sql.charAt(iCol) != '(') continue;
                ++il;
            }
            if (copyBegin < iCol) {
                newSQL = newSQL.append(sql.substring(copyBegin, iCol));
            }
            String[] colList = sql.substring(iCol + 1, iColEnd).split(",");
            String[] tableNames = sql.substring(iFrom, isql).split(" ");
            String[] selectList = sql.substring(iSelect, iFrom).split(",");
            StringBuffer colList1 = new StringBuffer();
            StringBuffer selectList1 = new StringBuffer();
            MTable mt = MTable.get(Env.getCtx(), tableNames[2].trim());
            for (int i = 0; i < colList.length; ++i) {
                if (i > 0) {
                    colList1.append(" || ");
                    selectList1.append(" || ");
                }
                colList[i] = colList[i].trim();
                selectList[i] = selectList[i].trim();
                MColumn mc = mt.getColumn(colList[i]);
                if (mc == null) {
                    log.severe("Wrong column:" + colList[i] + ": in sql: " + sql);
                    return sql;
                }
                int dt = mt.getColumn(colList[i]).getAD_Reference_ID();
                colList1.append(DB.TO_CHAR(colList[i], dt, Env.getAD_Language(Env.getCtx())));
                selectList1.append(DB.TO_CHAR(selectList[i], dt, Env.getAD_Language(Env.getCtx())));
            }
            newSQL.append(" " + colList1 + keyword.substring(1) + "SELECT " + selectList1);
            copyBegin = iFrom;
            ixIn = sql.indexOf(keyword + "SELECT", copyBegin);
        }
        if (copyBegin < isql) {
            newSQL.append(sql.substring(copyBegin, isql));
        }
        return newSQL.toString();
    }

    public static String updateSetSelectList(String sql) {
        StringBuffer newSQL = null;
        int iSet = sql.indexOf(" SET (");
        int iSetEnd = sql.indexOf(")", iSet);
        int iSelect = sql.indexOf("(SELECT ", iSetEnd);
        int iSelectEnd = sql.indexOf(" FROM ", iSelect);
        int il = 1;
        int ir = 0;
        int isql = sql.length();
        if (iSet == -1 || iSetEnd == -1 || iSelect == -1 || iSelectEnd == -1) {
            return sql;
        }
        String[] setList = sql.substring(iSet + 6, iSetEnd).split(",");
        String[] selectList = null;
        String selListStr = sql.substring(iSelect + 7, iSelectEnd);
        selectList = selListStr.indexOf(")") > 0 ? selListStr.split(", ") : selListStr.split(",");
        int end = iSelectEnd + 5;
        while (il > ir && ++end < isql) {
            if (sql.charAt(end) == ')') {
                ++ir;
                continue;
            }
            if (sql.charAt(end) != '(') continue;
            ++il;
        }
        if (end < isql) {
            ++end;
        }
        newSQL = new StringBuffer(sql.substring(0, iSet + 5));
        for (int i = 0; i < setList.length; ++i) {
            if (i > 0) {
                newSQL.append(" , ");
            }
            newSQL.append(setList[i] + " = (SELECT " + selectList[i] + " " + sql.substring(iSelectEnd, end));
        }
        if (end <= isql) {
            newSQL.append(sql.substring(end, isql));
        }
        return newSQL.toString();
    }

    public static void main(String[] args) {
        String s = DBUtils.updateSetSelectList("UPDATE T_Report SET Col_0 = (SELECT  COALESCE(SUM(Col_0),0)  FROM T_Report WHERE AD_PInstance_ID=1000014 AND PA_ReportLine_ID IN (0,0) AND ABS(LevelNo)<1) WHERE AD_PInstance_ID=1000014 AND PA_ReportLine_ID=100 AND ABS(LevelNo)<1");
        System.out.println(s);
        Compiere.startup(true);
        s = DBUtils.whereSelectList("DELETE FROM C_PeriodControl WHERE (C_Period_ID, DocBaseType) IN (SELECT C_Period_ID, DocBaseType FROM C_PeriodControl pc2 GROUP BY C_Period_ID, DocBaseType HAVING COUNT(*) > 1) AND C_PeriodControl_ID NOT IN (SELECT MIN(C_PeriodControl_ID) FROM C_PeriodControl pc3 GROUP BY C_Period_ID, DocBaseType)");
        System.out.println(s);
        s = DBUtils.whereSelectList("DELETE FROM C_PeriodControl WHERE (C_Period_ID, DocBaseType) NOT IN (SELECT C_Period_ID, DocBaseType FROM C_PeriodControl pc2 GROUP BY C_Period_ID, DocBaseType HAVING COUNT(*) > 1) AND C_PeriodControl_ID NOT IN (SELECT MIN(C_PeriodControl_ID) FROM C_PeriodControl pc3 GROUP BY C_Period_ID, DocBaseType)");
        System.out.println(s);
    }
}

