/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.edb.Driver;
import com.edb.ds.PGPoolingDataSource;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.compiere.db.CConnection;
import org.compiere.db.CompiereDatabase;
import org.compiere.db.Convert;
import org.compiere.db.DBUtils;
import org.compiere.db.Database;
import org.compiere.startup.Environment;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class DB_PostgreSQL
implements CompiereDatabase {
    private static Driver s_driver = null;
    public static final String DRIVER = "com.edb.Driver";
    public static final int DEFAULT_PORT = 5432;
    public static final String DEFAULT_DBNAME = "compiere";
    public static final String DEFAULT_USER_NAME = "compiere";
    private Convert m_convert = new Convert("postgreSQL");
    private String m_connectionURL;
    private PGPoolingDataSource m_ds = null;
    private String m_userName = null;
    private static CLogger log = CLogger.getCLogger(DB_PostgreSQL.class);

    public DB_PostgreSQL() {
        try {
            this.getDriver();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public boolean isConnectionValid(Connection conn) {
        return true;
    }

    public String getName() {
        return "postgreSQL";
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 5432;
    }

    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            s_driver = new Driver();
            DriverManager.registerDriver((java.sql.Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:edb://").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
        this.m_connectionURL = sb.toString();
        log.config(this.m_connectionURL);
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:edb://" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName;
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_EnterpriseDB[");
        sb.append(this.m_connectionURL);
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer("---");
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        String ncrid1;
        String crid1;
        int i;
        String[] sep;
        String[] tokens;
        oraStatement = oraStatement.trim();
        while (oraStatement.startsWith("\t")) {
            oraStatement = oraStatement.replace("\t", "");
        }
        if (oraStatement.startsWith("ALTER TABLE") && oraStatement.indexOf(" MODIFY ") > 0) {
            tokens = oraStatement.split(" ");
            String sql = "ALTER TABLE " + tokens[2] + " ALTER " + tokens[4];
            int idef = oraStatement.indexOf(" DEFAULT ");
            if (idef > 0 || oraStatement.indexOf(" NULL") < 0) {
                int i2 = sql.length() + 1;
                if (idef > 0) {
                    if (!"DEFAULT".equals(tokens[5]) && tokens[5].length() != 0) {
                        sql = sql + " TYPE " + oraStatement.substring(i2, idef + 1);
                        sql = sql + ", ALTER " + tokens[4];
                    }
                    sql = sql + " SET DEFAULT " + oraStatement.substring(idef + 9, oraStatement.length());
                } else {
                    int rpDrop = 0;
                    if (oraStatement.indexOf(" MODIFY (") > 0 || oraStatement.indexOf(" MODIFY(") > 0) {
                        rpDrop = 1;
                    }
                    sql = sql + " TYPE " + oraStatement.substring(i2, oraStatement.length() - rpDrop);
                }
                oraStatement = sql;
            } else {
                if (oraStatement.indexOf(" NOT NULL") > 0) {
                    sql = sql + " SET NOT NULL";
                    return sql;
                }
                if (oraStatement.indexOf(" NULL") > 0) {
                    sql = sql + " DROP NOT NULL";
                    return sql;
                }
            }
        }
        if (oraStatement.startsWith("CREATE UNIQUE INDEX ") && oraStatement.indexOf("TO_NCHAR(AD_User_ID)") > 0) {
            oraStatement = oraStatement.replace("TO_NCHAR(AD_User_ID)", "TO_CHAR(AD_User_ID,'9999999')::VARCHAR");
        }
        if (oraStatement.startsWith("ALTER TABLE") && oraStatement.indexOf(" ADD (") > 0) {
            oraStatement = oraStatement.replace(" ADD (", " ADD ");
            oraStatement = oraStatement.substring(0, oraStatement.length() - 1);
        }
        if (oraStatement.startsWith("UPDATE")) {
            while (oraStatement.indexOf(9) > -1) {
                oraStatement = oraStatement.replace('\t', ' ');
            }
            tokens = oraStatement.split(" ");
            if (!"SET".equals(tokens[2].toUpperCase())) {
                sep = new String[]{" ", "=", ">", "<", "(", ","};
                String crid = tokens[2] + ".";
                String ncrid = tokens[1] + ".";
                oraStatement = oraStatement.replace(" " + tokens[2] + " ", " ");
                for (i = 0; i < sep.length; ++i) {
                    crid1 = (sep[i] + crid).toUpperCase();
                    ncrid1 = sep[i] + ncrid;
                    int l = crid1.length();
                    int ix = oraStatement.toUpperCase().indexOf(crid1);
                    while (ix > -1) {
                        int sl = oraStatement.length();
                        oraStatement = oraStatement.substring(0, ix) + ncrid1 + oraStatement.substring(ix + l, sl);
                        ix = oraStatement.toUpperCase().indexOf(crid1);
                    }
                }
            }
            oraStatement = DBUtils.updateSetSelectList(oraStatement);
        }
        if (oraStatement.startsWith("DELETE FROM ") && (tokens = oraStatement.split(" ")).length > 3 && !"WHERE".equals(tokens[3])) {
            sep = new String[]{" ", "=", ">", "<", "(", ","};
            String crid = tokens[3] + ".";
            String ncrid = tokens[2] + ".";
            oraStatement = oraStatement.replace(" " + tokens[3] + " ", " ");
            for (i = 0; i < sep.length; ++i) {
                crid1 = sep[i] + crid;
                ncrid1 = sep[i] + ncrid;
                while (oraStatement.indexOf(crid1) > -1) {
                    oraStatement = oraStatement.replace(crid1, ncrid1);
                }
            }
        }
        while (oraStatement.indexOf("NUMBER(10,0)") > -1) {
            oraStatement = oraStatement.replace("NUMBER(10,0)", "INTEGER");
        }
        while (oraStatement.indexOf("NUMBER(10)") > -1) {
            oraStatement = oraStatement.replace("NUMBER(10)", "INTEGER");
        }
        while (oraStatement.indexOf("NUMERIC(10,0)") > -1) {
            oraStatement = oraStatement.replace("NUMERIC(10,0)", "INTEGER");
        }
        while (oraStatement.indexOf("NUMERIC(10)") > -1) {
            oraStatement = oraStatement.replace("NUMERIC(10)", "INTEGER");
        }
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue == null) {
            log.severe("Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
            return oraStatement;
        }
        if (retValue.length != 1) {
            log.warning("Convert error! Converted statement Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            return oraStatement;
        }
        if (CLogMgt.isLevelFinest() && !oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1) {
            String statement1 = Util.cleanWhitespace(retValue[0]);
            String statement2 = Util.cleanWhitespace(oraStatement);
            System.out.println("PostgreSQL =>" + statement1 + "<=\n" + "           =<" + statement2 + ">=");
        }
        return retValue[0];
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.toUpperCase().endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public String getSystemUser() {
        return "enterprisedb";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(now())";
            }
            return "now()";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(".")));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric((int)displayType)) {
            if (displayType == 12) {
                retValue.append(",'9G999G990D00'");
            }
        } else if (DisplayType.isDate((int)displayType)) {
            retValue.append(",'").append(Language.getLanguage(AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            this.m_ds = new PGPoolingDataSource();
            this.m_ds.setServerName(connection.getDbHost());
            this.m_ds.setDatabaseName(connection.getDbName());
            this.m_ds.setPortNumber(connection.getDbPort());
            this.m_ds.setUser(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setDataSourceName("CompiereDS");
            if (Ini.isClient()) {
                this.m_ds.setInitialConnections(3);
            } else {
                this.m_ds.setInitialConnections(3);
            }
            log.config(this.toString());
            return this.m_ds;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.toString(), e);
            return null;
        }
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        Exception exception = null;
        try {
            this.getDataSource(connection);
            for (int i = 0; i < 5; ++i) {
                block12: {
                    try {
                        conn = this.m_ds.getConnection();
                        if (conn == null) break block12;
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() == autoCommit) break block12;
                        conn.setAutoCommit(autoCommit);
                    }
                    catch (Exception e) {
                        exception = e;
                        conn = null;
                        if (!(e instanceof SQLException) || ((SQLException)e).getErrorCode() != 1017) break block12;
                        log.severe("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                        break;
                    }
                }
                try {
                    if (conn != null && conn.isClosed()) {
                        conn = null;
                    }
                    if (conn != null && !conn.isClosed()) break;
                    if (i == 0) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                }
            }
            if (conn == null && exception != null) {
                log.log(Level.SEVERE, exception.toString());
                log.fine(this.toString());
                log.finest("Reference=" + this.m_ds.getReference());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        log.config(this.toString());
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_ds = null;
    }

    public String getDataType(int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        switch (displayType) {
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                retValue = "INTEGER";
                break;
            }
            case 12: 
            case 29: 
            case 37: {
                retValue = "NUMERIC";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 23: {
                retValue = "TYPEA";
                break;
            }
            case 28: {
                retValue = "CHAR(1)";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                retValue = "TIMESTAMP";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT now()";
                break;
            }
            case 11: {
                retValue = "INTEGER";
                break;
            }
            case 17: {
                retValue = "CHAR(" + precision + ")";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                retValue = "VARCHAR(" + precision + ")";
                break;
            }
            case 36: {
                retValue = "TEXT";
                break;
            }
            case 20: {
                retValue = "CHAR(1)";
                break;
            }
            default: {
                log.severe("Unknown: " + displayType);
            }
        }
        return retValue;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String updateSetSelectList(String sql) {
        return sql;
    }

    public String nullValue(String sqlClause, int dataType) {
        return "NULL";
    }

    public Clob getClob(Connection con, String clobString) {
        return null;
    }

    public Blob getBlob(Connection con, byte[] bytes) {
        return null;
    }

    public static void main(String[] args) {
        Ini.loadProperties(false);
        Ini.setProperty("Connection", "");
        Environment env = Environment.get();
        env.setHost(null);
        env.setProperty("COMPIERE_DB_TYPE", "postgreSQL");
        env.setProperty("COMPIERE_DB_PATH", "postgreSQL");
        env.setProperty("COMPIERE_DB_NAME", "compiere");
        env.setProperty("COMPIERE_DB_PORT", String.valueOf(5432));
        env.setProperty("COMPIERE_DB_USER", "compiere");
        env.setProperty("COMPIERE_DB_PASSWORD", "compiere");
        CConnection cc = CConnection.get();
        DB_PostgreSQL db = (DB_PostgreSQL)cc.getDatabase();
        DB.setDBTarget(cc);
        Connection connD = null;
        Connection connS = null;
        Connection connC = null;
        try {
            connD = db.getDriverConnection(cc);
            connD.setAutoCommit(false);
            System.out.println("Driver=" + connD);
            DataSource ds = db.getDataSource(cc);
            connS = ds.getConnection();
            System.out.println("DS=" + connS);
            connC = db.getCachedConnection(cc, true, 2);
            System.out.println("Cached=" + connC);
            System.out.println(db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < 4; ++i) {
            System.out.println("----> " + i);
            String sql = "SELECT * FROM AD_System";
            int index = 1;
            PreparedStatement psD = null;
            try {
                psD = connD.prepareStatement(sql);
                ResultSet rsD = psD.executeQuery();
                while (rsD.next()) {
                    String s = rsD.getString(index);
                }
                rsD.close();
                psD.close();
                psD = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (psD == null) continue;
                connD.commit();
                psD.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("--------------------------------------------------");
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getCachedConnection(cc, false, 2);
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            Connection conn3 = db.getCachedConnection(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getCachedConnection(cc, true, 2);
            conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        System.out.println("--------------------------------------------------");
        for (int i = 0; i < 1000; ++i) {
            System.out.println(i + " - " + DB.createConnection(true, 2));
        }
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            System.out.println(db);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

