/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.compiere.Compiere;
import org.compiere.db.CConnection;
import org.compiere.db.CConnectionDialog;
import org.compiere.db.CompiereDatabase;
import org.compiere.db.Convert;
import org.compiere.db.DBUtils;
import org.compiere.db.Database;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class DB_SQLServer
implements CompiereDatabase {
    private static SQLServerDriver s_driver = null;
    public static final String DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final int DEFAULT_PORT = 1433;
    private String m_connectionURL;
    private String m_userName = null;
    private SQLServerDataSource m_ds = null;
    private Convert m_convert = new Convert("sqlServer");
    private Connection m_conn = null;
    private static CLogger log = CLogger.getCLogger(DB_SQLServer.class);

    public String getName() {
        return "sqlServer";
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 1433;
    }

    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            s_driver = new SQLServerDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:sqlserver:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append(";databaseName=").append(connection.getDbName()).append(";");
        this.m_connectionURL = sb.toString();
        log.config(this.m_connectionURL);
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:sqlserver://" + dbHost + ":" + dbPort + ";databaseName=" + dbName + ";";
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_SQLServer[");
        sb.append(this.m_connectionURL);
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        int iwh;
        String[] tks;
        int i;
        String convertedStatement = new String(oraStatement).trim();
        String tmpString = "";
        int j = 0;
        while (j > -1) {
            boolean notDo;
            i = convertedStatement.indexOf("TRUNC", j);
            boolean bl = notDo = convertedStatement.startsWith("2_DATE", i + 5) || convertedStatement.startsWith("_DATE", i + 5);
            if (i < 0) break;
            int left = 0;
            for (int k = i; k < convertedStatement.length() && !notDo; ++k) {
                if (convertedStatement.charAt(k) == '(') {
                    ++left;
                    continue;
                }
                if (convertedStatement.charAt(k) == ',' && left == 1) {
                    tmpString = convertedStatement.substring(0, i);
                    convertedStatement = tmpString = tmpString + "TRUNC2_DATE" + convertedStatement.substring(i + 5);
                    break;
                }
                if (convertedStatement.charAt(k) != ')' || --left > 0) continue;
                tmpString = convertedStatement.substring(0, i);
                convertedStatement = tmpString = tmpString + "TRUNC_DATE" + convertedStatement.substring(i + 5);
                break;
            }
            j = i + 6;
        }
        if (convertedStatement.startsWith("ALTER TABLE") && convertedStatement.indexOf(" MODIFY ") > 0) {
            String[] tokens = convertedStatement.split(" ");
            String sql = "ALTER TABLE " + tokens[2];
            int idef = convertedStatement.indexOf(" DEFAULT ");
            if (idef < 0) {
                sql = sql + " ALTER COLUMN " + tokens[4];
                i = sql.length() - 6;
                if (idef > 0) {
                    sql = sql + convertedStatement.substring(i, idef + 1);
                    sql = sql + ", ALTER " + tokens[4] + " SET DEFAULT " + convertedStatement.substring(idef + 9, convertedStatement.length());
                } else {
                    sql = sql + " TYPE " + convertedStatement.substring(i, convertedStatement.length());
                }
                convertedStatement = sql;
            } else {
                if (convertedStatement.indexOf(" NOT NULL") > 0) {
                    sql = sql + " SET NOT NULL";
                    return sql;
                }
                if (convertedStatement.indexOf(" NULL") > 0) {
                    sql = sql + " DROP NOT NULL";
                    return sql;
                }
            }
        }
        if (convertedStatement.startsWith("CREATE TABLE") || convertedStatement.startsWith("ALTER TABLE")) {
            while (convertedStatement.indexOf("NUMBER(10,0)") > -1) {
                convertedStatement = convertedStatement.replace("NUMBER(10,0)", "INTEGER");
            }
            while (convertedStatement.indexOf("NUMBER(10)") > -1) {
                convertedStatement = convertedStatement.replace("NUMBER(10)", "INTEGER");
            }
        }
        if (convertedStatement.startsWith("CREATE UNIQUE INDEX ")) {
            if (convertedStatement.indexOf("COALESCE(UPPER(EMail),TO_NCHAR(AD_User_ID))") > -1) {
                convertedStatement = convertedStatement.replace("COALESCE(UPPER(EMail),TO_NCHAR(AD_User_ID))", "EMail");
                convertedStatement = convertedStatement.replace(" UNIQUE INDEX ", " INDEX ");
            }
            if (convertedStatement.indexOf("UPPER(ColumnName)") > -1) {
                convertedStatement = convertedStatement.replace("UPPER(ColumnName)", "ColumnName");
            }
            if (convertedStatement.indexOf(",UserElement1_ID,UserElement2_ID") > -1) {
                convertedStatement = convertedStatement.replace(",UserElement1_ID,UserElement2_ID", "");
            }
            if (convertedStatement.indexOf("CREATE UNIQUE INDEX M_Product_ExpenseType") > -1) {
                convertedStatement = convertedStatement.replace(" UNIQUE ", " ");
            }
            if (convertedStatement.indexOf("CREATE UNIQUE INDEX M_Product_Resource") > -1) {
                convertedStatement = convertedStatement.replace(" UNIQUE ", " ");
            }
        }
        if (convertedStatement.indexOf("('PK' || AD_Table_ID)") > 0 || convertedStatement.indexOf("('PK' + AD_Table_ID)") > 0) {
            convertedStatement = convertedStatement.replace(" AD_Table_ID)", " ltrim(str(AD_Table_ID)))");
        }
        if (convertedStatement.indexOf("('FK' || AD_Table_ID || '_' || AD_Column_ID)") > 0) {
            convertedStatement = convertedStatement.replace("('FK' || AD_Table_ID || '_' || AD_Column_ID)", "('FK' + ltrim(str(AD_Table_ID)) + '_' + ltrim(str(AD_Column_ID)))");
        } else if (convertedStatement.indexOf("('FK' + AD_Table_ID + '_' + AD_Column_ID)") > 0) {
            convertedStatement = convertedStatement.replace("('FK' + AD_Table_ID + '_' + AD_Column_ID)", "('FK' + ltrim(str(AD_Table_ID)) + '_' + ltrim(str(AD_Column_ID)))");
        }
        if (!convertedStatement.startsWith("INSERT INTO AD_Issue")) {
            convertedStatement = DBUtils.whereSelectList(convertedStatement);
        }
        if (convertedStatement.startsWith("UPDATE ") && (tks = convertedStatement.split(" ")).length > 4 && tks[3].trim().equalsIgnoreCase("SET")) {
            int iwh2 = convertedStatement.indexOf(" WHERE ");
            int iset = convertedStatement.indexOf(" SET ");
            if (iset > -1) {
                int isubQ = convertedStatement.indexOf("(SELECT ", iset);
                int lsql = convertedStatement.length();
                if (isubQ > -1 && isubQ < iwh2) {
                    int il = 1;
                    int ir = 0;
                    int ip = isubQ + 7;
                    while (il > ir && ++ip < lsql) {
                        if (convertedStatement.charAt(ip) == '(') {
                            ++il;
                            continue;
                        }
                        if (convertedStatement.charAt(ip) != ')') continue;
                        ++ir;
                    }
                    if (ip > iwh2) {
                        iwh2 = convertedStatement.indexOf(" WHERE ", ip);
                    }
                }
                convertedStatement = iwh2 > -1 ? "UPDATE " + tks[2] + convertedStatement.substring(iset, iwh2) + " FROM " + tks[1] + " " + tks[2] + convertedStatement.substring(iwh2, lsql) : "UPDATE " + tks[2] + convertedStatement.substring(iset, lsql) + " FROM " + tks[1] + " " + tks[2];
            }
        }
        if (convertedStatement.startsWith("DELETE FROM ") && (tks = convertedStatement.split(" ")).length > 5 && tks[4].trim().equalsIgnoreCase("WHERE") && (iwh = convertedStatement.indexOf(" WHERE ")) > -1) {
            int lsql = convertedStatement.length();
            convertedStatement = "DELETE " + tks[3] + " FROM " + tks[2] + " " + tks[3] + convertedStatement.substring(iwh, lsql);
        }
        while (convertedStatement.indexOf("||") > -1) {
            convertedStatement = convertedStatement.replace("||", "+");
        }
        String[] retValue = null;
        if (!convertedStatement.startsWith("CREATE FUNCTION") && !convertedStatement.startsWith("CREATE TRIGGER")) {
            retValue = this.m_convert.convert(convertedStatement);
        }
        if (retValue != null && retValue.length == 1) {
            convertedStatement = retValue[0];
        }
        if (convertedStatement.indexOf("[[LineNo]]") > -1) {
            convertedStatement = convertedStatement.replace("[[LineNo]]", "[LineNo]");
        }
        String curr_user = "[" + this.m_userName + "]";
        if (this.m_userName != null && !this.m_userName.equals("compiere")) {
            while (convertedStatement.indexOf("[compiere]") > -1) {
                convertedStatement = convertedStatement.replace("[compiere]", curr_user);
            }
        }
        String doubleCU = curr_user + "." + curr_user;
        while (convertedStatement.indexOf(doubleCU) > -1) {
            convertedStatement = convertedStatement.replace(doubleCU, curr_user);
        }
        if (!convertedStatement.startsWith("CREATE FUNCTION") && !convertedStatement.startsWith("CREATE TRIGGER")) {
            if (retValue == null) {
                log.severe("Not Converted (" + convertedStatement + ") - " + this.m_convert.getConversionError());
                return convertedStatement;
            }
            if (retValue.length != 1) {
                log.warning("Convert Command Number=" + retValue.length + " (" + convertedStatement + ") - " + this.m_convert.getConversionError());
                return convertedStatement;
            }
        }
        if (!convertedStatement.equals(oraStatement) && convertedStatement.indexOf("AD_Error") == -1) {
            log.finest("=>" + convertedStatement + "<= [" + oraStatement + "]");
        }
        if (!this.isSupported(convertedStatement)) {
            log.warning("MS SQL Server doesn't support this sql: " + oraStatement);
            return "";
        }
        return convertedStatement;
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        return "0";
    }

    public String getSystemUser() {
        return "sa";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "CAST(STR(YEAR(Getdate()))+'-'+STR(Month(Getdate()))+'-'+STR(Day(Getdate())) AS DATETIME)";
            }
            return "getdate()";
        }
        StringBuffer dateString = new StringBuffer("CAST('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("' AS DATETIME)");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(".")));
            dateString.append("' AS DATETIME)");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        if (DisplayType.isText((int)displayType) || DisplayType.isTextArea((int)displayType)) {
            return columnName;
        }
        StringBuffer retValue = new StringBuffer("LTRIM(");
        boolean moreRP = false;
        if (DisplayType.isNumeric((int)displayType) || columnName.endsWith("_ID")) {
            retValue.append("STR(");
            moreRP = true;
        } else if (DisplayType.isDate((int)displayType)) {
            retValue.append("CONVERT(VARCHAR,");
            moreRP = true;
        }
        retValue.append(columnName + ")");
        if (moreRP) {
            retValue.append(")");
        }
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        return number.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            this.m_ds = new SQLServerDataSource();
            this.m_ds.setServerName(connection.getDbHost());
            this.m_ds.setDatabaseName(connection.getDbName());
            this.m_ds.setPortNumber(connection.getDbPort());
            this.m_ds.setUser(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setDescription("Compiere MSSql Data Source");
            this.m_ds.setApplicationName("Compiere");
            this.m_ds.setIntegratedSecurity(false);
            log.config(this.toString());
            return this.m_ds;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.toString(), e);
            return null;
        }
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        SQLServerConnection conn = null;
        Exception exception = null;
        try {
            this.getDataSource(connection);
            for (int i = 0; i < 5; ++i) {
                block12: {
                    try {
                        conn = (SQLServerConnection)this.m_ds.getConnection();
                        if (conn == null) break block12;
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() == autoCommit) break block12;
                        conn.setAutoCommit(autoCommit);
                    }
                    catch (Exception e) {
                        exception = e;
                        conn = null;
                        if (!(e instanceof SQLException) || ((SQLException)e).getErrorCode() != 1017) break block12;
                        log.severe("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                        break;
                    }
                }
                try {
                    if (conn != null && conn.isClosed()) {
                        conn = null;
                    }
                    if (conn != null && !conn.isClosed()) break;
                    if (i == 0) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                }
            }
            if (conn == null && exception != null) {
                log.log(Level.SEVERE, exception.toString());
                log.fine(this.toString());
                log.finest("Reference=" + this.m_ds.getReference());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        this.m_conn = DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
        return this.m_conn;
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        log.config(this.toString());
        this.m_ds = null;
    }

    public void cleanup() {
        log.config("");
    }

    public boolean handleAbandonedConnection(SQLServerConnection conn, Object userObject) {
        System.out.println("--------------------handleAbandonedConnection " + conn + " - " + userObject);
        return true;
    }

    public void releaseConnection(SQLServerConnection conn, Object userObject) {
        System.out.println("----------------------releaseConnection " + conn + " - " + userObject);
    }

    public String getDataType(int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        switch (displayType) {
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                retValue = "NUERIC(10)";
                break;
            }
            case 12: {
                retValue = "NUMERIC(32,6)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 23: {
                retValue = "VARBINARY(MAX)";
                break;
            }
            case 28: {
                retValue = "CHAR(1)";
                break;
            }
            case 37: {
                retValue = "NUMERIC(32,6)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                retValue = "DATETIME";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT CURRENT_TIMESTAMP";
                break;
            }
            case 11: {
                retValue = "NUMERIC(10)";
                break;
            }
            case 17: {
                retValue = "CHAR(" + precision + ")";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                retValue = "NVARCHAR(" + precision + ")";
                break;
            }
            case 36: {
                retValue = "VARBINARY(MAX)";
                break;
            }
            case 29: {
                retValue = "NUMERIC(32,6)";
                break;
            }
            case 20: {
                retValue = "CHAR(1)";
                break;
            }
            default: {
                log.severe("Unknown: " + displayType);
            }
        }
        return retValue;
    }

    public static void main(String[] args) {
        Compiere.startupEnvironment(true);
        CConnection cc = CConnection.get();
        new CConnectionDialog(cc);
        System.out.println("Connection >> " + cc.toStringLong());
        DB_SQLServer db = (DB_SQLServer)cc.getDatabase();
        System.out.println("db >> " + db.toString());
        db.cleanup();
        try {
            Connection conn = null;
            DataSource ds = db.getDataSource(cc);
            System.out.println("DS=" + ds.getConnection());
            conn = db.getCachedConnection(cc, true, 2);
            System.out.println("Cached=" + conn);
            System.out.println(db);
            System.out.println("JAVA classpath: [" + System.getProperty("java.class.path") + "]");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("DriverVersion: [" + dmd.getDriverVersion() + "]");
            System.out.println("DriverMajorVersion: [" + dmd.getDriverMajorVersion() + "]");
            System.out.println("DriverMinorVersion: [" + dmd.getDriverMinorVersion() + "]");
            System.out.println("DriverName: [" + dmd.getDriverName() + "]");
            System.out.println("ProductName: [" + dmd.getDatabaseProductName() + "]");
            System.out.println("ProductVersion: [" + dmd.getDatabaseProductVersion() + "]");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        try {
            String myString1 = "123456789 12345678";
            String myString = "";
            for (int i = 0; i < 99; ++i) {
                myString = myString + myString1 + (char)(97 + i) + "\n";
            }
            System.out.println("myString.length() = " + myString.length());
            System.out.println("Util.size(myString) = " + Util.size(myString));
            myString = Util.trimSize(myString, 2000);
            System.out.println("myString.length() = " + myString.length());
            System.out.println("Util.size(myString) = " + Util.size(myString));
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("conn2 >> " + conn2.toString());
            PreparedStatement pstmt = conn2.prepareStatement("INSERT INTO X_Test(Text1, Text2) values(?,?)");
            pstmt.setString(1, myString);
            pstmt.setString(2, myString);
            System.out.println("pstmt.executeUpdate() = " + pstmt.executeUpdate());
            Statement stmt = conn2.createStatement();
            System.out.println("stmt.executeUpdate(...) >> " + stmt.executeUpdate("INSERT INTO X_Test(Text1, Text2) values('" + myString + "','" + myString + "')"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getCachedConnection(cc, false, 2);
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            Connection conn3 = db.getCachedConnection(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getCachedConnection(cc, true, 2);
            conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            db.cleanup();
            System.out.println(db);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isConnectionValid(Connection conn) {
        try {
            if (!((SQLServerConnection)conn).isClosed()) {
                return true;
            }
        }
        catch (SQLServerException e) {
            return false;
        }
        return false;
    }

    public String nullValue(String sqlClause, int dataType) {
        return "NULL";
    }

    public String updateSetSelectList(String sql) {
        return DBUtils.updateSetSelectList(sql);
    }

    public Clob getClob(Connection con, String clobString) {
        return null;
    }

    public Blob getBlob(Connection con, byte[] bytes) {
        return null;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }
}

