/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.QueryRestriction;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class Query
implements Serializable {
    private static CLogger s_log = CLogger.getCLogger(Query.class);
    static final long serialVersionUID = 1511402030597166113L;
    private String m_TableName = "";
    private ArrayList<QueryRestriction> m_list = new ArrayList();
    private int m_recordCount = 999999;
    private boolean m_newRecord = false;
    private static final String NEWRECORD = "2=3";
    public static final String EQUAL = "=";
    public static final int EQUAL_INDEX = 0;
    public static final String NOT_EQUAL = "!=";
    public static final String LIKE = " LIKE ";
    public static final String NOT_LIKE = " NOT LIKE ";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final String BETWEEN = " BETWEEN ";
    public static final int BETWEEN_INDEX = 8;
    public static final String IN = " IN ";
    public static final String NOT_IN = " NOT IN ";
    public static final ValueNamePair[] OPERATORS = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(" LIKE ", " ~ "), new ValueNamePair(" NOT LIKE ", " !~ "), new ValueNamePair(">", " > "), new ValueNamePair(">=", " >= "), new ValueNamePair("<", " < "), new ValueNamePair("<=", " <= "), new ValueNamePair(" BETWEEN ", " >-< ")};
    public static final ValueNamePair[] OPERATORS_ID = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != ")};
    public static final ValueNamePair[] OPERATORS_YN = new ValueNamePair[]{new ValueNamePair("=", " = ")};

    public static Query get(Ctx ctx, int AD_PInstance_ID, String TableName) {
        s_log.info("AD_PInstance_ID=" + AD_PInstance_ID + ", TableName=" + TableName);
        Query query = new Query(TableName);
        if (TableName.startsWith("T_")) {
            query.addRestriction(TableName + ".AD_PInstance_ID=" + AD_PInstance_ID);
        }
        int rows = 0;
        String SQL = "SELECT COUNT(*) FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_PInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                rows = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e1) {
            s_log.log(Level.SEVERE, SQL, e1);
        }
        if (rows < 1) {
            return query;
        }
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Process_Para");
        SQL = !trl ? "SELECT ip.ParameterName,ip.P_String,ip.P_String_To,ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, pp.Name, pp.IsRange FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND ip.AD_PInstance_ID=?" : "SELECT ip.ParameterName,ip.P_String,ip.P_String_To, ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, ppt.Name, pp.IsRange FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp, AD_Process_Para_Trl ppt WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND pp.AD_Process_Para_ID=ppt.AD_Process_Para_ID AND ip.AD_PInstance_ID=? AND ppt.AD_Language=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_PInstance_ID);
            if (trl) {
                pstmt.setString(2, Env.getAD_Language(ctx));
            }
            ResultSet rs = pstmt.executeQuery();
            int row = 0;
            while (rs.next()) {
                if (row == rows) {
                    s_log.log(Level.SEVERE, "(Parameter) - more rows than expected");
                    break;
                }
                String ParameterName = rs.getString(1);
                String P_String = rs.getString(2);
                String P_String_To = rs.getString(3);
                Double P_Number = null;
                double d = rs.getDouble(4);
                if (!rs.wasNull()) {
                    P_Number = new Double(d);
                }
                Double P_Number_To = null;
                d = rs.getDouble(5);
                if (!rs.wasNull()) {
                    P_Number_To = new Double(d);
                }
                Timestamp P_Date = rs.getTimestamp(6);
                Timestamp P_Date_To = rs.getTimestamp(7);
                String Info = rs.getString(8);
                String Info_To = rs.getString(9);
                String Name2 = rs.getString(10);
                boolean isRange = "Y".equals(rs.getString(11));
                s_log.fine(ParameterName + " S=" + P_String + "-" + P_String_To + ", N=" + P_Number + "-" + P_Number_To + ", D=" + P_Date + "-" + P_Date_To + "; Name=" + Name2 + ", Info=" + Info + "-" + Info_To + ", Range=" + isRange);
                if (P_String != null) {
                    if (P_String_To == null) {
                        if (P_String.indexOf("%") == -1) {
                            query.addRestriction(ParameterName, EQUAL, P_String, Name2, Info);
                        } else {
                            query.addRestriction(ParameterName, LIKE, P_String, Name2, Info);
                        }
                    } else {
                        query.addRangeRestriction(ParameterName, P_String, P_String_To, Name2, Info, Info_To);
                    }
                } else if (P_Number != null || P_Number_To != null) {
                    if (P_Number_To == null) {
                        if (isRange) {
                            query.addRestriction(ParameterName, GREATER_EQUAL, P_Number, Name2, Info);
                        } else {
                            query.addRestriction(ParameterName, EQUAL, P_Number, Name2, Info);
                        }
                    } else if (P_Number == null) {
                        query.addRestriction("TRUNC(" + ParameterName + ",'DD')", LESS_EQUAL, P_Number_To, Name2, Info);
                    } else {
                        query.addRangeRestriction(ParameterName, P_Number, P_Number_To, Name2, Info, Info_To);
                    }
                } else if (P_Date != null || P_Date_To != null) {
                    if (P_Date_To == null) {
                        if (isRange) {
                            query.addRestriction("TRUNC(" + ParameterName + ",'DD')", GREATER_EQUAL, P_Date, Name2, Info);
                        } else {
                            query.addRestriction("TRUNC(" + ParameterName + ",'DD')", EQUAL, P_Date, Name2, Info);
                        }
                    } else if (P_Date == null) {
                        query.addRestriction("TRUNC(" + ParameterName + ",'DD')", LESS_EQUAL, P_Date_To, Name2, Info);
                    } else {
                        query.addRangeRestriction("TRUNC(" + ParameterName + ",'DD')", P_Date, P_Date_To, Name2, Info, Info_To);
                    }
                }
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e2) {
            s_log.log(Level.SEVERE, SQL, e2);
        }
        s_log.info(query.toString());
        return query;
    }

    public static String getZoomColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (columnName.equals("SalesRep_ID")) {
            return "AD_User_ID";
        }
        if (columnName.equals("C_DocTypeTarget_ID")) {
            return "C_DocType_ID";
        }
        if (columnName.equals("Bill_BPartner_ID")) {
            return "C_BPartner_ID";
        }
        if (columnName.equals("Bill_Location_ID")) {
            return "C_BPartner_Location_ID";
        }
        if (columnName.equals("Account_ID")) {
            return "C_ElementValue_ID";
        }
        return columnName;
    }

    public static String getZoomTableName(String columnName) {
        String tableName = Query.getZoomColumnName(columnName);
        int index = tableName.lastIndexOf("_ID");
        if (index != -1) {
            return tableName.substring(0, index);
        }
        return tableName;
    }

    public static Query getEqualQuery(String columnName, Object value) {
        Query query = new Query();
        query.addRestriction(columnName, EQUAL, value);
        query.setRecordCount(1);
        return query;
    }

    public static Query getEqualQuery(String columnName, int value) {
        Query query = new Query();
        if (columnName.endsWith("_ID")) {
            query.setTableName(columnName.substring(0, columnName.length() - 3));
        }
        query.addRestriction(columnName, EQUAL, new Integer(value));
        query.setRecordCount(1);
        return query;
    }

    public static Query getNoRecordQuery(String tableName, boolean newRecord) {
        Query query = new Query(tableName);
        if (newRecord) {
            query.addRestriction(NEWRECORD);
        } else {
            query.addRestriction("1=2");
        }
        query.setRecordCount(0);
        return query;
    }

    public Query() {
    }

    public Query(String TableName) {
        this.m_TableName = TableName;
    }

    public Query(int AD_Table_ID) {
        this.m_TableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    public void setRecordCount(int count) {
        this.m_recordCount = count;
    }

    public void addRestriction(String ColumnName, String Operator, Object Code, String InfoName, String InfoDisplay) {
        QueryRestriction r = new QueryRestriction(ColumnName, Operator, Code, InfoName, InfoDisplay);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator, Object Code) {
        QueryRestriction r = new QueryRestriction(ColumnName, Operator, Code, null, null);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator, int Code) {
        QueryRestriction r = new QueryRestriction(ColumnName, Operator, new Integer(Code), null, null);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code, Object Code_to, String InfoName, String InfoDisplay, String InfoDisplay_to) {
        QueryRestriction r = new QueryRestriction(ColumnName, Code, Code_to, InfoName, InfoDisplay, InfoDisplay_to);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code, Object Code_to) {
        QueryRestriction r = new QueryRestriction(ColumnName, Code, Code_to, null, null, null);
        this.m_list.add(r);
    }

    public void addRestriction(QueryRestriction r) {
        this.m_list.add(r);
    }

    public void addRestriction(String whereClause) {
        if (whereClause == null || whereClause.trim().length() == 0) {
            return;
        }
        QueryRestriction r = new QueryRestriction(whereClause);
        this.m_list.add(r);
        this.m_newRecord = whereClause.equals(NEWRECORD);
    }

    public boolean isNewRecordQuery() {
        return this.m_newRecord;
    }

    public String getWhereClause() {
        return this.getWhereClause(false);
    }

    public String getWhereClause(boolean fullyQualified) {
        boolean qualified = fullyQualified;
        if (qualified && (this.m_TableName == null || this.m_TableName.length() == 0)) {
            qualified = false;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_list.size(); ++i) {
            QueryRestriction r = this.m_list.get(i);
            if (i != 0) {
                sb.append(r.AndCondition ? " AND " : " OR ");
            }
            if (qualified) {
                sb.append(r.getSQL(this.m_TableName));
                continue;
            }
            sb.append(r.getSQL(null));
        }
        return sb.toString();
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        if (this.m_TableName != null) {
            sb.append(this.m_TableName).append(": ");
        }
        for (int i = 0; i < this.m_list.size(); ++i) {
            QueryRestriction r = this.m_list.get(i);
            if (i != 0) {
                sb.append(r.AndCondition ? " AND " : " OR ");
            }
            sb.append(r.getInfoName()).append(r.getInfoOperator()).append(r.getInfoDisplayAll());
        }
        return sb.toString();
    }

    public String getWhereClause(int index) {
        StringBuffer sb = new StringBuffer();
        if (index >= 0 && index < this.m_list.size()) {
            QueryRestriction r = this.m_list.get(index);
            sb.append(r.getSQL(null));
        }
        return sb.toString();
    }

    public int getRestrictionCount() {
        return this.m_list.size();
    }

    public boolean isActive() {
        return this.m_list.size() != 0;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String TableName) {
        this.m_TableName = TableName;
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.ColumnName;
    }

    public void setColumnName(int index, String ColumnName) {
        if (index < 0 || index >= this.m_list.size()) {
            return;
        }
        QueryRestriction r = this.m_list.get(index);
        r.ColumnName = ColumnName;
    }

    public String getOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.Operator;
    }

    public Object getCode(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.Code;
    }

    public Object getCodeTo(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.Code_to;
    }

    public String getInfoDisplay(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.InfoDisplay;
    }

    public String getInfoDisplay_to(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.InfoDisplay_to;
    }

    public String getInfoName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.InfoName;
    }

    public String getInfoOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.getInfoOperator();
    }

    public String getInfoDisplayAll(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        QueryRestriction r = this.m_list.get(index);
        return r.getInfoDisplayAll();
    }

    public String toString() {
        if (this.isActive()) {
            return this.getWhereClause(true);
        }
        return "MQuery[" + this.m_TableName + ",QueryRestrictions=0]";
    }

    public String getDisplayName(Ctx ctx) {
        String keyColumn = null;
        keyColumn = this.m_TableName != null ? this.m_TableName + "_ID" : this.getColumnName(0);
        String retValue = Msg.translate(ctx, keyColumn);
        if (retValue != null && retValue.length() > 0) {
            return retValue;
        }
        return this.m_TableName;
    }

    public Query deepCopy() {
        Query newQuery = new Query(this.m_TableName);
        for (int i = 0; i < this.m_list.size(); ++i) {
            newQuery.addRestriction(this.m_list.get(i));
        }
        return newQuery;
    }
}

