/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomTarget {
    private static CLogger log = CLogger.getCLogger(ZoomTarget.class);

    public static void parseColumns(ArrayList list, String parseString) {
        if (parseString == null || parseString.length() == 0) {
            return;
        }
        String s = parseString;
        if (s.contains(" EXISTS ") || s.contains(" IN ") || s.contains("(") || s.contains(")")) {
            return;
        }
        while (s.indexOf("=") != -1) {
            int endIndex = s.indexOf("=");
            int beginIndex = s.lastIndexOf(32, endIndex);
            String variable = s.substring(beginIndex + 1, endIndex);
            if (variable.indexOf(".") != -1) {
                beginIndex = variable.indexOf(".") + 1;
                variable = variable.substring(beginIndex);
            }
            if (!list.contains(variable)) {
                list.add(variable);
            }
            s = s.substring(endIndex + 1);
        }
    }

    public static boolean evaluateWhereClause(ArrayList<ValueNamePair> columnValues, String whereClause) {
        if (whereClause == null || whereClause.length() == 0) {
            return true;
        }
        String s = whereClause;
        boolean result = true;
        if (s.contains(" EXISTS ") || s.contains(" IN ") || s.contains("(") || s.contains(")")) {
            return false;
        }
        while (s.indexOf("=") != -1) {
            int endIndex = s.indexOf("=");
            int beginIndex = s.lastIndexOf(32, endIndex);
            String variable = s.substring(beginIndex + 1, endIndex);
            String operand1 = "";
            String operand2 = "";
            String operator = "=";
            if (variable.indexOf(".") != -1) {
                beginIndex = variable.indexOf(".") + 1;
                variable = variable.substring(beginIndex);
            }
            for (int i = 0; i < columnValues.size(); ++i) {
                if (!variable.equals(columnValues.get(i).getName())) continue;
                operand1 = "'" + columnValues.get(i).getValue() + "'";
                break;
            }
            s = s.substring(endIndex + 1);
            beginIndex = 0;
            endIndex = s.indexOf(32);
            operand2 = endIndex == -1 ? s.substring(beginIndex) : s.substring(beginIndex, endIndex);
            if (Evaluator.evaluateLogicTuple((String)operand1, (String)operator, (String)operand2)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static int getZoomAD_Window_ID(String targetTableName, int curWindow_ID, String targetWhereClause, boolean isSOTrx) {
        int zoomWindow_ID = 0;
        int PO_zoomWindow_ID = 0;
        String sql = "SELECT DISTINCT AD_Window_ID, PO_Window_ID FROM AD_Table t WHERE TableName = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            int index = 1;
            pstmt.setString(index++, targetTableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                zoomWindow_ID = rs.getInt(1);
                PO_zoomWindow_ID = rs.getInt(2);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (PO_zoomWindow_ID == 0) {
            return zoomWindow_ID;
        }
        int AD_Window_ID = 0;
        if (targetWhereClause != null && targetWhereClause.length() != 0) {
            ArrayList<Object> zoomList = new ArrayList();
            zoomList = ZoomTarget.getZoomTargets(targetTableName, curWindow_ID, targetWhereClause);
            if (zoomList != null && zoomList.size() > 0) {
                AD_Window_ID = ((KeyNamePair)zoomList.get(0)).getKey();
            }
        }
        if (AD_Window_ID != 0) {
            return AD_Window_ID;
        }
        if (isSOTrx) {
            return zoomWindow_ID;
        }
        return PO_zoomWindow_ID;
    }

    public static ArrayList<KeyNamePair> getZoomTargets(String targetTableName, int curWindow_ID, String targetWhereClause, Object[] params) {
        if (params.length != 1) {
            return null;
        }
        Integer record_ID = (Integer)params[0];
        String whereClause = targetWhereClause.replace("?", record_ID.toString());
        whereClause = whereClause.replace("WHERE ", " ");
        log.fine("WhereClause : " + whereClause);
        return ZoomTarget.getZoomTargets(targetTableName, curWindow_ID, whereClause);
    }

    public static ArrayList<KeyNamePair> getZoomTargets(String targetTableName, int curWindow_ID, String targetWhereClause) {
        ArrayList<KeyNamePair> zoomList = new ArrayList<KeyNamePair>();
        class WindowWhereClause {
            public int AD_Window_ID = 0;
            public String windowName = "";
            public String whereClause = "";

            public WindowWhereClause(int ad_Window_ID, String name, String where) {
                this.AD_Window_ID = ad_Window_ID;
                this.windowName = name;
                this.whereClause = where;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(Msg.translate(Env.getCtx(), "AD_Window_ID")).append("=").append(this.windowName).append(" - ").append(this.whereClause);
                return sb.toString();
            }
        }
        ArrayList<WindowWhereClause> windowList = new ArrayList<WindowWhereClause>();
        ArrayList columns = new ArrayList();
        int zoom_Window_ID = 0;
        int PO_Window_ID = 0;
        String zoom_WindowName = "";
        String whereClause = "";
        boolean windowFound = false;
        String sql = "SELECT DISTINCT w.AD_Window_ID, w.Name, tt.WhereClause, t.TableName, wp.AD_Window_ID, wp.Name, ws.AD_Window_ID, ws.Name FROM AD_Table t INNER JOIN AD_Tab tt ON (tt.AD_Table_ID = t.AD_Table_ID) ";
        sql = sql + "INNER JOIN AD_Window w ON (tt.AD_Window_ID=w.AD_Window_ID)";
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
        sql = baseLanguage ? sql + " LEFT OUTER JOIN AD_Window ws ON (t.AD_Window_ID=ws.AD_Window_ID) LEFT OUTER JOIN AD_Window wp ON (t.PO_Window_ID=wp.AD_Window_ID)" : sql + " LEFT OUTER JOIN AD_Window_Trl ws ON (t.AD_Window_ID=ws.AD_Window_ID AND ws.AD_Language=?) LEFT OUTER JOIN AD_Window_Trl wp ON (t.PO_Window_ID=wp.AD_Window_ID AND wp.AD_Language=?)";
        sql = sql + "WHERE t.TableName = ? AND w.AD_Window_ID <> ? AND w.IsBetaFunctionality='N' AND tt.SeqNo=10 AND (wp.AD_Window_ID IS NOT NULL OR EXISTS (SELECT 1 FROM AD_Tab tt2 WHERE tt2.AD_Window_ID = ws.AD_Window_ID AND tt2.AD_Table_ID=t.AD_Table_ID AND tt2.SeqNo=10)) ORDER BY 1";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            int index = 1;
            if (!baseLanguage) {
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
            }
            pstmt.setString(index++, targetTableName);
            pstmt.setInt(index++, curWindow_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                windowFound = true;
                zoom_Window_ID = rs.getInt(7);
                zoom_WindowName = rs.getString(8);
                PO_Window_ID = rs.getInt(5);
                whereClause = rs.getString(3);
                if (PO_Window_ID == 0) break;
                WindowWhereClause windowClause = new WindowWhereClause(rs.getInt(1), rs.getString(2), whereClause);
                windowList.add(windowClause);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        String sql1 = "";
        if (!windowFound || windowList.size() <= 1 && zoom_Window_ID == 0) {
            return zoomList;
        }
        if (windowList.size() <= 1) {
            sql1 = "SELECT count(*) FROM " + targetTableName + " WHERE " + targetWhereClause;
            if (whereClause != null && whereClause.length() != 0) {
                sql1 = sql1 + " AND " + Evaluator.replaceVariables((String)whereClause, (Ctx)Env.getCtx(), null);
            }
        } else if (windowList.size() > 1) {
            int i;
            for (i = 0; i < windowList.size(); ++i) {
                ZoomTarget.parseColumns(columns, ((WindowWhereClause)windowList.get((int)i)).whereClause);
            }
            sql1 = "SELECT DISTINCT ";
            for (i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    sql1 = sql1 + ",";
                }
                sql1 = sql1 + columns.get(i);
            }
            if (columns.size() == 0) {
                sql1 = sql1 + "count(*) ";
            }
            sql1 = sql1 + " FROM " + targetTableName + " WHERE " + targetWhereClause;
        }
        log.fine(sql1);
        ArrayList<ValueNamePair> columnValues = new ArrayList<ValueNamePair>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql1, null);
            ResultSet rs = pstmt.executeQuery();
            block7: while (rs.next()) {
                KeyNamePair pp;
                if (columns.size() > 0) {
                    int i;
                    columnValues.clear();
                    for (i = 0; i < columns.size(); ++i) {
                        String columnName = (String)columns.get(i);
                        String columnValue = (String)rs.getObject(columnName);
                        log.fine(columnName + " = " + columnValue);
                        columnValues.add(new ValueNamePair(columnValue, columnName));
                    }
                    for (i = 0; i < windowList.size(); ++i) {
                        log.fine("Window : " + ((WindowWhereClause)windowList.get((int)i)).windowName + " WhereClause : " + ((WindowWhereClause)windowList.get((int)i)).whereClause);
                        if (!ZoomTarget.evaluateWhereClause(columnValues, ((WindowWhereClause)windowList.get((int)i)).whereClause)) continue;
                        log.fine("MatchFound : " + ((WindowWhereClause)windowList.get((int)i)).windowName);
                        pp = new KeyNamePair(((WindowWhereClause)windowList.get((int)i)).AD_Window_ID, ((WindowWhereClause)windowList.get((int)i)).windowName);
                        zoomList.add(pp);
                        continue block7;
                    }
                    continue;
                }
                int rowCount = rs.getInt(1);
                if (rowCount == 0) continue;
                pp = new KeyNamePair(zoom_Window_ID, zoom_WindowName);
                zoomList.add(pp);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql1, e);
        }
        return zoomList;
    }
}

