/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.compiere.Compiere;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.X_AD_Attachment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.MimeType;

public class MAttachment
extends X_AD_Attachment {
    private static CLogger s_log = CLogger.getCLogger(MAttachment.class);
    public static final String NONE = ".";
    public static final String ZIP = "zip";
    private ArrayList<MAttachmentEntry> m_items = null;

    public static MAttachment get(Ctx ctx, int AD_Table_ID, int Record_ID) {
        MAttachment retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Attachment WHERE AD_Table_ID=? AND Record_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            pstmt.setInt(2, Record_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MAttachment(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MAttachment(Ctx ctx, int AD_Attachment_ID, String trxName) {
        super(ctx, AD_Attachment_ID, trxName);
    }

    public MAttachment(Ctx ctx, int AD_Table_ID, int Record_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
    }

    public MAttachment(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addTextMsg(String added) {
        String oldTextMsg = this.getTextMsg();
        if (oldTextMsg == null) {
            this.setTextMsg(added);
        } else if (added != null) {
            this.setTextMsg(oldTextMsg + added);
        }
    }

    public String getTextMsg() {
        String msg = super.getTextMsg();
        if (msg == null) {
            return null;
        }
        return msg.trim();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAttachment[");
        sb.append(this.getAD_Attachment_ID()).append(",Title=").append(this.getTitle()).append(",Entries=").append(this.getEntryCount());
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (i == 0) {
                sb.append(":");
            } else {
                sb.append(",");
            }
            sb.append(this.getEntryName(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean addEntry(File file) {
        if (file == null) {
            this.log.warning("No File");
            return false;
        }
        if (!file.exists() || file.isDirectory()) {
            this.log.warning("not added - " + file + ", Exists=" + file.exists() + ", Directory=" + file.isDirectory());
            return false;
        }
        this.log.fine("addEntry - " + file);
        String name = file.getName();
        byte[] data = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            fis.close();
            data = os.toByteArray();
            os.close();
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "(file)", ioe);
        }
        return this.addEntry(name, data);
    }

    public boolean addEntry(String name, byte[] data) {
        if (name == null || data == null) {
            return false;
        }
        return this.addEntry(new MAttachmentEntry(name, data));
    }

    public boolean addEntry(MAttachmentEntry item) {
        if (item == null) {
            return false;
        }
        if (this.m_items == null) {
            this.loadLOBData();
        }
        boolean retValue = this.m_items.add(item);
        this.log.fine(item.toStringX());
        this.addTextMsg(" ");
        return retValue;
    }

    public MAttachmentEntry getEntry(int index) {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (index < 0 || index >= this.m_items.size()) {
            return null;
        }
        return this.m_items.get(index);
    }

    public MAttachmentEntry[] getEntries() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        MAttachmentEntry[] retValue = new MAttachmentEntry[this.m_items.size()];
        this.m_items.toArray(retValue);
        return retValue;
    }

    public boolean deleteEntry(int index) {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (index >= 0 && index < this.m_items.size()) {
            this.m_items.remove(index);
            this.addTextMsg(" ");
            this.log.config("Index=" + index + " - NewSize=" + this.m_items.size());
            return true;
        }
        this.log.warning("Not deleted Index=" + index + " - Size=" + this.m_items.size());
        return false;
    }

    public int getEntryCount() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        return this.m_items.size();
    }

    public String getEntryName(int index) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getName();
        }
        return null;
    }

    public void dumpEntryNames() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (this.m_items == null || this.m_items.size() == 0) {
            System.out.println("- no entries -");
            return;
        }
        System.out.println("- entries: " + this.m_items.size());
        for (int i = 0; i < this.m_items.size(); ++i) {
            System.out.println("  - " + this.getEntryName(i));
        }
    }

    public byte[] getEntryData(int index) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public File getEntryFile(int index, String fileName) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(fileName);
        }
        return null;
    }

    public File getEntryFile(int index, File file) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(file);
        }
        return null;
    }

    private boolean saveLOBData() {
        if (this.m_items == null || this.m_items.size() == 0) {
            this.setBinaryData(null);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("compiere");
        try {
            for (int i = 0; i < this.m_items.size(); ++i) {
                MAttachmentEntry item = this.getEntry(i);
                ZipEntry entry = new ZipEntry(item.getName());
                entry.setTime(System.currentTimeMillis());
                entry.setMethod(8);
                zip.putNextEntry(entry);
                byte[] data = item.getData();
                zip.write(data, 0, data.length);
                zip.closeEntry();
                this.log.fine(entry.getName() + " - " + entry.getCompressedSize() + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
            }
            zip.close();
            byte[] zipData = out.toByteArray();
            this.log.fine("Length=" + zipData.length);
            this.setBinaryData(zipData);
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            this.setBinaryData(null);
            return false;
        }
    }

    private boolean loadLOBData() {
        this.m_items = new ArrayList();
        byte[] data = this.getBinaryData();
        if (data == null) {
            return true;
        }
        this.log.fine("ZipSize=" + data.length);
        if (data.length == 0) {
            return true;
        }
        if (!ZIP.equals(this.getTitle())) {
            this.m_items.add(new MAttachmentEntry(this.getTitle(), data, 1));
            return true;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                byte[] dataEntry = out.toByteArray();
                this.log.fine(name + " - size=" + dataEntry.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                this.m_items.add(new MAttachmentEntry(name, dataEntry, this.m_items.size() + 1));
                entry = zip.getNextEntry();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "loadLOBData", e);
            this.m_items = null;
            return false;
        }
        return true;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getTitle() == null || !this.getTitle().equals(ZIP)) {
            this.setTitle(ZIP);
        }
        return this.saveLOBData();
    }

    public static void main(String[] args) {
        System.out.println(MimeType.getMimeType("data.xls"));
        System.out.println(MimeType.getMimeType("data.cvs"));
        System.out.println(MimeType.getMimeType("data.txt"));
        System.out.println(MimeType.getMimeType("data.log"));
        System.out.println(MimeType.getMimeType("data.html"));
        System.out.println(MimeType.getMimeType("data.htm"));
        System.out.println(MimeType.getMimeType("data.png"));
        System.out.println(MimeType.getMimeType("data.gif"));
        System.out.println(MimeType.getMimeType("data.jpg"));
        System.out.println(MimeType.getMimeType("data.xml"));
        System.out.println(MimeType.getMimeType("data.rtf"));
        System.exit(0);
        Compiere.startup(true);
        MAttachment att = new MAttachment(Env.getCtx(), 100, 0, null);
        att.addEntry(new File("C:\\Compiere\\Dev.properties"));
        att.addEntry(new File("C:\\Compiere2\\index.html"));
        att.save();
        System.out.println(att);
        att.dumpEntryNames();
        int AD_Attachment_ID = att.getAD_Attachment_ID();
        System.out.println("===========================================");
        att = new MAttachment(Env.getCtx(), AD_Attachment_ID, null);
        System.out.println(att);
        att.dumpEntryNames();
        System.out.println("===========================================");
        MAttachmentEntry[] entries = att.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            MAttachmentEntry entry = entries[i];
            entry.dump();
        }
        System.out.println("===========================================");
        att.delete(true);
    }
}

