/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_AD_Column_Access;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MColumnAccess
extends X_AD_Column_Access {
    private String m_tableName;
    private String m_columnName;

    public MColumnAccess(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MColumnAccess(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MColumnAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(",AD_Column_ID=").append(this.getAD_Column_ID()).append(",Exclude=").append(this.isExclude());
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Ctx ctx) {
        String in = Msg.getMsg(ctx, "Include");
        String ex = Msg.getMsg(ctx, "Exclude");
        StringBuffer sb = new StringBuffer();
        sb.append(Msg.translate(ctx, "AD_Table_ID")).append("=").append(this.getTableName(ctx)).append(", ").append(Msg.translate(ctx, "AD_Column_ID")).append("=").append(this.getColumnName(ctx)).append(" (").append(Msg.translate(ctx, "IsReadOnly")).append("=").append(this.isReadOnly()).append(") - ").append(this.isExclude() ? ex : in);
        return sb.toString();
    }

    public String getTableName(Ctx ctx) {
        if (this.m_tableName == null) {
            this.getColumnName(ctx);
        }
        return this.m_tableName;
    }

    public String getColumnName(Ctx ctx) {
        if (this.m_columnName == null) {
            String sql = "SELECT t.TableName,c.ColumnName, t.AD_Table_ID FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE AD_Column_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Column_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_tableName = rs.getString(1);
                    this.m_columnName = rs.getString(2);
                    if (rs.getInt(3) != this.getAD_Table_ID()) {
                        this.log.log(Level.SEVERE, "AD_Table_ID inconsistent - Access=" + this.getAD_Table_ID() + " - Table=" + rs.getInt(3));
                    }
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            String realName = Msg.translate(ctx, this.m_tableName + "_ID");
            if (!realName.equals(this.m_tableName + "_ID")) {
                this.m_tableName = realName;
            }
            this.m_columnName = Msg.translate(ctx, this.m_columnName);
        }
        return this.m_columnName;
    }
}

