/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.X_C_Conversion_Rate;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MConversionRate
extends X_C_Conversion_Rate {
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);

    public static BigDecimal convertBase(Ctx ctx, BigDecimal Amt, int CurFrom_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, MClient.get(ctx).getC_Currency_ID(), ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Ctx ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, CurTo_ID, null, 0, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Ctx ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (Amt == null) {
            throw new IllegalArgumentException("Required parameter missing - Amt");
        }
        if (CurFrom_ID == CurTo_ID || Amt.equals(Env.ZERO)) {
            return Amt;
        }
        BigDecimal retValue = MConversionRate.getRate(CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        if (retValue == null) {
            return null;
        }
        retValue = retValue.multiply(Amt);
        int stdPrecision = MCurrency.getStdPrecision(ctx, CurTo_ID);
        if (retValue.scale() > stdPrecision) {
            retValue = retValue.setScale(stdPrecision, 4);
        }
        return retValue;
    }

    public static BigDecimal getRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_To_ID=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CurFrom_ID);
            pstmt.setInt(2, CurTo_ID);
            pstmt.setInt(3, C_ConversionType_ID);
            pstmt.setTimestamp(4, ConvDate);
            pstmt.setInt(5, AD_Client_ID);
            pstmt.setInt(6, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.info("Not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }

    public MConversionRate(Ctx ctx, int C_Conversion_Rate_ID, String trxName) {
        super(ctx, C_Conversion_Rate_ID, trxName);
        if (C_Conversion_Rate_ID == 0) {
            super.setDivideRate(Env.ZERO);
            super.setMultiplyRate(Env.ZERO);
            this.setValidFrom(new Timestamp(System.currentTimeMillis()));
        }
    }

    public MConversionRate(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MConversionRate(PO po, int C_ConversionType_ID, int C_Currency_ID, int C_Currency_To_ID, BigDecimal MultiplyRate, Timestamp ValidFrom) {
        this(po.getCtx(), 0, po.get_TrxName());
        this.setClientOrg(po);
        this.setC_ConversionType_ID(C_ConversionType_ID);
        this.setC_Currency_ID(C_Currency_ID);
        this.setC_Currency_To_ID(C_Currency_To_ID);
        this.setMultiplyRate(MultiplyRate);
        this.setValidFrom(ValidFrom);
    }

    @UICallout
    public void setMultiplyRate(String MultiplyRateOld, String MultiplyRateNew, int windowNo) throws Exception {
        this.setMultiplyRate(MConversionRate.convertToBigDecimal(MultiplyRateNew));
    }

    public void setMultiplyRate(BigDecimal MultiplyRate) {
        if (MultiplyRate == null || MultiplyRate.signum() == 0 || MultiplyRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setMultiplyRate(MultiplyRate);
            double dd = 1.0 / MultiplyRate.doubleValue();
            super.setDivideRate(new BigDecimal(dd));
        }
    }

    @UICallout
    public void setDivideRate(String DivideRateOld, String DivideRateNew, int WindowNo) throws Exception {
        this.setDivideRate(MConversionRate.convertToBigDecimal(DivideRateNew));
    }

    public void setDivideRate(BigDecimal DivideRate) {
        if (DivideRate == null || DivideRate.signum() == 0 || DivideRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setDivideRate(DivideRate);
            double dd = 1.0 / DivideRate.doubleValue();
            super.setMultiplyRate(new BigDecimal(dd));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MConversionRate[");
        sb.append(this.get_ID()).append(",Currency=").append(this.getC_Currency_ID()).append(",To=").append(this.getC_Currency_To_ID()).append(", Multiply=").append(this.getMultiplyRate()).append(",Divide=").append(this.getDivideRate()).append(", ValidFrom=").append(this.getValidFrom());
        sb.append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        Timestamp to;
        if (this.getC_Currency_ID() == this.getC_Currency_To_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@C_Currency_ID@ = @C_Currency_ID@"));
            return false;
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@MultiplyRate@ <= 0"));
            return false;
        }
        Timestamp from = this.getValidFrom();
        if (this.getValidTo() == null) {
            this.setValidTo(TimeUtil.getDay(2056, 1, 29));
        }
        if ((to = this.getValidTo()).before(from)) {
            SimpleDateFormat df = DisplayType.getDateFormat(15);
            this.log.saveError("Error", df.format(to) + " < " + df.format(from));
            return false;
        }
        return true;
    }
}

