/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MIssue;
import org.compiere.model.X_R_IssueUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MIssueUser
extends X_R_IssueUser {
    private static CLogger s_log = CLogger.getCLogger(MIssueUser.class);

    public static MIssueUser get(MIssue issue) {
        if (issue.getUserName() == null) {
            return null;
        }
        X_R_IssueUser user = null;
        String sql = "SELECT * FROM R_IssueUser WHERE UserName=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, issue.getUserName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                user = new MIssueUser(issue.getCtx(), rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (user == null) {
            user = new MIssueUser(issue.getCtx(), 0, null);
            user.setUserName(issue.getUserName());
            ((MIssueUser)user).setAD_User_ID();
            if (!user.save()) {
                return null;
            }
        }
        issue.setR_IssueUser_ID(user.getR_IssueUser_ID());
        return user;
    }

    public MIssueUser(Ctx ctx, int R_IssueUser_ID, String trxName) {
        super(ctx, R_IssueUser_ID, trxName);
    }

    public MIssueUser(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setAD_User_ID() {
        int AD_User_ID = DB.getSQLValue(null, "SELECT AD_User_ID FROM AD_User WHERE EMail=?", this.getUserName());
        if (AD_User_ID != 0) {
            super.setAD_User_ID(AD_User_ID);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MIssueUser[");
        sb.append(this.get_ID()).append("-").append(this.getUserName()).append(",AD_User_ID=").append(this.getAD_User_ID()).append("]");
        return sb.toString();
    }
}

