/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.MDocType;
import org.compiere.model.MSystem;
import org.compiere.model.X_AD_Sequence;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class MSequence
extends X_AD_Sequence {
    private static final boolean TEST_TRX = false;
    private static final Level LOGLEVEL = Level.ALL;
    private static final String PREFIX_DOCSEQ = "DocumentNo_";
    public static final int INIT_NO = 1000000;
    public static final int INIT_SYS_NO = 100;
    private static CLogger s_log = CLogger.getCLogger(MSequence.class);
    static Vector<Integer> s_list = null;

    public static synchronized int getNextID(int AD_Client_ID, String TableName, String trxName) {
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        int retValue = -1;
        boolean compiereSys = Ini.isPropertyBool("CompiereSys");
        if (compiereSys && AD_Client_ID > 11) {
            compiereSys = false;
        }
        trxName = null;
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, TableName + " - CompiereSys=" + compiereSys + " [" + trxName + "]");
        }
        String selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y'  FOR UPDATE";
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        Connection conn = null;
        Statement pstmt = null;
        for (int i = 0; i < 3; ++i) {
            try {
                conn = trx != null ? trx.getConnection() : DB.getConnectionID();
                if (conn == null) {
                    return -1;
                }
                pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                pstmt.setString(1, TableName);
                ResultSet rs = pstmt.executeQuery();
                if (CLogMgt.isLevelFinest()) {
                    s_log.finest("AC=" + conn.getAutoCommit() + ", RO=" + conn.isReadOnly() + " - Isolation=" + conn.getTransactionIsolation() + "(" + 2 + ") - RSType=" + pstmt.getResultSetType() + "(" + 1005 + "), RSConcur=" + pstmt.getResultSetConcurrency() + "(" + 1008 + ")");
                }
                if (rs.next()) {
                    int incrementNo = rs.getInt(3);
                    if (compiereSys) {
                        retValue = rs.getInt(2);
                        rs.updateInt(2, retValue + incrementNo);
                    } else {
                        retValue = rs.getInt(1);
                        rs.updateInt(1, retValue + incrementNo);
                    }
                    rs.updateRow();
                } else {
                    s_log.severe("No record found - " + TableName);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (trx == null) {
                    conn.commit();
                }
                conn = null;
                break;
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, TableName + " - " + e.getMessage(), e);
                try {
                    conn.rollback();
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                Thread.yield();
                continue;
            }
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
            conn = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "Finish", e);
            pstmt = null;
        }
        s_log.finest(retValue + " - Table=" + TableName + " [" + trx + "]");
        return retValue;
    }

    private static int nextID(Connection conn, int AD_Sequence_ID, boolean compiereSys) {
        if (conn == null || AD_Sequence_ID == 0) {
            return -3;
        }
        int retValue = -1;
        String sqlUpdate = "{call nextID(?,?,?)}";
        CallableStatement cstmt = null;
        try {
            cstmt = conn.prepareCall(sqlUpdate, 1003, 1007);
            cstmt.setInt(1, AD_Sequence_ID);
            cstmt.setString(2, compiereSys ? "Y" : "N");
            cstmt.registerOutParameter(3, 4);
            cstmt.execute();
            retValue = cstmt.getInt(3);
            cstmt.close();
            cstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, e.toString());
        }
        try {
            if (cstmt != null) {
                cstmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retValue;
    }

    public static synchronized String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        boolean compiereSys = Ini.isPropertyBool("CompiereSys");
        if (compiereSys && AD_Client_ID > 11) {
            compiereSys = false;
        }
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, TableName + " - CompiereSys=" + compiereSys + " [" + trxName + "]");
        }
        String selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ";
        if (DB.isOracle()) {
            selectSQL = selectSQL + " ORDER BY AD_Client_ID DESC ";
        }
        selectSQL = selectSQL + "FOR UPDATE";
        Connection conn = null;
        PreparedStatement pstmt = null;
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        int incrementNo = 0;
        int next = -1;
        String prefix = "";
        String suffix = "";
        try {
            conn = trx != null ? trx.getConnection() : DB.getConnectionID();
            if (conn == null) {
                return null;
            }
            pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
            pstmt.setString(1, PREFIX_DOCSEQ + TableName);
            pstmt.setInt(2, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                prefix = rs.getString(4);
                suffix = rs.getString(5);
                incrementNo = rs.getInt(3);
                if (compiereSys) {
                    next = rs.getInt(2);
                    rs.updateInt(2, next + incrementNo);
                } else {
                    next = rs.getInt(1);
                    rs.updateInt(1, next + incrementNo);
                }
                rs.updateRow();
            } else {
                s_log.warning("(Table) - no record found - " + TableName);
                MSequence seq = new MSequence(Env.getCtx(), AD_Client_ID, TableName, null);
                next = seq.getNextID();
                seq.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            if (trx == null) {
                conn.commit();
            }
            conn = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
            next = -2;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
            conn = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(Table) - finish", e);
            pstmt = null;
        }
        if (next < 0) {
            return null;
        }
        StringBuffer doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(prefix);
        }
        doc.append(next);
        if (suffix != null && suffix.length() > 0) {
            doc.append(suffix);
        }
        String documentNo = doc.toString();
        s_log.finer(documentNo + " (" + incrementNo + ")" + " - Table=" + TableName + " [" + trx + "]");
        return documentNo;
    }

    public static synchronized String getDocumentNo(int C_DocType_ID, String trxName) {
        if (C_DocType_ID == 0) {
            s_log.severe("C_DocType_ID=0");
            return null;
        }
        MDocType dt = MDocType.get(Env.getCtx(), C_DocType_ID);
        if (dt != null && !dt.isDocNoControlled()) {
            s_log.finer("DocType_ID=" + C_DocType_ID + " Not DocNo controlled");
            return null;
        }
        if (dt == null || dt.getDocNoSequence_ID() == 0) {
            s_log.warning("No Sequence for DocType - " + dt);
            return null;
        }
        boolean compiereSys = Ini.isPropertyBool("CompiereSys");
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, "DocType_ID=" + C_DocType_ID + " [" + trxName + "]");
        }
        String selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, AD_Client_ID, AD_Sequence_ID, StartNewYear, StartNewMonth, StartNewDay, DateFormat, StartNo FROM AD_Sequence WHERE AD_Sequence_ID=? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        int incrementNo = 0;
        int next = -1;
        String prefix = "";
        String suffix = "";
        boolean startNewYear = false;
        boolean startNewMonth = false;
        boolean startNewDay = false;
        String DateFormt = null;
        String datePrefix = "";
        int startNo = 0;
        try {
            conn = trx != null ? trx.getConnection() : DB.getConnectionID();
            if (conn == null) {
                return null;
            }
            pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
            pstmt.setInt(1, dt.getDocNoSequence_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                incrementNo = rs.getInt(3);
                prefix = rs.getString(4);
                suffix = rs.getString(5);
                int AD_Client_ID = rs.getInt(6);
                if (compiereSys && AD_Client_ID > 11) {
                    compiereSys = false;
                }
                startNewYear = "Y".equals(rs.getString(8));
                startNewMonth = "Y".equals(rs.getString(9));
                startNewDay = "Y".equals(rs.getString(10));
                DateFormt = rs.getString(11);
                startNo = rs.getInt(12);
                if (compiereSys) {
                    next = rs.getInt(2);
                    rs.updateInt(2, next + incrementNo);
                } else {
                    next = rs.getInt(1);
                    if (DateFormt != null && (startNewYear || startNewMonth || startNewDay)) {
                        Calendar calToday = TimeUtil.getToday();
                        calToday.set(11, 0);
                        calToday.set(12, 0);
                        calToday.set(13, 0);
                        calToday.set(14, 0);
                        SimpleDateFormat sdf = new SimpleDateFormat(DateFormt);
                        if (prefix != null) {
                            Calendar calPrefix = Calendar.getInstance();
                            try {
                                Date dPrefix = sdf.parse(prefix);
                                calPrefix.setTime(dPrefix);
                            }
                            catch (Exception e) {
                                calPrefix.setTimeInMillis(calToday.getTimeInMillis());
                            }
                            calPrefix.set(11, 0);
                            calPrefix.set(12, 0);
                            calPrefix.set(13, 0);
                            calPrefix.set(14, 0);
                            if (startNewDay && calToday.after(calPrefix)) {
                                prefix = sdf.format(calToday.getTime());
                                rs.updateString(4, prefix);
                                next = startNo;
                            }
                            if (startNewMonth) {
                                calToday.set(5, 1);
                                calPrefix.set(5, 1);
                                if (calToday.after(calPrefix)) {
                                    prefix = sdf.format(calToday.getTime());
                                    rs.updateString(4, prefix);
                                    next = startNo;
                                }
                            }
                            if (startNewYear) {
                                calToday.set(5, 1);
                                calPrefix.set(5, 1);
                                calToday.set(2, 0);
                                calPrefix.set(2, 0);
                                if (calToday.after(calPrefix)) {
                                    prefix = sdf.format(calToday.getTime());
                                    rs.updateString(4, prefix);
                                    next = startNo;
                                }
                            }
                        } else {
                            datePrefix = sdf.format(calToday.getTime());
                        }
                    }
                    rs.updateInt(1, next + incrementNo);
                }
                rs.updateRow();
            } else {
                s_log.warning("(DocType)- no record found - " + dt);
                next = -2;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            if (trx == null) {
                conn.commit();
            }
            conn = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(DocType) [" + trxName + "]", e);
            next = -2;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
            conn = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(DocType) - finish", e);
            pstmt = null;
        }
        if (next < 0) {
            return null;
        }
        StringBuffer doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(prefix);
        }
        if (datePrefix != null && datePrefix.length() > 0) {
            doc.append(datePrefix);
        }
        doc.append(next);
        if (suffix != null && suffix.length() > 0) {
            doc.append(suffix);
        }
        String documentNo = doc.toString();
        s_log.finer(documentNo + " (" + incrementNo + ")" + " - C_DocType_ID=" + C_DocType_ID + " [" + trx + "]");
        return documentNo;
    }

    public static boolean checkClientSequences(Ctx ctx, int AD_Client_ID, String trxName) {
        String sql = "SELECT TableName FROM AD_Table t WHERE IsActive='Y' AND IsView='N' AND AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName = 'DocumentNo' OR ColumnName = 'Value') AND 'DocumentNo_' || TableName NOT IN (SELECT Name FROM AD_Sequence s WHERE s.AD_Client_ID=?)";
        int counter = 0;
        boolean success = true;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                s_log.fine("Add: " + tableName);
                MSequence seq = new MSequence(ctx, AD_Client_ID, tableName, trxName);
                if (seq.save()) {
                    ++counter;
                    continue;
                }
                s_log.severe("Not created - AD_Client_ID=" + AD_Client_ID + " - " + tableName);
                success = false;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.info("AD_Client_ID=" + AD_Client_ID + " - created #" + counter + " - success=" + success);
        return success;
    }

    public static boolean createTableSequence(Ctx ctx, String TableName, String trxName) {
        MSequence seq = new MSequence(ctx, 0, trxName);
        seq.setClientOrg(0, 0);
        seq.setName(TableName);
        seq.setDescription("Table " + TableName);
        seq.setIsTableID(true);
        return seq.save();
    }

    public static boolean deleteTableSequence(Ctx ctx, String TableName, String trxName) {
        MSequence seq = MSequence.get(ctx, TableName, trxName);
        return seq.delete(true);
    }

    public static MSequence get(Ctx ctx, String tableName, String trxName) {
        String sql = "SELECT * FROM AD_Sequence WHERE UPPER(Name)=? AND IsTableID='Y'";
        MSequence retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setString(1, tableName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MSequence(ctx, rs, null);
            }
            if (rs.next()) {
                s_log.log(Level.SEVERE, "More then one sequence for " + tableName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MSequence(Ctx ctx, int AD_Sequence_ID, String trxName) {
        super(ctx, AD_Sequence_ID, trxName);
        if (AD_Sequence_ID == 0) {
            this.setIsTableID(false);
            this.setStartNo(1000000);
            this.setCurrentNext(1000000);
            this.setCurrentNextSys(100);
            this.setIncrementNo(1);
            this.setIsAutoSequence(true);
            this.setIsAudited(false);
            this.setStartNewYear(false);
        }
    }

    public MSequence(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSequence(Ctx ctx, int AD_Client_ID, String tableName, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(PREFIX_DOCSEQ + tableName);
        this.setDescription("DocumentNo/Value for Table " + tableName);
    }

    public MSequence(Ctx ctx, int AD_Client_ID, String sequenceName, int StartNo, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(sequenceName);
        this.setDescription(sequenceName);
        this.setStartNo(StartNo);
        this.setCurrentNext(StartNo);
        this.setCurrentNextSys(StartNo / 10);
    }

    public int getNextID() {
        int retValue = this.getCurrentNext();
        this.setCurrentNext(retValue + this.getIncrementNo());
        return retValue;
    }

    public String getDocumentNo() {
        StringBuffer doc = new StringBuffer();
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            doc.append(prefix);
        }
        doc.append(this.getNextID());
        String suffix = this.getSuffix();
        if (suffix != null && suffix.length() > 0) {
            doc.append(suffix);
        }
        return doc.toString();
    }

    public boolean validateTableIDValue() {
        int maxTableSysID;
        int maxTableID;
        if (!this.isTableID()) {
            return false;
        }
        String tableName = this.getName();
        int AD_Column_ID = DB.getSQLValue(null, "SELECT MAX(c.AD_Column_ID) FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.TableName='" + tableName + "'" + " AND c.ColumnName='" + tableName + "_ID'");
        if (AD_Column_ID <= 0) {
            return false;
        }
        MSystem system = MSystem.get(this.getCtx());
        int IDRangeEnd = 0;
        if (system.getIDRangeEnd() != null) {
            IDRangeEnd = system.getIDRangeEnd().intValue();
        }
        boolean change = false;
        String info = null;
        String sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName;
        if (IDRangeEnd > 0) {
            sql = sql + " WHERE " + tableName + "_ID < " + IDRangeEnd;
        }
        if ((maxTableID = DB.getSQLValue(null, sql)) < 1000000) {
            maxTableID = 999999;
        }
        if (this.getCurrentNext() < ++maxTableID) {
            this.setCurrentNext(maxTableID);
            info = "CurrentNext=" + maxTableID;
            change = true;
        }
        if ((maxTableSysID = DB.getSQLValue(null, sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName + " WHERE " + tableName + "_ID < " + 1000000)) <= 0) {
            maxTableSysID = 99;
        }
        if (this.getCurrentNextSys() < ++maxTableSysID) {
            this.setCurrentNextSys(maxTableSysID);
            info = info == null ? "CurrentNextSys=" + maxTableSysID : info + " - CurrentNextSys=" + maxTableSysID;
            change = true;
        }
        if (info != null) {
            this.log.config(this.getName() + " - " + info);
        }
        return change;
    }

    public static void main(String[] args) {
        int i;
        Compiere.startup(true);
        CLogMgt.setLevel(Level.SEVERE);
        CLogMgt.setLoggerLevel(Level.SEVERE, null);
        s_list = new Vector(1000);
        long time = System.currentTimeMillis();
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            GetIDs r = new GetIDs(i);
            threads[i] = new Thread(r);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        time = System.currentTimeMillis() - time;
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        Object[] ia = new Integer[s_list.size()];
        s_list.toArray(ia);
        Arrays.sort(ia);
        Object last = null;
        int duplicates = 0;
        for (int i2 = 0; i2 < ia.length; ++i2) {
            if (last != null && ((Integer)last).compareTo((Integer)ia[i2]) == 0) {
                ++duplicates;
            }
            last = ia[i2];
        }
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        System.out.println("Duplicates=" + duplicates);
        System.out.println("Time (ms)=" + time + " - " + (float)time / (float)s_list.size() + " each");
        System.out.println("-------------------------------------------");
    }

    public static class GetIDs
    implements Runnable {
        private int m_i;
        private int m_errors = 0;
        private int m_no = 0;
        private Trx m_trx = null;

        public GetIDs(int i) {
            this.m_i = i;
        }

        public void run() {
            System.out.println("Run #" + this.m_i + " - started");
            String trxName = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    int no = DB.getNextID(0, "Test", trxName);
                    if (this.m_trx != null) {
                        this.m_trx.commit();
                    }
                    s_list.add(new Integer(no));
                    ++this.m_no;
                    continue;
                }
                catch (Exception e) {
                    ++this.m_errors;
                    System.err.println("#" + this.m_i + "-" + this.m_errors + ": " + e.toString());
                }
            }
            if (this.m_trx != null) {
                this.m_trx.close();
            }
            System.out.println("Run #" + this.m_i + " - complete - Errors=" + this.m_errors + " - Created=" + this.m_no);
        }

        public String toString() {
            return "GetID #" + this.m_i + " - Size=" + s_list.size();
        }
    }
}

