/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MChangeLog;
import org.compiere.model.MQueryLog;
import org.compiere.model.MRole;
import org.compiere.model.MWindowLog;
import org.compiere.model.X_AD_Session;
import org.compiere.util.CCache;
import org.compiere.util.Ctx;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class MSession
extends X_AD_Session {
    private static CCache<Integer, MSession> s_sessions = Ini.isClient() ? new CCache("AD_Session_ID", 1, 0) : new CCache("AD_Session_ID", 30, 0);
    private boolean m_webStoreSession = false;

    public static MSession get(Ctx ctx, boolean createNew) {
        int AD_Session_ID = ctx.getContextAsInt("#AD_Session_ID");
        MSession session = null;
        if (AD_Session_ID > 0) {
            session = s_sessions.get(new Integer(AD_Session_ID));
        }
        if (session == null && createNew) {
            session = new MSession(ctx, null);
            session.save();
            AD_Session_ID = session.getAD_Session_ID();
            ctx.setContext("#AD_Session_ID", AD_Session_ID);
            s_sessions.put(new Integer(AD_Session_ID), session);
        }
        return session;
    }

    public static MSession get(Ctx ctx, String Remote_Addr, String Remote_Host, String WebSession) {
        int AD_Session_ID = ctx.getContextAsInt("#AD_Session_ID");
        MSession session = null;
        if (AD_Session_ID > 0) {
            session = s_sessions.get(new Integer(AD_Session_ID));
        }
        if (session == null) {
            session = new MSession(ctx, Remote_Addr, Remote_Host, WebSession, null);
            session.save();
            AD_Session_ID = session.getAD_Session_ID();
            ctx.setContext("#AD_Session_ID", AD_Session_ID);
            s_sessions.put(new Integer(AD_Session_ID), session);
        }
        return session;
    }

    public MSession(Ctx ctx, int AD_Session_ID, String trxName) {
        super(ctx, AD_Session_ID, trxName);
        if (AD_Session_ID == 0) {
            this.setProcessed(false);
            int AD_Role_ID = ctx.getAD_Role_ID();
            this.setAD_Role_ID(AD_Role_ID);
        }
    }

    public MSession(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSession(Ctx ctx, String Remote_Addr, String Remote_Host, String WebSession, String trxName) {
        this(ctx, 0, trxName);
        if (Remote_Addr != null) {
            this.setRemote_Addr(Remote_Addr);
        }
        if (Remote_Host != null) {
            this.setRemote_Host(Remote_Host);
        }
        if (WebSession != null) {
            this.setWebSession(WebSession);
        }
    }

    public MSession(Ctx ctx, String trxName) {
        this(ctx, 0, trxName);
        try {
            InetAddress lh = InetAddress.getLocalHost();
            this.setRemote_Addr(lh.getHostAddress());
            this.setRemote_Host(lh.getHostName());
        }
        catch (UnknownHostException e) {
            this.log.log(Level.SEVERE, "No Local Host", e);
        }
    }

    public boolean isWebStoreSession() {
        return this.m_webStoreSession;
    }

    public void setWebStoreSession(boolean webStoreSession) {
        this.m_webStoreSession = webStoreSession;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MSession[").append(this.getAD_Session_ID()).append(",AD_User_ID=").append(this.getCreatedBy()).append(",").append(this.getCreated()).append(",Remote=").append(this.getRemote_Addr());
        String s = this.getRemote_Host();
        if (s != null && s.length() > 0) {
            sb.append(",").append(s);
        }
        if (this.m_webStoreSession) {
            sb.append(",WebStoreSession");
        }
        sb.append("]");
        return sb.toString();
    }

    public void logout() {
        this.setProcessed(true);
        this.save();
        s_sessions.remove(new Integer(this.getAD_Session_ID()));
        this.log.info(TimeUtil.formatElapsed(this.getCreated(), this.getUpdated()));
    }

    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, Object keyInfo, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String tableName, String type) {
        if (OldValue == null && NewValue == null) {
            return null;
        }
        if (OldValue != null && NewValue != null && OldValue.equals(NewValue)) {
            return null;
        }
        if (MChangeLog.isNotLogged(AD_Table_ID, tableName, AD_Column_ID, type)) {
            return null;
        }
        MRole role = MRole.getDefault(this.getCtx(), false);
        if (!(this.m_webStoreSession || MChangeLog.isLogged(AD_Table_ID, type) || role != null && role.isChangeLog())) {
            return null;
        }
        this.log.finest("AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + ": " + OldValue + " -> " + NewValue);
        boolean success = false;
        try {
            MChangeLog cl = new MChangeLog(this.getCtx(), AD_ChangeLog_ID, TrxName, this.getAD_Session_ID(), AD_Table_ID, AD_Column_ID, keyInfo, AD_Client_ID, AD_Org_ID, OldValue, NewValue);
            if (cl.save()) {
                return cl;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID, e);
            return null;
        }
        this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID);
        return null;
    }

    public MQueryLog queryLog(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, String whereClause, int recordCount, String parameter) {
        MQueryLog qlog = null;
        try {
            qlog = new MQueryLog(this.getCtx(), this.getAD_Session_ID(), AD_Client_ID, AD_Org_ID, AD_Table_ID, whereClause, recordCount, parameter);
            qlog.save();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", Where=" + whereClause, e);
        }
        return qlog;
    }

    public MQueryLog queryLog(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, String whereClause, int recordCount) {
        return this.queryLog(AD_Client_ID, AD_Org_ID, AD_Table_ID, whereClause, recordCount, (String)null);
    }

    public MQueryLog queryLog(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, String whereClause, int recordCount, Object parameter) {
        String para = null;
        if (parameter != null) {
            para = parameter.toString();
        }
        return this.queryLog(AD_Client_ID, AD_Org_ID, AD_Table_ID, whereClause, recordCount, para);
    }

    public MQueryLog queryLog(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, String whereClause, int recordCount, Object[] parameters) {
        String para = null;
        if (parameters != null && parameters.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (parameters[i] == null) {
                    sb.append("NULL");
                    continue;
                }
                sb.append(parameters[i].toString());
            }
            para = sb.toString();
        }
        return this.queryLog(AD_Client_ID, AD_Org_ID, AD_Table_ID, whereClause, recordCount, para);
    }

    public MWindowLog windowLog(int AD_Client_ID, int AD_Org_ID, int AD_Window_ID, int AD_Form_ID) {
        MWindowLog wlog = null;
        try {
            wlog = new MWindowLog(this.getCtx(), this.getAD_Session_ID(), AD_Client_ID, AD_Org_ID, AD_Window_ID, AD_Form_ID);
            wlog.save();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Window_ID=" + AD_Window_ID + ", AD_Form_ID=" + AD_Form_ID, e);
        }
        return wlog;
    }
}

