/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_AD_Table_Access;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MTableAccess
extends X_AD_Table_Access {
    private String m_tableName;

    public MTableAccess(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MTableAccess(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MTableAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(",Exclude=").append(this.isExclude()).append(",Type=").append(this.getAccessTypeRule());
        if ("A".equals(this.getAccessTypeRule())) {
            sb.append("-ReadOnly=").append(this.isReadOnly());
        } else if ("E".equals(this.getAccessTypeRule())) {
            sb.append("-CanExport=").append(this.isCanExport());
        } else if ("R".equals(this.getAccessTypeRule())) {
            sb.append("-CanReport=").append(this.isCanReport());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Ctx ctx) {
        String in = Msg.getMsg(ctx, "Include");
        String ex = Msg.getMsg(ctx, "Exclude");
        StringBuffer sb = new StringBuffer();
        sb.append(Msg.translate(ctx, "AD_Table_ID")).append("=").append(this.getTableName(ctx));
        if ("A".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "IsReadOnly")).append("=").append(this.isReadOnly());
        } else if ("E".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "IsCanExport")).append("=").append(this.isCanExport());
        } else if ("R".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "IsCanReport")).append("=").append(this.isCanReport());
        }
        sb.append(" - ").append(this.isExclude() ? ex : in);
        return sb.toString();
    }

    public String getTableName(Ctx ctx) {
        if (this.m_tableName == null) {
            String sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Table_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_tableName = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getTableName", e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            String realName = Msg.translate(ctx, this.m_tableName + "_ID");
            if (!realName.equals(this.m_tableName + "_ID")) {
                this.m_tableName = realName;
            }
        }
        return this.m_tableName;
    }
}

