/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.compiere.model.CTreeNode;
import org.compiere.model.MClient;
import org.compiere.model.MPrintColor;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_Tree;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MTree
extends X_AD_Tree {
    private static CCache<Integer, MTree> s_cache = new CCache("AD_Tree", 10);
    private static ArrayList<String> s_TableNames = null;
    private static ArrayList<Integer> s_TableIDs = null;
    private static ArrayList<Integer> s_TableIDs_U1 = null;
    private static ArrayList<Integer> s_TableIDs_U2 = null;
    private static ArrayList<Integer> s_TableIDs_U3 = null;
    private static ArrayList<Integer> s_TableIDs_U4 = null;
    private static CLogger s_log = CLogger.getCLogger(MTree.class);
    private boolean m_editable = false;
    private CTreeNode m_root = null;
    private ArrayList<CTreeNode> m_buffer = new ArrayList();
    private RowSet m_nodeRowSet;
    private boolean m_clientTree = true;
    private static final String[] TREETYPES = new String[]{"AY", "BB", "BP", "CC", "CM", "CS", "CT", "EV", "MC", "MM", "OO", "PC", "PJ", "PR", "SR", "U1", "U2", "U3", "U4", "XX"};
    private static final int[] TABLEIDS = new int[]{316, 798, 291, 855, 857, 866, 854, 188, 274, 116, 155, 209, 203, 208, 230, 0, 0, 0, 0, 0};

    public static int getDefaultAD_Tree_ID(int AD_Client_ID, int AD_Table_ID) {
        s_log.finer("AD_Table_ID=" + AD_Table_ID);
        if (AD_Table_ID == 0) {
            return 0;
        }
        int AD_Tree_ID = 0;
        String sql = "SELECT AD_Tree_ID, Name FROM AD_Tree WHERE AD_Client_ID=? AND AD_Table_ID=? AND IsActive='Y' AND IsAllNodes='Y' ORDER BY IsDefault DESC, AD_Tree_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Tree_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return AD_Tree_ID;
    }

    public static int getDefaultAD_Tree_ID(int AD_Client_ID, String tableName) {
        s_log.finer("TableName=" + tableName);
        if (tableName == null) {
            return 0;
        }
        int AD_Tree_ID = 0;
        String sql = "SELECT tr.AD_Tree_ID, tr.Name FROM AD_Tree tr INNER JOIN AD_Table tb ON (tr.AD_Table_ID=tb.AD_Table_ID) WHERE tr.AD_Client_ID=? AND tb.TableName=? AND tr.IsActive='Y' AND tr.IsAllNodes='Y' ORDER BY tr.IsDefault DESC, tr.AD_Tree_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setString(2, tableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Tree_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return AD_Tree_ID;
    }

    static String getNodeTableName(String treeType) {
        String nodeTableName = "AD_TreeNode";
        if ("MM".equals(treeType)) {
            nodeTableName = nodeTableName + "MM";
        } else if ("BP".equals(treeType)) {
            nodeTableName = nodeTableName + "BP";
        } else if ("PR".equals(treeType)) {
            nodeTableName = nodeTableName + "PR";
        } else if ("CC".equals(treeType)) {
            nodeTableName = nodeTableName + "CMC";
        } else if ("CS".equals(treeType)) {
            nodeTableName = nodeTableName + "CMS";
        } else if ("CM".equals(treeType)) {
            nodeTableName = nodeTableName + "CMM";
        } else if ("CT".equals(treeType)) {
            nodeTableName = nodeTableName + "CMT";
        } else if ("U1".equals(treeType)) {
            nodeTableName = nodeTableName + "U1";
        } else if ("U2".equals(treeType)) {
            nodeTableName = nodeTableName + "U2";
        } else if ("U3".equals(treeType)) {
            nodeTableName = nodeTableName + "U3";
        } else if ("U4".equals(treeType)) {
            nodeTableName = nodeTableName + "U4";
        }
        return nodeTableName;
    }

    public static String getNodeTableName(int AD_Table_ID) {
        String nodeTableName = "AD_TreeNode";
        if (116 == AD_Table_ID) {
            nodeTableName = nodeTableName + "MM";
        } else if (291 == AD_Table_ID) {
            nodeTableName = nodeTableName + "BP";
        } else if (208 == AD_Table_ID) {
            nodeTableName = nodeTableName + "PR";
        } else if (855 == AD_Table_ID) {
            nodeTableName = nodeTableName + "CMC";
        } else if (866 == AD_Table_ID) {
            nodeTableName = nodeTableName + "CMS";
        } else if (857 == AD_Table_ID) {
            nodeTableName = nodeTableName + "CMM";
        } else if (854 == AD_Table_ID) {
            nodeTableName = nodeTableName + "CMT";
        } else {
            Integer ii;
            if (s_TableIDs == null) {
                MTree.fillUserTables(null);
            }
            if (s_TableIDs.contains(ii = new Integer(AD_Table_ID))) {
                if (s_TableIDs_U1.contains(ii)) {
                    nodeTableName = nodeTableName + "U1";
                } else if (s_TableIDs_U2.contains(ii)) {
                    nodeTableName = nodeTableName + "U2";
                } else if (s_TableIDs_U3.contains(ii)) {
                    nodeTableName = nodeTableName + "U3";
                } else if (s_TableIDs_U4.contains(ii)) {
                    nodeTableName = nodeTableName + "U4";
                }
            } else {
                return null;
            }
        }
        return nodeTableName;
    }

    public static boolean hasTree(int AD_Table_ID) {
        if (s_TableIDs == null) {
            MTree.fillUserTables(null);
        }
        Integer ii = new Integer(AD_Table_ID);
        return s_TableIDs.contains(ii);
    }

    public static boolean hasTree(String tableName) {
        if (s_TableNames == null) {
            MTree.fillUserTables(null);
        }
        return s_TableIDs.contains(tableName);
    }

    static synchronized void fillUserTables(String trxName) {
        s_TableNames = new ArrayList();
        s_TableIDs = new ArrayList();
        s_TableIDs_U1 = new ArrayList();
        s_TableIDs_U2 = new ArrayList();
        s_TableIDs_U3 = new ArrayList();
        s_TableIDs_U4 = new ArrayList();
        String sql = "SELECT DISTINCT TreeType, AD_Table_ID FROM AD_Tree";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String TreeType = rs.getString(1);
                int AD_Table_ID = rs.getInt(2);
                if (AD_Table_ID == 0) continue;
                Integer ii = new Integer(AD_Table_ID);
                s_TableIDs.add(ii);
                if (TreeType.equals("U1")) {
                    s_TableIDs_U1.add(ii);
                    continue;
                }
                if (TreeType.equals("U2")) {
                    s_TableIDs_U2.add(ii);
                    continue;
                }
                if (TreeType.equals("U3")) {
                    s_TableIDs_U3.add(ii);
                    continue;
                }
                if (!TreeType.equals("U4")) continue;
                s_TableIDs_U4.add(ii);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (s_TableIDs.size() < 3) {
            MTree xx = MTree.get(Env.getCtx(), 10, trxName);
            xx.updateTrees();
            MTree.fillUserTables(null);
        }
    }

    public static MTree get(Ctx ctx, int AD_Tree_ID, String trxName) {
        Integer key = new Integer(AD_Tree_ID);
        MTree retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTree(ctx, AD_Tree_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MTree(Ctx ctx, int AD_Tree_ID, String trxName) {
        super(ctx, AD_Tree_ID, trxName);
        if (AD_Tree_ID == 0) {
            this.setIsAllNodes(true);
            this.setIsDefault(false);
        }
    }

    public MTree(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTree(MClient client, String name, String treeType) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(name);
        this.setTreeType(treeType);
        this.setAD_Table_ID();
    }

    public MTree(Ctx ctx, String Name2, String TreeType, String trxName) {
        this(ctx, 0, trxName);
        this.setName(Name2);
        this.setTreeType(TreeType);
        this.setAD_Table_ID();
        this.setIsAllNodes(true);
        this.setIsDefault(false);
    }

    public MTree(Ctx ctx, int AD_Tree_ID, boolean editable, boolean clientTree, String trxName) {
        this(ctx, AD_Tree_ID, trxName);
        this.m_editable = editable;
        int AD_User_ID = ctx.getAD_User_ID();
        this.m_clientTree = clientTree;
        this.log.info("AD_Tree_ID=" + AD_Tree_ID + ", AD_User_ID=" + AD_User_ID + ", Editable=" + editable + ", OnClient=" + clientTree);
        this.loadNodes(AD_User_ID);
    }

    private void loadNodes(int AD_User_ID) {
        CTreeNode node;
        StringBuffer sql = new StringBuffer("SELECT tn.Node_ID,tn.Parent_ID,tn.SeqNo,tb.IsActive FROM ").append(this.getNodeTableName()).append(" tn LEFT OUTER JOIN AD_TreeBar tb ON (tn.AD_Tree_ID=tb.AD_Tree_ID AND tn.Node_ID=tb.Node_ID AND tb.AD_User_ID=?) WHERE tn.AD_Tree_ID=?");
        if (!this.m_editable) {
            sql.append(" AND tn.IsActive='Y'");
        }
        sql.append(" ORDER BY COALESCE(tn.Parent_ID, -1), tn.SeqNo");
        this.log.finest(sql.toString());
        try {
            this.getNodeDetails();
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, this.getAD_Tree_ID());
            ResultSet rs = pstmt.executeQuery();
            this.m_root = new CTreeNode(0, 0, this.getName(), this.getDescription(), 0, true, null, false, null);
            while (rs.next()) {
                boolean onBar;
                int node_ID = rs.getInt(1);
                int parent_ID = rs.getInt(2);
                int seqNo = rs.getInt(3);
                boolean bl = onBar = rs.getString(4) != null;
                if (node_ID == 0 && parent_ID == 0) continue;
                this.addToTree(node_ID, parent_ID, seqNo, onBar);
            }
            rs.close();
            pstmt.close();
            this.m_nodeRowSet.close();
            this.m_nodeRowSet = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
            this.m_nodeRowSet = null;
        }
        if (this.m_buffer.size() != 0) {
            int i;
            this.log.finest("clearing buffer - Adding to: " + this.m_root);
            for (i = 0; i < this.m_buffer.size(); ++i) {
                CTreeNode parent;
                node = this.m_buffer.get(i);
                if (node == null || (parent = this.m_root.findNode(node.getParent_ID())) == null || !parent.getAllowsChildren()) continue;
                parent.add(node);
                this.checkBuffer(node);
                this.m_buffer.set(i, null);
            }
            for (i = this.m_buffer.size() - 1; i >= 0; --i) {
                node = this.m_buffer.get(i);
                if (node != null) continue;
                this.m_buffer.remove(i);
            }
        }
        if (this.m_buffer.size() != 0) {
            int i;
            this.log.severe("Nodes w/o parent - adding to root - " + this.m_buffer);
            for (i = 0; i < this.m_buffer.size(); ++i) {
                node = this.m_buffer.get(i);
                if (node == null) continue;
                this.m_root.add(node);
                this.checkBuffer(node);
                this.m_buffer.set(i, null);
            }
            for (i = this.m_buffer.size() - 1; i >= 0; --i) {
                node = this.m_buffer.get(i);
                if (node != null) continue;
                this.m_buffer.remove(i);
            }
            if (this.m_buffer.size() != 0) {
                this.log.severe("Still nodes in Buffer - " + this.m_buffer);
            }
        }
        if (!this.m_editable && this.m_root.getChildCount() > 0) {
            this.trimTree();
        }
        if (CLogMgt.isLevelFinest() || this.m_root.getChildCount() == 0) {
            this.log.fine("ChildCount=" + this.m_root.getChildCount());
        }
    }

    private void addToTree(int node_ID, int parent_ID, int seqNo, boolean onBar) {
        CTreeNode child;
        if (node_ID == 301) {
            this.log.info("node_ID=" + node_ID + ", Parent=" + parent_ID + ", Ok");
        }
        if ((child = this.getNodeDetail(node_ID, parent_ID, seqNo, onBar)) == null) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        if (this.m_root != null) {
            parent = this.m_root.findNode(parent_ID);
        }
        if (parent != null && parent.getAllowsChildren()) {
            parent.add(child);
            if (this.m_buffer.size() > 0) {
                this.checkBuffer(child);
            }
        } else {
            this.m_buffer.add(child);
        }
    }

    private void checkBuffer(CTreeNode newNode) {
        if (!newNode.isSummary() || !newNode.getAllowsChildren()) {
            return;
        }
        for (int i = 0; i < this.m_buffer.size(); ++i) {
            CTreeNode node = this.m_buffer.get(i);
            if (node == null || node.getParent_ID() != newNode.getNode_ID()) continue;
            try {
                newNode.add(node);
            }
            catch (Exception e) {
                this.log.severe("Adding " + node.getName() + " to " + newNode.getName() + ": " + e.getMessage());
            }
            this.m_buffer.set(i, null);
        }
    }

    private void getNodeDetails() {
        StringBuffer sqlNode = new StringBuffer();
        String sourceTable = "t";
        String fromClause = this.getSourceTableName(false);
        String columnNameX = this.getSourceTableName(true);
        String color = this.getActionColorName();
        if (this.getTreeType().equals("MM")) {
            boolean hasWhere;
            boolean base = Env.isBaseLanguage(this.p_ctx, "AD_Menu");
            sourceTable = "m";
            if (base) {
                sqlNode.append("SELECT m.AD_Menu_ID, m.Name,m.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID FROM AD_Menu m");
            } else {
                sqlNode.append("SELECT m.AD_Menu_ID,  t.Name,t.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID FROM AD_Menu m, AD_Menu_Trl t");
            }
            if (!base) {
                sqlNode.append(" WHERE m.AD_Menu_ID=t.AD_Menu_ID AND t.AD_Language='").append(Env.getAD_Language(this.p_ctx)).append("'");
            }
            if (!this.m_editable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ").append("m.IsActive='Y' ");
            }
            if (!MClient.get(this.getCtx()).isUseBetaFunctions()) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Window_ID IS NULL OR EXISTS (SELECT * FROM AD_Window w WHERE m.AD_Window_ID=w.AD_Window_ID AND w.IsBetaFunctionality='N'))").append(" AND (m.AD_Process_ID IS NULL OR EXISTS (SELECT * FROM AD_Process p WHERE m.AD_Process_ID=p.AD_Process_ID AND p.IsBetaFunctionality='N'))").append(" AND (m.AD_Form_ID IS NULL OR EXISTS (SELECT * FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND f.IsBetaFunctionality='N'))");
            }
            if (!this.m_editable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Form_ID IS NULL OR EXISTS (SELECT * FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND ");
                if (this.m_clientTree) {
                    sqlNode.append("f.Classname");
                } else {
                    sqlNode.append("f.JSPURL");
                }
                sqlNode.append(" IS NOT NULL))");
            }
        } else {
            if (columnNameX == null) {
                throw new IllegalArgumentException("Unknown TreeType=" + this.getTreeType());
            }
            sqlNode.append("SELECT t.").append(columnNameX).append("_ID,t.Name,t.Description,t.IsSummary,").append(color).append(" FROM ").append(fromClause);
            if (!this.m_editable) {
                sqlNode.append(" WHERE t.IsActive='Y'");
            }
        }
        String sql = sqlNode.toString();
        if (!this.m_editable) {
            sql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql, sourceTable, true, this.m_editable);
        }
        this.log.fine(sql);
        this.m_nodeRowSet = DB.getRowSet(sql, true);
    }

    private CTreeNode getNodeDetail(int node_ID, int parent_ID, int seqNo, boolean onBar) {
        int AD_Window_ID = 0;
        int AD_Process_ID = 0;
        int AD_Form_ID = 0;
        int AD_Workflow_ID = 0;
        int AD_Task_ID = 0;
        int AD_Workbench_ID = 0;
        CTreeNode retValue = null;
        try {
            this.m_nodeRowSet.beforeFirst();
            while (this.m_nodeRowSet.next()) {
                MPrintColor printColor;
                int node = this.m_nodeRowSet.getInt(1);
                if (node_ID != node) continue;
                int index = 2;
                String name = this.m_nodeRowSet.getString(index++);
                String description = this.m_nodeRowSet.getString(index++);
                boolean isSummary = "Y".equals(this.m_nodeRowSet.getString(index++));
                String actionColor = this.m_nodeRowSet.getString(index++);
                if (this.getTreeType().equals("MM") && !isSummary) {
                    AD_Window_ID = this.m_nodeRowSet.getInt(index++);
                    AD_Process_ID = this.m_nodeRowSet.getInt(index++);
                    AD_Form_ID = this.m_nodeRowSet.getInt(index++);
                    AD_Workflow_ID = this.m_nodeRowSet.getInt(index++);
                    AD_Task_ID = this.m_nodeRowSet.getInt(index++);
                    AD_Workbench_ID = this.m_nodeRowSet.getInt(index++);
                    MRole role = MRole.getDefault(this.getCtx(), false);
                    Boolean access = null;
                    if ("W".equals(actionColor)) {
                        access = role.getWindowAccess(AD_Window_ID);
                    } else if ("P".equals(actionColor) || "R".equals(actionColor)) {
                        access = role.getProcessAccess(AD_Process_ID);
                    } else if ("X".equals(actionColor)) {
                        access = role.getFormAccess(AD_Form_ID);
                    } else if ("F".equals(actionColor)) {
                        access = role.getWorkflowAccess(AD_Workflow_ID);
                    } else if ("T".equals(actionColor)) {
                        access = role.getTaskAccess(AD_Task_ID);
                    }
                    if (access == null && !this.m_editable) continue;
                    retValue = new CTreeNode(node_ID, seqNo, name, description, parent_ID, isSummary, actionColor, onBar, null);
                    continue;
                }
                Color color = null;
                if (actionColor != null && !this.getTreeType().equals("MM") && (printColor = MPrintColor.get(this.getCtx(), actionColor)) != null) {
                    color = printColor.getColor();
                }
                retValue = new CTreeNode(node_ID, seqNo, name, description, parent_ID, isSummary, null, onBar, color);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        if (retValue != null) {
            retValue.setAD_Window_ID(AD_Window_ID);
            retValue.setAD_Process_ID(AD_Process_ID);
            retValue.setAD_Form_ID(AD_Form_ID);
            retValue.setAD_Workflow_ID(AD_Workflow_ID);
            retValue.setAD_Task_ID(AD_Task_ID);
            retValue.setAD_Workbench_ID(AD_Workbench_ID);
        }
        return retValue;
    }

    public void trimTree() {
        boolean needsTrim;
        boolean bl = needsTrim = this.m_root != null;
        while (needsTrim) {
            needsTrim = false;
            Enumeration<TreeNode> en = this.m_root.preorderEnumeration();
            while (this.m_root.getChildCount() > 0 && en.hasMoreElements()) {
                CTreeNode nd = (CTreeNode)en.nextElement();
                if (!nd.isSummary() || nd.getChildCount() != 0) continue;
                nd.removeFromParent();
                needsTrim = true;
            }
        }
    }

    void dumpTree() {
        Enumeration<TreeNode> en = this.m_root.preorderEnumeration();
        int count = 0;
        while (en.hasMoreElements()) {
            StringBuffer sb = new StringBuffer();
            CTreeNode nd = (CTreeNode)en.nextElement();
            for (int i = 0; i < nd.getLevel(); ++i) {
                sb.append(" ");
            }
            sb.append("ID=").append(nd.getNode_ID()).append(", SeqNo=").append(nd.getSeqNo()).append(" ").append(nd.getName());
            System.out.println(sb.toString());
            ++count;
        }
        System.out.println("Count=" + count);
    }

    public CTreeNode getRoot() {
        return this.m_root;
    }

    public boolean isMenu() {
        return "MM".equals(this.getTreeType());
    }

    public boolean isProduct() {
        return "PR".equals(this.getTreeType());
    }

    public boolean isBPartner() {
        return "BP".equals(this.getTreeType());
    }

    public String getNodeTableName() {
        return MTree.getNodeTableName(this.getTreeType());
    }

    public String getSourceTableName(boolean tableNameOnly) {
        int AD_Table_ID = this.getAD_Table_ID();
        String tableName = MTable.getTableName(this.getCtx(), AD_Table_ID);
        if (tableNameOnly) {
            return tableName;
        }
        if ("M_Product".equals(tableName)) {
            return "M_Product t INNER JOIN M_Product_Category x ON (t.M_Product_Category_ID=x.M_Product_Category_ID)";
        }
        if ("C_BPartner".equals(tableName)) {
            return "C_BPartner t INNER JOIN C_BP_Group x ON (t.C_BP_Group_ID=x.C_BP_Group_ID)";
        }
        if ("AD_Org".equals(tableName)) {
            return "AD_Org t INNER JOIN AD_OrgInfo i ON (t.AD_Org_ID=i.AD_Org_ID) LEFT OUTER JOIN AD_OrgType x ON (i.AD_OrgType_ID=x.AD_OrgType_ID)";
        }
        if ("C_Campaign".equals(tableName)) {
            return "C_Campaign t LEFT OUTER JOIN C_Channel x ON (t.C_Channel_ID=x.C_Channel_ID)";
        }
        if (tableName != null) {
            tableName = tableName + " t";
        }
        return tableName;
    }

    public String getActionColorName() {
        int AD_Table_ID = this.getAD_Table_ID();
        String tableName = MTable.getTableName(this.getCtx(), AD_Table_ID);
        if ("AD_Menu".equals(tableName)) {
            return "t.Action";
        }
        if ("M_Product".equals(tableName) || "C_BPartner".equals(tableName) || "AD_Org".equals(tableName) || "C_Campaign".equals(tableName)) {
            return "x.AD_PrintColor_ID";
        }
        return "NULL";
    }

    public int getAD_Table_ID() {
        int AD_Table_ID = super.getAD_Table_ID();
        if (AD_Table_ID == 0) {
            AD_Table_ID = this.setAD_Table_ID();
        }
        return AD_Table_ID;
    }

    public int getAD_Table_ID(boolean base) {
        if (base) {
            return super.getAD_Table_ID();
        }
        return this.getAD_Table_ID();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!(this.isActive() && this.isAllNodes() || !this.isDefault())) {
            this.setIsDefault(false);
        }
        if (this.getAD_Table_ID(true) == 0) {
            if (newRecord) {
                this.setAD_Table_ID();
            } else {
                this.updateTrees();
            }
            if (this.getAD_Table_ID(true) == 0) {
                this.log.warning("No Table for " + this.toString());
                return false;
            }
        }
        return this.validate();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        String treeType = this.getTreeType();
        if (treeType.startsWith("U")) {
            MTree.fillUserTables(this.get_TrxName());
        }
        return success;
    }

    private int setAD_Table_ID() {
        int AD_Table_ID = 0;
        String type = this.getTreeType();
        if (type == null || type.startsWith("U") || type.equals("XX")) {
            return 0;
        }
        for (int i = 0; i < TREETYPES.length; ++i) {
            if (!type.equals(TREETYPES[i])) continue;
            AD_Table_ID = TABLEIDS[i];
            break;
        }
        if (AD_Table_ID != 0) {
            this.setAD_Table_ID(AD_Table_ID);
        }
        if (AD_Table_ID == 0) {
            this.log.warning("Did not find Table for TreeType=" + type);
        }
        return AD_Table_ID;
    }

    private boolean validate() {
        String type = this.getTreeType();
        if (type != null && (type.startsWith("U") || type.equals("XX"))) {
            return true;
        }
        int AD_Table_ID = this.getAD_Table_ID(true);
        for (int i = 0; i < TREETYPES.length; ++i) {
            if (type == null) {
                if (AD_Table_ID != TABLEIDS[i]) continue;
                this.setTreeType(TREETYPES[i]);
                return true;
            }
            if (AD_Table_ID == TABLEIDS[i]) {
                if (type.equals(TREETYPES[i])) {
                    return true;
                }
                this.setTreeType(TREETYPES[i]);
                return true;
            }
            if (AD_Table_ID != 0 || !type.equals(TREETYPES[i])) continue;
            this.setAD_Table_ID(TABLEIDS[i]);
            return true;
        }
        if (type == null) {
            this.setTreeType("XX");
            return true;
        }
        this.log.warning("TreeType=" + type + " <> AD_Table_ID=" + AD_Table_ID);
        this.setTreeType("XX");
        return false;
    }

    public void updateTrees() {
        this.setAD_Table_ID();
        for (int i = 0; i < TREETYPES.length; ++i) {
            this.updateTrees(TREETYPES[i], TABLEIDS[i]);
        }
    }

    private void updateTrees(String treeType, int AD_Table_ID) {
        if (AD_Table_ID == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer("UPDATE AD_Tree SET AD_Table_ID=").append(AD_Table_ID).append(" WHERE TreeType='").append(treeType).append("' AND AD_Table_ID IS NULL");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        this.log.fine(treeType + " #" + no);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MTree[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getTreeType()).append(",AD_Table_ID=").append(this.getAD_Table_ID(true)).append("]");
        return sb.toString();
    }
}

