/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_AD_Element;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class M_Element
extends X_AD_Element {
    private static CLogger s_log = CLogger.getCLogger(M_Element.class);

    public static String getColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return columnName;
        }
        String retValue = columnName;
        String sql = "SELECT ColumnName FROM AD_Element WHERE UPPER(ColumnName)=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, columnName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString(1);
                if (rs.next()) {
                    s_log.warning("Not unique: " + columnName + " -> " + retValue + " - " + rs.getString(1));
                }
            } else {
                s_log.warning("No found: " + columnName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, columnName, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static M_Element get(Ctx ctx, String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        M_Element retValue = null;
        String sql = "SELECT * FROM AD_Element WHERE UPPER(ColumnName)=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, columnName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new M_Element(ctx, rs, null);
                if (rs.next()) {
                    s_log.warning("Not unique: " + columnName + " -> " + retValue + " - " + rs.getString("ColumnName"));
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static M_Element getOfColumn(Ctx ctx, int AD_Column_ID) {
        if (AD_Column_ID == 0) {
            return null;
        }
        M_Element retValue = null;
        String sql = "SELECT * FROM AD_Element e WHERE EXISTS (SELECT * FROM AD_Column c WHERE c.AD_Element_ID=e.AD_Element_ID AND c.AD_Column_ID=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Column_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new M_Element(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public M_Element(Ctx ctx, int AD_Element_ID, String trxName) {
        super(ctx, AD_Element_ID, trxName);
        if (AD_Element_ID == 0) {
            // empty if block
        }
    }

    public M_Element(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public M_Element(Ctx ctx, String columnName, String EntityType, String trxName) {
        super(ctx, 0, trxName);
        this.setColumnName(columnName);
        this.setName(columnName);
        this.setPrintName(columnName);
        this.setEntityType(EntityType);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            StringBuffer sql = new StringBuffer("UPDATE AD_Column SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Element_ID=").append(this.get_ID());
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Columns updated #" + no);
            sql = new StringBuffer("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Column_ID IN (SELECT AD_Column_ID FROM AD_Column WHERE AD_Element_ID=").append(this.get_ID()).append(") AND IsCentrallyMaintained='Y'").append(" AND AD_Tab_ID IN (SELECT AD_Tab_ID FROM AD_Tab t INNER JOIN AD_Window w ON (t.AD_Window_ID=w.AD_Window_ID) WHERE t.AD_CtxArea_ID IS NULL AND w.AD_CtxArea_ID IS NULL)");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Fields updated #" + no);
            sql = new StringBuffer("UPDATE AD_Process_Para SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", AD_Element_ID=").append(this.get_ID()).append(" WHERE UPPER(ColumnName)=").append(DB.TO_STRING(this.getColumnName().toUpperCase())).append(" AND IsCentrallyMaintained='Y' AND AD_Element_ID IS NULL");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE AD_Process_Para SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Element_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'").append(" AND AD_Process_ID IN (SELECT AD_Process_ID FROM AD_Process WHERE AD_CtxArea_ID IS NULL)");
            this.log.fine("Parameters updated #" + (no += DB.executeUpdate(sql.toString(), this.get_TrxName())));
            sql = new StringBuffer("UPDATE AD_PrintFormatItem pi SET PrintName=").append(DB.TO_STRING(this.getPrintName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(" WHERE IsCentrallyMaintained='Y'").append(" AND EXISTS (SELECT * FROM AD_Column c ").append("WHERE c.AD_Column_ID=pi.AD_Column_ID AND c.AD_Element_ID=").append(this.get_ID()).append(")");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("PrintFormatItem updated #" + no);
            sql = new StringBuffer("UPDATE AD_InfoColumn SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Element_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("InfoWindow updated #" + no);
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("M_Element[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }
}

