/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.im.InputMethodRequests;
import java.util.logging.Level;
import javax.swing.InputVerifier;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;
import org.compiere.swing.PublishInterface;

public class CTextArea
extends JScrollPane
implements CEditor,
FocusListener,
PublishInterface {
    private JTextArea m_textArea = null;
    private static final String NL = System.getProperty("line.separator");
    private boolean m_mandatory = false;

    public CTextArea() {
        this(new JTextArea());
    }

    public CTextArea(String text) {
        this(new JTextArea(text));
    }

    public CTextArea(int rows, int columns) {
        this(new JTextArea(rows, columns));
    }

    public CTextArea(String text, int rows, int columns) {
        this(new JTextArea(text, rows, columns));
    }

    public CTextArea(Document doc) {
        this(new JTextArea(doc));
    }

    public CTextArea(Document doc, String text, int rows, int columns) {
        this(new JTextArea(doc, text, rows, columns));
    }

    public CTextArea(JTextArea textArea) {
        super(textArea);
        this.m_textArea = textArea;
        super.setOpaque(false);
        super.getViewport().setOpaque(false);
        this.m_textArea.setFont(CompierePLAF.getFont_Field());
        this.m_textArea.setForeground(CompierePLAF.getTextColor_Normal());
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setWrapStyleWord(true);
        this.m_textArea.firePropertyChange("editable", !this.isEditable(), this.isEditable());
        this.setBackground(false);
        this.m_textArea.addFocusListener(this);
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (this.m_textArea.isEditable() != rw) {
            this.m_textArea.setEditable(rw);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return this.m_textArea.isEditable();
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    public void setBackground(Color color) {
        if (color.equals(this.getBackground())) {
            return;
        }
        if (this.m_textArea == null) {
            super.setBackground(color);
        } else {
            this.m_textArea.setBackground(color);
        }
    }

    public Color getBackground() {
        if (this.m_textArea == null) {
            return super.getBackground();
        }
        return this.m_textArea.getBackground();
    }

    public void setForeground(Color color) {
        if (this.m_textArea == null) {
            super.setForeground(color);
        } else {
            this.m_textArea.setForeground(color);
        }
    }

    public Color getForeground() {
        if (this.m_textArea == null) {
            return super.getForeground();
        }
        return this.m_textArea.getForeground();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.m_textArea.setText("");
        } else {
            this.m_textArea.setText(value.toString());
        }
    }

    public Object getValue() {
        return this.m_textArea.getText();
    }

    public String getDisplay() {
        return this.m_textArea.getText();
    }

    public void setText(String text) {
        this.m_textArea.setText(text);
        this.m_textArea.setCaretPosition(0);
    }

    public String getText() {
        return this.m_textArea.getText();
    }

    public void append(String text) {
        this.m_textArea.append(text);
    }

    public void addText(String text) {
        this.m_textArea.append(NL);
        this.m_textArea.append(text);
        String newText = this.m_textArea.getText();
        this.m_textArea.setCaretPosition(newText.length());
    }

    public void setColumns(int cols) {
        this.m_textArea.setColumns(cols);
    }

    public int getColumns() {
        return this.m_textArea.getColumns();
    }

    public void setRows(int rows) {
        this.m_textArea.setRows(rows);
    }

    public int getRows() {
        return this.m_textArea.getRows();
    }

    public void setCaretPosition(int pos) {
        this.m_textArea.setCaretPosition(pos);
    }

    public int getCaretPosition() {
        return this.m_textArea.getCaretPosition();
    }

    public void setEditable(boolean edit) {
        this.m_textArea.setEditable(edit);
    }

    public boolean isEditable() {
        return this.m_textArea.isEditable();
    }

    public void setLineWrap(boolean wrap) {
        this.m_textArea.setLineWrap(wrap);
    }

    public void setWrapStyleWord(boolean word) {
        this.m_textArea.setWrapStyleWord(word);
    }

    public void setOpaque(boolean isOpaque) {
        if (this.m_textArea == null) {
            super.setOpaque(isOpaque);
        } else {
            this.m_textArea.setOpaque(isOpaque);
        }
    }

    public void setMargin(Insets m) {
        if (this.m_textArea != null) {
            this.m_textArea.setMargin(m);
        }
    }

    public void addFocusListener(FocusListener l) {
        if (this.m_textArea == null) {
            super.addFocusListener(l);
        } else {
            this.m_textArea.addFocusListener(l);
        }
    }

    public void addMouseListener(MouseListener l) {
        this.m_textArea.addMouseListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.m_textArea.addKeyListener(l);
    }

    public void addInputMethodListener(InputMethodListener l) {
        this.m_textArea.addInputMethodListener(l);
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.m_textArea.getInputMethodRequests();
    }

    public void setInputVerifier(InputVerifier l) {
        this.m_textArea.setInputVerifier(l);
    }

    public void requestFocus() {
        this.m_textArea.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.m_textArea.requestFocusInWindow();
    }

    public Component getFocusableComponent() {
        return this.m_textArea;
    }

    public void initPublish() {
        this.m_textArea.setEditable(false);
    }

    public void publish(Level level, String info, int step, int totalSteps) {
        this.addText(step + ": " + info);
    }

    public void focusGained(FocusEvent fe) {
        if (this.isEditable()) {
            this.m_textArea.setCaretPosition(0);
            this.m_textArea.repaint();
        }
    }

    public void focusLost(FocusEvent fe) {
        if (this.isEditable()) {
            this.m_textArea.setCaretPosition(0);
            this.m_textArea.repaint();
        }
    }
}

