/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputSubset;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;

public class CTextField
extends JTextField
implements CEditor,
KeyListener {
    private boolean m_mandatory = false;
    Character.Subset unicodeblock_subset = Character.UnicodeBlock.BASIC_LATIN;

    public CTextField() {
        this.init();
    }

    public CTextField(String text) {
        super(text);
        this.init();
    }

    public CTextField(int columns) {
        super(columns);
        this.init();
    }

    public CTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public CTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private void init() {
        this.setFont(CompierePLAF.getFont_Field());
        this.setForeground(CompierePLAF.getTextColor_Normal());
        this.setBackground(false);
        Dimension size = this.getPreferredSize();
        if (size != null) {
            size = new Dimension(20, 20);
        }
        if (size.width < 20) {
            size.width = 20;
        }
        if (size.height < 20) {
            size.height = 20;
        }
        this.setMinimumSize(size);
        final CTextField textComponent = this;
        textComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                if (CTextField.this.isEditable()) {
                    textComponent.selectAll();
                }
                textComponent.repaint();
            }

            public void focusLost(FocusEvent fe) {
                textComponent.setCaretPosition(0);
                textComponent.repaint();
            }
        });
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEditable() != rw) {
            super.setEditable(rw);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return super.isEditable();
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public String getDisplay() {
        return this.getText();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setInputMode(Character.UnicodeBlock subset) {
        Character.Subset[] subsets = new Character.Subset[]{subset};
        this.getInputContext().setCompositionEnabled(true);
        this.getInputContext().setCharacterSubsets(subsets);
    }

    public void setInputMode(InputSubset subset) {
        Character.Subset[] subsets = new Character.Subset[]{subset};
        this.getInputContext().setCompositionEnabled(true);
        this.getInputContext().setCharacterSubsets(subsets);
    }

    public void setAsciiMode() {
        this.setInputMode(Character.UnicodeBlock.BASIC_LATIN);
    }

    public void setLatinDigit() {
        this.setInputMode(InputSubset.LATIN_DIGITS);
    }

    public void setKatakanaMode() {
        this.setInputMode(Character.UnicodeBlock.KATAKANA);
    }

    public void setHalfWidthKatakanaMode() {
        this.setInputMode(InputSubset.HALFWIDTH_KATAKANA);
    }

    public void setHanjaMode() {
        this.setInputMode(InputSubset.HANJA);
    }

    public void setKanjiMode() {
        this.setInputMode(InputSubset.KANJI);
    }

    public void setSimplefiedHanziMode() {
        this.setInputMode(InputSubset.SIMPLIFIED_HANZI);
    }

    public void setTraditionalHanziMode() {
        this.setInputMode(InputSubset.TRADITIONAL_HANZI);
    }
}

