/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextPane;

public final class IniDialog
extends JDialog
implements ActionListener {
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.translate.IniRes");
    private boolean m_accept = false;
    private static Logger log = Logger.getLogger(IniDialog.class.getName());
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel southPanel = new CPanel();
    private JButton bReject = CompierePLAF.getCancelButton();
    private JButton bAccept = CompierePLAF.getOKButton();
    private FlowLayout southLayout = new FlowLayout();
    private JLabel southLabel = new JLabel();
    private CTextPane licensePane = new CTextPane();

    public static final boolean accept() {
        IniDialog id = new IniDialog(null, null);
        if (id.isAccepted()) {
            log.info("License Accepted");
            return true;
        }
        System.exit(10);
        return false;
    }

    public static final boolean accept(String heading, String license) {
        IniDialog id = new IniDialog(heading, license);
        if (id.isAccepted()) {
            log.info("License Accepted");
            return true;
        }
        return false;
    }

    private IniDialog(String heading, String license) {
        try {
            if (heading == null) {
                heading = "Compiere";
            }
            this.jbInit(heading);
            if (license != null) {
                this.licensePane.setText(license);
            } else {
                String where = "org/compiere/license.html";
                URL url = null;
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl != null) {
                    url = cl.getResource(where);
                }
                if (url == null) {
                    log.warning("No license in resource ");
                    url = new URL("http://www.compiere.org/license.htm");
                }
                if (url == null) {
                    this.cmd_reject();
                    this.dispose();
                    return;
                }
                this.licensePane.setPage(url);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
            this.cmd_reject();
            this.dispose();
            return;
        }
        CompierePLAF.showCenterScreen(this);
    }

    private void jbInit(String heading) throws Exception {
        this.setTitle(heading + " - " + s_res.getString("Compiere_License"));
        this.southLabel.setText(s_res.getString("Do_you_accept"));
        this.bReject.setText(s_res.getString("No"));
        this.bAccept.setText(s_res.getString("Yes_I_Understand"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.mainPanel.setLayout(this.mainLayout);
        this.bReject.setForeground(Color.red);
        this.bReject.addActionListener(this);
        this.bAccept.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.licensePane.setEditable(false);
        this.licensePane.setContentType("text/html");
        this.licensePane.setPreferredSize(new Dimension(700, 400));
        this.southPanel.add((Component)this.southLabel, null);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.licensePane, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bReject, null);
        this.southPanel.add((Component)this.bAccept, null);
    }

    public final void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAccept) {
            this.m_accept = true;
        }
        this.dispose();
    }

    public final void dispose() {
        super.dispose();
        if (!this.m_accept) {
            this.cmd_reject();
        }
    }

    public final boolean isAccepted() {
        return this.m_accept;
    }

    public final void cmd_reject() {
        String info = "License rejected or expired";
        try {
            info = s_res.getString("License_rejected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.severe(info);
        this.m_accept = false;
    }
}

