/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.translate.AmtInWords;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Msg {
    private static final int MAP_SIZE = 750;
    private static final String SEPARATOR = Env.NL + Env.NL;
    private static Msg s_msg = null;
    private static CLogger s_log = CLogger.getCLogger(Msg.class);
    private CCache<String, CCache<String, String>> m_languages = new CCache("msg_lang", 2, 0);

    private static Msg get() {
        if (s_msg == null) {
            s_msg = new Msg();
        }
        return s_msg;
    }

    private Msg() {
    }

    private CCache<String, String> getMsgMap(String ad_language) {
        CCache<String, String> retValue;
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if ((retValue = this.m_languages.get(AD_Language)) != null && retValue.size() > 0) {
            return retValue;
        }
        retValue = this.initMsg(AD_Language);
        if (retValue != null) {
            this.m_languages.put(AD_Language, retValue);
            return retValue;
        }
        return retValue;
    }

    private CCache<String, String> initMsg(String AD_Language) {
        CCache<String, String> msg = new CCache<String, String>("AD_Message", 750, 0);
        if (!DB.isConnected()) {
            s_log.log(Level.SEVERE, "No DB Connection");
            return null;
        }
        try {
            CPreparedStatement pstmt = null;
            if (AD_Language == null || AD_Language.length() == 0 || Env.isBaseLanguage(AD_Language, "AD_Language")) {
                pstmt = DB.prepareStatement("SELECT Value, MsgText, MsgTip FROM AD_Message", null);
            } else {
                pstmt = DB.prepareStatement("SELECT m.Value, t.MsgText, t.MsgTip FROM AD_Message_Trl t, AD_Message m WHERE m.AD_Message_ID=t.AD_Message_ID AND t.AD_Language=?", null);
                pstmt.setString(1, AD_Language);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String AD_Message = rs.getString(1);
                StringBuffer MsgText = new StringBuffer();
                MsgText.append(rs.getString(2));
                String MsgTip = rs.getString(3);
                if (MsgTip != null) {
                    MsgText.append(" ").append(SEPARATOR).append(MsgTip);
                }
                msg.put(AD_Message, MsgText.toString());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "initMsg", e);
            return null;
        }
        if (msg.size() < 100) {
            s_log.log(Level.SEVERE, "Too few (" + msg.size() + ") Records found for " + AD_Language);
            return null;
        }
        s_log.info("Records=" + msg.size() + " - " + AD_Language);
        return msg;
    }

    public void reset() {
        if (this.m_languages == null) {
            return;
        }
        for (CCache<String, String> hm : this.m_languages.values()) {
            hm.clear();
        }
        this.m_languages.clear();
    }

    public String[] getLanguages() {
        if (this.m_languages == null) {
            return null;
        }
        String[] retValue = new String[this.m_languages.size()];
        this.m_languages.keySet().toArray(retValue);
        return retValue;
    }

    public boolean isLoaded(String language) {
        if (this.m_languages == null) {
            return false;
        }
        return this.m_languages.containsKey(language);
    }

    private String lookup(String AD_Language, String text) {
        if (text == null) {
            return null;
        }
        if (AD_Language == null || AD_Language.length() == 0) {
            return text;
        }
        if (text.equals("/") || text.equals("\\")) {
            return File.separator;
        }
        if (text.equals(";") || text.equals(":")) {
            return File.pathSeparator;
        }
        if (text.equals("COMPIERE_HOME")) {
            return Compiere.getCompiereHome();
        }
        if (text.equals("bat") || text.equals("sh")) {
            if (System.getProperty("os.name").startsWith("Win")) {
                return "bat";
            }
            return "sh";
        }
        if (text.equalsIgnoreCase("CopyRight")) {
            return "\u00a9 1999-2007 Compiere \u00ae";
        }
        CCache<String, String> langMap = this.getMsgMap(AD_Language);
        if (langMap == null) {
            return null;
        }
        return langMap.get(text);
    }

    public static String getMsg(String ad_language, String AD_Message) {
        String retStr;
        if (AD_Message == null || AD_Message.length() == 0) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if (DB.isMSSQLServer() && AD_Message.equals("Date")) {
            AD_Message = "DATETIME";
        }
        if ((retStr = Msg.get().lookup(AD_Language, AD_Message)) == null || retStr.length() == 0) {
            s_log.warning("NOT found: " + AD_Message);
            return AD_Message;
        }
        if (DB.isMSSQLServer()) {
            while (retStr.indexOf(",NUMERIC,") > -1) {
                retStr = retStr.replaceAll(",NUMERIC,", ",number,");
            }
        }
        return retStr;
    }

    public static String getMsg(Ctx ctx, String AD_Message) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message);
    }

    public static String getMsg(Ctx ctx, String AD_Message, Object parameter) {
        StringBuffer msg = new StringBuffer(Msg.getMsg(Env.getAD_Language(ctx), AD_Message));
        if (parameter != null) {
            if (parameter instanceof Array) {
                Object[] pars = (Object[])parameter;
                for (int i = 0; i < pars.length; ++i) {
                    String stringValue;
                    if (pars[i] == null || (stringValue = pars[i].toString()).length() != 0) continue;
                    msg.append(Env.NL).append(stringValue);
                }
            } else {
                String stringValue = parameter.toString();
                if (stringValue.length() != 0) {
                    if (stringValue.length() > 20) {
                        msg.append(Env.NL);
                    } else {
                        msg.append(" ");
                    }
                    msg.append(stringValue);
                }
            }
        }
        return msg.toString();
    }

    public static String getMsg(Language language, String AD_Message) {
        return Msg.getMsg(language.getAD_Language(), AD_Message);
    }

    public static String getMsg(String ad_language, String AD_Message, boolean getText) {
        String retStr = Msg.getMsg(ad_language, AD_Message);
        int pos = retStr.indexOf(SEPARATOR);
        if (pos == -1) {
            if (getText) {
                return retStr;
            }
            return "";
        }
        if (getText) {
            retStr = retStr.substring(0, pos);
        } else {
            int start = pos + SEPARATOR.length();
            retStr = retStr.substring(start);
        }
        return retStr;
    }

    public static String getMsg(Ctx ctx, String AD_Message, boolean getText) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, getText);
    }

    public static String getMsg(Language language, String AD_Message, boolean getText) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, getText);
    }

    public static String getMsg(Ctx ctx, String AD_Message, Object[] args) {
        return Msg.getMsg(Env.getAD_Language(ctx), AD_Message, args);
    }

    public static String getMsg(Language language, String AD_Message, Object[] args) {
        return Msg.getMsg(language.getAD_Language(), AD_Message, args);
    }

    public static String getMsg(String ad_language, String AD_Message, Object[] args) {
        String msg;
        String retStr = msg = Msg.getMsg(ad_language, AD_Message);
        try {
            if (DB.isMSSQLServer()) {
                msg = msg.replaceAll("NUMERIC", "NUMBER");
            }
            retStr = MessageFormat.format(msg, args);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, msg, e);
        }
        return retStr;
    }

    public static String getAmtInWords(Language language, String amount) {
        if (amount == null || language == null) {
            return amount;
        }
        String className = "org.compiere.translate.AmtInWords_";
        try {
            className = className + language.getLanguageCode().toUpperCase();
            Class<?> clazz = Class.forName(className);
            AmtInWords aiw = (AmtInWords)clazz.newInstance();
            return aiw.getAmtInWords(amount);
        }
        catch (ClassNotFoundException e) {
            s_log.log(Level.FINER, "Class not found: " + className);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, className, e);
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        for (int i = 0; i < amount.length(); ++i) {
            if (pos == i) {
                String cents = amount.substring(i + 1);
                sb.append(' ').append(cents).append("/100");
                break;
            }
            char c = amount.charAt(i);
            if (c == ',' || c == '.') continue;
            if (sb.length() > 0) {
                sb.append("*");
            }
            sb.append(Msg.getMsg(language, String.valueOf(c)));
        }
        return sb.toString();
    }

    public static String getElement(String ad_language, String ColumnName, boolean isSOTrx) {
        if (ColumnName == null || ColumnName.equals("")) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        String retStr = "";
        try {
            CPreparedStatement pstmt = null;
            try {
                if (AD_Language == null || AD_Language.length() == 0 || Env.isBaseLanguage(AD_Language, "AD_Element")) {
                    pstmt = DB.prepareStatement("SELECT Name, PO_Name FROM AD_Element WHERE UPPER(ColumnName)=?", null);
                } else {
                    pstmt = DB.prepareStatement("SELECT t.Name, t.PO_Name FROM AD_Element_Trl t, AD_Element e WHERE t.AD_Element_ID=e.AD_Element_ID AND UPPER(e.ColumnName)=? AND t.AD_Language=?", null);
                    pstmt.setString(2, AD_Language);
                }
            }
            catch (Exception e) {
                return ColumnName;
            }
            pstmt.setString(1, ColumnName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String temp;
                retStr = rs.getString(1);
                if (!isSOTrx && (temp = rs.getString(2)) != null && temp.length() > 0) {
                    retStr = temp;
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "getElement", e);
            return "";
        }
        if (retStr != null) {
            return retStr.trim();
        }
        return retStr;
    }

    public static String getElement(Ctx ctx, String ColumnName) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, true);
    }

    public static String getElement(Ctx ctx, String ColumnName, boolean isSOTrx) {
        return Msg.getElement(Env.getAD_Language(ctx), ColumnName, isSOTrx);
    }

    public static String translate(String ad_language, boolean isSOTrx, String text) {
        String retStr;
        if (text == null || text.equals("")) {
            return "";
        }
        String AD_Language = ad_language;
        if (AD_Language == null || AD_Language.length() == 0) {
            AD_Language = Language.getBaseAD_Language();
        }
        if (!(retStr = Msg.getElement(AD_Language, text, isSOTrx)).equals("")) {
            return retStr.trim();
        }
        if (DB.isMSSQLServer() && text.equals("Date")) {
            text = "DATETIME";
        }
        if ((retStr = Msg.get().lookup(AD_Language, text)) != null) {
            return retStr;
        }
        if (!text.startsWith("*")) {
            s_log.warning("NOT found: " + text);
        }
        return text;
    }

    public static String translate(String ad_language, String text) {
        return Msg.translate(ad_language, true, text);
    }

    public static String translate(Ctx ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String s = (String)ctx.get((Object)text);
        if (s != null && s.length() > 0) {
            return s;
        }
        return Msg.translate(Env.getAD_Language(ctx), ctx.isSOTrx(), text);
    }

    public static String translate(Language language, String text) {
        return Msg.translate(language.getAD_Language(), false, text);
    }

    public static String parseTranslation(Ctx ctx, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String inStr = text;
        StringBuffer outStr = new StringBuffer();
        int i = inStr.indexOf("@");
        while (i != -1) {
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf("@");
            if (j < 0) {
                inStr = "@" + inStr;
                break;
            }
            String token = inStr.substring(0, j);
            outStr.append(Msg.translate(ctx, token));
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf("@");
        }
        outStr.append(inStr);
        return outStr.toString();
    }
}

