/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.compiere.swing.CComboBox;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class CPrinter
extends CComboBox
implements ActionListener {
    private static PrintService[] s_services = PrintServiceLookup.lookupPrintServices(null, null);
    private static CLogger log = CLogger.getCLogger(CPrinter.class);

    public static String[] getPrinterNames() {
        String[] retValue = new String[s_services.length];
        for (int i = 0; i < s_services.length; ++i) {
            retValue[i] = s_services[i].getName();
        }
        return retValue;
    }

    public static PrinterJob getPrinterJob() {
        return CPrinter.getPrinterJob(Env.getCtx().getPrinterName());
    }

    public static PrinterJob getPrinterJob(String printerName) {
        PrinterJob pj = null;
        PrintService ps = null;
        try {
            String serviceName;
            pj = PrinterJob.getPrinterJob();
            if (printerName == null || printerName.length() == 0) {
                printerName = Env.getCtx().getPrinterName();
            }
            if (printerName != null && printerName.length() != 0) {
                for (int i = 0; i < s_services.length; ++i) {
                    serviceName = s_services[i].getName();
                    if (!printerName.equals(serviceName)) continue;
                    ps = s_services[i];
                    break;
                }
            }
            try {
                if (ps != null) {
                    pj.setPrintService(ps);
                }
            }
            catch (Exception e) {
                log.warning("Could not set Print Service: " + e.toString());
            }
            PrintService psUsed = pj.getPrintService();
            if (psUsed == null) {
                log.warning("Print Service not Found");
            } else {
                serviceName = psUsed.getName();
                if (printerName != null && !printerName.equals(serviceName)) {
                    log.warning("Not found: " + printerName + " - Used: " + serviceName);
                }
            }
        }
        catch (Exception e) {
            log.warning("Could not create for " + printerName + ": " + e.toString());
        }
        return pj;
    }

    public CPrinter() {
        super((Object[])CPrinter.getPrinterNames());
        this.setValue(Env.getCtx().getPrinterName());
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public PrintService getPrintService() {
        String currentService = (String)this.getSelectedItem();
        for (int i = 0; i < s_services.length; ++i) {
            if (!s_services[i].getName().equals(currentService)) continue;
            return s_services[i];
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }
}

