/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.DocAttributeSet;
import org.compiere.framework.Query;
import org.compiere.model.MPrintColor;
import org.compiere.print.CPaper;
import org.compiere.print.DataEngine;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintPaper;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.BarcodeElement;
import org.compiere.print.layout.BoxElement;
import org.compiere.print.layout.HTMLElement;
import org.compiere.print.layout.ImageElement;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.LocationElement;
import org.compiere.print.layout.Page;
import org.compiere.print.layout.ParameterElement;
import org.compiere.print.layout.PrintElement;
import org.compiere.print.layout.QRCodeElement;
import org.compiere.print.layout.StringElement;
import org.compiere.print.layout.TableElement;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatElement
extends PrintElement
implements Doc {
    private static CLogger log = CLogger.getCLogger(LayoutEngine.class);
    private boolean m_hasLayout = false;
    private MPrintFormat m_format;
    private Ctx m_printCtx;
    private PrintData m_data;
    private Query m_query;
    private MPrintColor m_printColor;
    private MPrintFont m_printFont;
    private int m_columnCount = -1;
    private CPaper m_paper;
    private int m_headerHeight = 18;
    private int m_footerHeight = 18;
    private int m_pageNo = 0;
    private Page m_currPage;
    private ArrayList<Page> m_pages = new ArrayList();
    private Rectangle m_header = new Rectangle();
    private Rectangle m_content = new Rectangle();
    private Rectangle m_footer = new Rectangle();
    private int m_tempNLPositon = 0;
    public static final int AREA_HEADER = 0;
    public static final int AREA_CONTENT = 1;
    public static final int AREA_FOOTER = 2;
    private int m_area = 1;
    private Point2D.Double[] m_position = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
    private float[] m_maxHeightSinceNewLine = new float[]{0.0f, 0.0f, 0.0f};
    private TableElement m_tableElement = null;
    private float[] m_lastHeight = new float[]{0.0f, 0.0f, 0.0f};
    private float[] m_lastWidth = new float[]{0.0f, 0.0f, 0.0f};
    public static boolean s_FASTDRAW = true;
    public static Image IMAGE_TRUE = null;
    public static Image IMAGE_FALSE = null;
    public static Dimension IMAGE_SIZE = new Dimension(10, 10);

    public FormatElement(MPrintFormat format, PrintData data, Query query) {
        log.info((Object)((Object)format) + " - " + data + " - " + query);
        this.setPrintFormat(format, false);
        this.setPrintData(data, query, false);
        this.layout();
    }

    private void layout() {
        this.m_pageNo = 0;
        this.m_pages.clear();
        this.m_tableElement = null;
        this.newPage(true, false);
        if (this.m_format.isForm()) {
            this.layoutForm();
        } else {
            PrintElement element = this.layoutParameter();
            if (element != null) {
                this.m_currPage.addElement(element);
                element.setLocation(this.m_position[1]);
                this.m_position[1].y += (double)(element.getHeight() + 5.0f);
            }
            if (this.m_data != null) {
                element = this.layoutTable(this.m_format, this.m_data, 0);
                element.setLocation(this.m_content.getLocation());
                for (int p = 1; p <= element.getPageCount(); ++p) {
                    if (p != 1) {
                        this.newPage(true, false);
                    }
                    this.m_currPage.addElement(element);
                }
            }
        }
        String pageInfo = String.valueOf(this.m_pages.size()) + this.getPageInfo(this.m_pages.size());
        this.m_printCtx.setContext("*PageCount", pageInfo);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.m_printCtx.setContext("*CurrentDate", DisplayType.getDateFormat((int)15, (Language)this.m_format.getLanguage()).format(now));
        this.m_printCtx.setContext("*CurrentDateTime", DisplayType.getDateFormat((int)16, (Language)this.m_format.getLanguage()).format(now));
        int pages = this.m_pages.size();
        for (int i = 0; i < pages; ++i) {
            Page page = this.m_pages.get(i);
            int pageNo = page.getPageNo();
            pageInfo = String.valueOf(pageNo) + this.getPageInfo(pageNo);
            page.setPageInfo(pageInfo);
            page.setPageCount(pages);
        }
        this.m_hasLayout = true;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Ctx ctx, boolean isView) {
        this.setLocation(pageStart);
        Rectangle r = this.getBounds();
        Page page = this.getPage(1);
        if (page != null) {
            page.paint(g2D, r, false, false);
        }
    }

    public Ctx getCtx() {
        return this.m_printCtx;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    protected void setArea(int area) {
        if (this.m_area == area) {
            return;
        }
        if (area < 0 || area > 2) {
            throw new ArrayIndexOutOfBoundsException(area);
        }
        this.m_area = area;
    }

    public int getArea() {
        return this.m_area;
    }

    public Rectangle getAreaBounds() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return part;
    }

    public int getPageNo() {
        return this.m_pageNo;
    }

    public Page getPage(int pageNo) {
        if (pageNo <= 0 || pageNo > this.m_pages.size()) {
            log.log(Level.SEVERE, "No page #" + pageNo);
            return null;
        }
        Page retValue = this.m_pages.get(pageNo - 1);
        return retValue;
    }

    public ArrayList<Page> getPages() {
        return this.m_pages;
    }

    protected void setPage(int pageNo) {
        Page retValue;
        if (pageNo <= 0 || pageNo > this.m_pages.size()) {
            log.log(Level.SEVERE, "No page #" + pageNo);
            return;
        }
        this.m_currPage = retValue = this.m_pages.get(pageNo - 1);
    }

    public String getPageInfo(int pageNo) {
        if (this.m_tableElement == null || this.m_tableElement.getPageXCount() == 1) {
            return "";
        }
        int pi = this.m_tableElement.getPageIndex(pageNo);
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.m_tableElement.getPageYIndex(pi) + 1).append(",").append(this.m_tableElement.getPageXIndex(pi) + 1).append(")");
        return sb.toString();
    }

    public String getPageInfoMax() {
        if (this.m_tableElement == null || this.m_tableElement.getPageXCount() == 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.m_tableElement.getPageYCount()).append(",").append(this.m_tableElement.getPageXCount()).append(")");
        return sb.toString();
    }

    public MPrintFormat getFormat() {
        return this.m_format;
    }

    protected void newLine() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        int xPos = part.x;
        if (this.m_tempNLPositon != 0) {
            xPos = this.m_tempNLPositon;
        }
        if (this.isYspaceFor(this.m_maxHeightSinceNewLine[this.m_area])) {
            this.m_position[this.m_area].setLocation(xPos, this.m_position[this.m_area].y + (double)this.m_maxHeightSinceNewLine[this.m_area]);
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        } else if (this.m_area == 1) {
            log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            this.newPage(true, false);
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        } else {
            this.m_position[this.m_area].setLocation(part.x, this.m_position[this.m_area].y + (double)this.m_maxHeightSinceNewLine[this.m_area]);
            log.log(Level.SEVERE, "Outside of Area(" + this.m_area + "): " + this.m_position[this.m_area]);
        }
        this.m_maxHeightSinceNewLine[this.m_area] = 0.0f;
    }

    protected int newPage(boolean force, boolean preserveXPos) {
        if (!force && this.m_position[1].getX() == (double)this.m_content.x && this.m_position[1].getY() == (double)this.m_content.y) {
            log.fine("skipped");
            return this.m_pageNo;
        }
        ++this.m_pageNo;
        this.m_currPage = new Page(this.m_printCtx, this.m_pageNo);
        this.m_pages.add(this.m_currPage);
        this.m_position[0].setLocation(this.m_header.x, this.m_header.y);
        if (preserveXPos) {
            this.m_position[1].setLocation(this.m_position[1].x, this.m_content.y);
        } else {
            this.m_position[1].setLocation(this.m_content.x, this.m_content.y);
        }
        this.m_position[2].setLocation(this.m_footer.x, this.m_footer.y);
        this.m_maxHeightSinceNewLine = new float[]{0.0f, 0.0f, 0.0f};
        log.finer("Page=" + this.m_pageNo);
        return this.m_pageNo;
    }

    private void layoutForm() {
        this.m_columnCount = 0;
        if (this.m_data == null) {
            return;
        }
        for (int row = 0; row < this.m_data.getRowCount(); ++row) {
            log.info("Row=" + row);
            this.m_data.setRowIndex(row);
            boolean somethingPrinted = true;
            for (int i = 0; i < this.m_format.getItemCount(); ++i) {
                MPrintFormatItem item = this.m_format.getItem(i);
                if (!item.isPrinted() || !this.isPrinted(this.m_data, item.getPrintLogic())) continue;
                ++this.m_columnCount;
                if (row > 0 && (item.isHeader() || item.isFooter())) continue;
                if (item.isHeader()) {
                    this.setArea(0);
                } else if (item.isFooter()) {
                    this.setArea(2);
                } else {
                    this.setArea(1);
                }
                if (item.isSetNLPosition() && item.isRelativePosition()) {
                    this.m_tempNLPositon = 0;
                }
                if (item.isNextPage()) {
                    this.newPage(false, false);
                } else if (item.isNextLine() && somethingPrinted) {
                    this.newLine();
                    somethingPrinted = false;
                } else {
                    this.addX(this.m_lastWidth[this.m_area]);
                }
                if (item.isRelativePosition()) {
                    this.addX(item.getXSpace());
                    this.addY(item.getYSpace());
                } else {
                    this.setRelativePosition(item.getXPosition(), item.getYPosition());
                }
                if (item.isSetNLPosition() && !item.isRelativePosition()) {
                    this.m_tempNLPositon = (int)this.getPosition().getX();
                }
                String alignment = item.getFieldAlignmentType();
                int maxWidth = item.getMaxWidth();
                boolean lineAligned = false;
                if (item.isRelativePosition()) {
                    if (item.isLineAlignLeading()) {
                        alignment = "L";
                        maxWidth = this.getAreaBounds().width;
                        lineAligned = true;
                    } else if (item.isLineAlignCenter()) {
                        alignment = "C";
                        maxWidth = this.getAreaBounds().width;
                        lineAligned = true;
                    } else if (item.isLineAlignTrailing()) {
                        alignment = "T";
                        maxWidth = this.getAreaBounds().width;
                        lineAligned = true;
                    }
                }
                PrintElement element = null;
                if (item.isTypePrintFormat()) {
                    element = this.includeFormat(item, this.m_data);
                } else if (item.isQRCode()) {
                    element = this.createQRCodeElement(item);
                    element.layout(maxWidth, item.getMaxHeight(), false, alignment);
                } else if (item.isBarcode()) {
                    element = this.createBarcodeElement(item);
                    element.layout(maxWidth, item.getMaxHeight(), false, alignment);
                } else if (item.isTypeImage()) {
                    element = item.isImageField() ? this.createImageElement(item) : (item.isImageIsAttached() ? ImageElement.get(item.get_ID()) : ImageElement.get(item.getImageURL()));
                    element.layout(maxWidth, item.getMaxHeight(), false, alignment);
                } else if (item.isTypeField()) {
                    if (maxWidth == 0 && item.isFieldAlignBlock()) {
                        maxWidth = this.getAreaBounds().width;
                    }
                    element = this.createFieldElement(item, maxWidth, alignment, this.m_format.isForm());
                } else if (item.isTypeBox()) {
                    if (this.m_format.isForm()) {
                        element = this.createBoxElement(item);
                    }
                } else {
                    if (maxWidth == 0 && item.isFieldAlignBlock()) {
                        maxWidth = this.getAreaBounds().width;
                    }
                    element = this.createStringElement(item.getPrintName(this.m_format.getLanguage()), item.getAD_PrintColor_ID(), item.getAD_PrintFont_ID(), maxWidth, item.getMaxHeight(), item.isHeightOneLine(), alignment, true);
                }
                if (element != null) {
                    somethingPrinted = true;
                    if (!lineAligned) {
                        this.m_lastWidth[this.m_area] = element.getWidth();
                    }
                    this.m_lastHeight[this.m_area] = element.getHeight();
                } else {
                    somethingPrinted = false;
                    this.m_lastWidth[this.m_area] = 0.0f;
                    this.m_lastHeight[this.m_area] = 0.0f;
                }
                if (item.isRelativePosition() && !lineAligned) {
                    if (!this.isXspaceFor(this.m_lastWidth[this.m_area])) {
                        log.finest("Not enough X space for " + this.m_lastWidth[this.m_area] + " - remaining " + this.getXspace() + " - Area=" + this.m_area);
                        this.newLine();
                    }
                    if (this.m_area == 1 && !this.isYspaceFor(this.m_lastHeight[this.m_area])) {
                        log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
                        this.newPage(true, true);
                    }
                }
                if (element != null) {
                    element.setLocation(this.m_position[this.m_area]);
                }
                if (this.m_area == 1) {
                    this.m_currPage.addElement(element);
                }
                if (!(this.m_lastHeight[this.m_area] > this.m_maxHeightSinceNewLine[this.m_area])) continue;
                this.m_maxHeightSinceNewLine[this.m_area] = this.m_lastHeight[this.m_area];
            }
        }
    }

    private PrintElement createBoxElement(MPrintFormatItem item) {
        MPrintColor c;
        Color color = this.getColor();
        if (item.getAD_PrintColor_ID() != 0 && this.m_printColor.get_ID() != item.getAD_PrintColor_ID() && (c = MPrintColor.get((Ctx)this.getCtx(), (int)item.getAD_PrintColor_ID())).getColor() != null) {
            color = c.getColor();
        }
        return new BoxElement(item, color);
    }

    private PrintElement createImageElement(MPrintFormatItem item) {
        Object obj = this.m_data.getNode(new Integer(item.getAD_Column_ID()));
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + obj.getClass());
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String url = data.getValueDisplay(this.m_format.getLanguage(), this.m_data.getCurrencyPrecision());
        if (url == null || url.length() == 0) {
            if (item.isSuppressNull()) {
                return null;
            }
            return null;
        }
        ImageElement element = ImageElement.get(url);
        return element;
    }

    private PrintElement createQRCodeElement(MPrintFormatItem item) {
        Object obj = this.m_data.getNode(new Integer(item.getAD_Column_ID()));
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + obj.getClass());
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String stringContent = data.getValueDisplay(this.m_format.getLanguage(), this.m_data.getCurrencyPrecision());
        if ((stringContent == null || stringContent.length() == 0) && item.isSuppressNull()) {
            return null;
        }
        QRCodeElement element = new QRCodeElement(stringContent, item);
        if (element.isValid()) {
            return element;
        }
        return null;
    }

    private PrintElement createBarcodeElement(MPrintFormatItem item) {
        Object obj = this.m_data.getNode(new Integer(item.getAD_Column_ID()));
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + obj.getClass());
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String stringContent = data.getValueDisplay(this.m_format.getLanguage(), this.m_data.getCurrencyPrecision());
        if ((stringContent == null || stringContent.length() == 0) && item.isSuppressNull()) {
            return null;
        }
        BarcodeElement element = new BarcodeElement(stringContent, item);
        if (element.isValid()) {
            return element;
        }
        return null;
    }

    private PrintElement includeFormat(MPrintFormatItem item, PrintData data) {
        this.newLine();
        PrintElement element = null;
        MPrintFormat format = MPrintFormat.get(this.getCtx(), item.getAD_PrintFormatChild_ID(), false);
        format.setLanguage(this.m_format.getLanguage());
        if (this.m_format.isTranslationView()) {
            format.setTranslationLanguage(this.m_format.getLanguage());
        }
        int AD_Column_ID = item.getAD_Column_ID();
        log.info((Object)((Object)format) + " - Item=" + item.getName() + " (" + AD_Column_ID + ")");
        Object obj = data.getNode(new Integer(AD_Column_ID));
        if (obj == null) {
            data.dumpHeader();
            data.dumpCurrentRow();
            log.log(Level.SEVERE, "No Node - AD_Column_ID=" + AD_Column_ID + " - " + (Object)((Object)item) + " - " + data);
            return null;
        }
        PrintDataElement dataElement = (PrintDataElement)obj;
        String recordString = dataElement.getValueKey();
        if (recordString == null || recordString.length() == 0) {
            data.dumpHeader();
            data.dumpCurrentRow();
            log.log(Level.SEVERE, "No Record Key - " + dataElement + " - AD_Column_ID=" + AD_Column_ID + " - " + (Object)((Object)item));
            return null;
        }
        int Record_ID = 0;
        try {
            Record_ID = Integer.parseInt(recordString);
        }
        catch (Exception e) {
            data.dumpCurrentRow();
            log.log(Level.SEVERE, "Invalid Record Key - " + recordString + " (" + e.getMessage() + ") - AD_Column_ID=" + AD_Column_ID + " - " + (Object)((Object)item));
            return null;
        }
        Query query = new Query(format.getAD_Table_ID());
        query.addRestriction(item.getColumnName(), "=", (Object)new Integer(Record_ID));
        format.setTranslationViewQuery(query);
        log.fine(query.toString());
        DataEngine de = new DataEngine(format.getLanguage());
        PrintData includedData = de.getPrintData(data.getCtx(), format, query);
        log.fine(includedData.toString());
        if (includedData == null) {
            return null;
        }
        element = this.layoutTable(format, includedData, item.getXSpace());
        if (element.getPageCount() > 1) {
            Point2D.Double loc = this.m_position[this.m_area];
            element.setLocation(loc);
            for (int p = 1; p < element.getPageCount(); ++p) {
                this.m_currPage.addElement(element);
                this.newPage(true, false);
            }
            this.m_position[this.m_area] = loc;
            ((TableElement)element).setHeightToLastPage();
        }
        this.m_lastWidth[this.m_area] = element.getWidth();
        this.m_lastHeight[this.m_area] = element.getHeight();
        if (!this.isXspaceFor(this.m_lastWidth[this.m_area])) {
            log.finest("Not enough X space for " + this.m_lastWidth[this.m_area] + " - remaining " + this.getXspace() + " - Area=" + this.m_area);
            this.newLine();
        }
        if (this.m_area == 1 && !this.isYspaceFor(this.m_lastHeight[this.m_area])) {
            log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            this.newPage(true, false);
        }
        return element;
    }

    private PrintElement createStringElement(String content, int AD_PrintColor_ID, int AD_PrintFont_ID, int maxWidth, int maxHeight, boolean isHeightOneLine, String FieldAlignmentType, boolean isTranslated) {
        MPrintFont f;
        MPrintColor c;
        if (content == null || content.length() == 0) {
            return null;
        }
        Color color = this.getColor();
        if (AD_PrintColor_ID != 0 && this.m_printColor.get_ID() != AD_PrintColor_ID && (c = MPrintColor.get((Ctx)this.getCtx(), (int)AD_PrintColor_ID)).getColor() != null) {
            color = c.getColor();
        }
        Font font = this.m_printFont.getFont();
        if (AD_PrintFont_ID != 0 && this.m_printFont.get_ID() != AD_PrintFont_ID && (f = MPrintFont.get(AD_PrintFont_ID)).getFont() != null) {
            font = f.getFont();
        }
        StringElement e = new StringElement(content, font, color, null, isTranslated);
        e.layout(maxWidth, maxHeight, isHeightOneLine, FieldAlignmentType);
        return e;
    }

    private PrintElement createFieldElement(MPrintFormatItem item, int maxWidth, String FieldAlignmentType, boolean isForm) {
        MPrintFont f;
        MPrintColor c;
        Object obj = this.m_data.getNode(new Integer(item.getAD_Column_ID()));
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + obj.getClass());
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String stringContent = data.getValueDisplay(this.m_format.getLanguage(), this.m_data.getCurrencyPrecision());
        if ((stringContent == null || stringContent.length() == 0) && item.isSuppressNull()) {
            return null;
        }
        Object content = stringContent;
        if (data.getValue() instanceof Boolean) {
            content = data.getValue();
        }
        if (item.getColumnName().equals("AmtInWords")) {
            log.fine("AmtInWords: " + stringContent);
            stringContent = Msg.getAmtInWords((Language)this.m_format.getLanguage(), (String)stringContent);
            content = stringContent;
        }
        String label = item.getPrintName(this.m_format.getLanguage());
        String labelSuffix = item.getPrintNameSuffix(this.m_format.getLanguage());
        KeyNamePair ID = null;
        if (data.isID()) {
            Object value = data.getValue();
            if (value instanceof KeyNamePair) {
                ID = new KeyNamePair(((KeyNamePair)value).getKey(), item.getColumnName());
            } else if (value instanceof ValueNamePair) {
                ID = new ValueNamePair(((ValueNamePair)value).getValue(), item.getColumnName());
            }
        } else if ("D".equals(FieldAlignmentType)) {
            FieldAlignmentType = data.isNumeric() ? "T" : "L";
        }
        Color color = this.getColor();
        if ((ID == null || isForm) && item.getAD_PrintColor_ID() != 0 && this.m_printColor.get_ID() != item.getAD_PrintColor_ID() && (c = MPrintColor.get((Ctx)this.getCtx(), (int)item.getAD_PrintColor_ID())).getColor() != null) {
            color = c.getColor();
        }
        Font font = this.m_printFont.getFont();
        if (item.getAD_PrintFont_ID() != 0 && this.m_printFont.get_ID() != item.getAD_PrintFont_ID() && (f = MPrintFont.get(item.getAD_PrintFont_ID())).getFont() != null) {
            font = f.getFont();
        }
        PrintElement e = null;
        if (data.getDisplayType() == 21) {
            e = new LocationElement(this.m_printCtx, ID.getKey(), font, color);
            e.layout(maxWidth, item.getMaxHeight(), item.isHeightOneLine(), FieldAlignmentType);
        } else {
            e = HTMLElement.isHTML(stringContent) ? new HTMLElement(stringContent) : new StringElement(content, font, color, (NamePair)(isForm ? null : ID), label, labelSuffix);
            e.layout(maxWidth, item.getMaxHeight(), item.isHeightOneLine(), FieldAlignmentType);
        }
        return e;
    }

    private PrintElement layoutTable(MPrintFormat format, PrintData printData, int xOffset) {
        log.info(format.getName() + " - " + printData.getName());
        MPrintTableFormat tf = format.getTableFormat();
        HashMap<Point, Font> rowColFont = new HashMap<Point, Font>();
        MPrintFont printFont = MPrintFont.get(format.getAD_PrintFont_ID());
        rowColFont.put(new Point(-1, -1), printFont.getFont());
        tf.setStandard_Font(printFont.getFont());
        rowColFont.put(new Point(-2, -1), tf.getHeader_Font());
        HashMap<Point, Color> rowColColor = new HashMap<Point, Color>();
        MPrintColor printColor = MPrintColor.get((Ctx)this.getCtx(), (int)format.getAD_PrintColor_ID());
        rowColColor.put(new Point(-1, -1), printColor.getColor());
        rowColColor.put(new Point(-2, -1), tf.getHeaderFG_Color());
        HashMap<Point, Color> rowColBackground = new HashMap<Point, Color>();
        rowColBackground.put(new Point(-2, -1), tf.getHeaderBG_Color());
        boolean multiLineHeader = false;
        int pageNoStart = this.m_pageNo;
        int repeatedColumns = 1;
        Rectangle firstPage = new Rectangle(this.m_content);
        firstPage.x += xOffset;
        firstPage.width -= xOffset;
        int yOffset = (int)this.m_position[1].y - this.m_content.y;
        firstPage.y += yOffset;
        firstPage.height -= yOffset;
        Rectangle nextPages = new Rectangle(this.m_content);
        nextPages.x += xOffset;
        nextPages.width -= xOffset;
        int columnCount = 0;
        for (int c = 0; c < format.getItemCount(); ++c) {
            if (!format.getItem(c).isPrinted()) continue;
            ++columnCount;
        }
        ValueNamePair[] columnHeader = new ValueNamePair[columnCount];
        int[] columnMaxWidth = new int[columnCount];
        int[] columnMaxHeight = new int[columnCount];
        boolean[] fixedWidth = new boolean[columnCount];
        String[] columnJustification = new String[columnCount];
        HashMap<Integer, Integer> additionalLines = new HashMap<Integer, Integer>();
        int col = 0;
        for (int c = 0; c < format.getItemCount(); ++c) {
            MPrintFormatItem item = format.getItem(c);
            if (!item.isPrinted()) continue;
            if (item.isNextLine() && item.getBelowColumn() != 0) {
                additionalLines.put(new Integer(col), new Integer(item.getBelowColumn() - 1));
                if (!item.isSuppressNull()) {
                    item.setIsSuppressNull(true);
                    item.save();
                }
            }
            columnHeader[col] = new ValueNamePair(item.getColumnName(), item.getPrintName(format.getLanguage()));
            columnMaxWidth[col] = item.getMaxWidth();
            boolean bl = fixedWidth[col] = columnMaxWidth[col] != 0 && item.isFixedWidth();
            if (item.isSuppressNull()) {
                if (columnMaxWidth[col] == 0) {
                    columnMaxWidth[col] = -1;
                } else {
                    int n = col;
                    columnMaxWidth[n] = columnMaxWidth[n] * -1;
                }
            }
            columnMaxHeight[col] = item.getMaxHeight();
            if (item.isHeightOneLine()) {
                columnMaxHeight[col] = -1;
            }
            columnJustification[col] = item.getFieldAlignmentType();
            if (columnJustification[col] == null || columnJustification[col].equals("D")) {
                columnJustification[col] = "L";
            }
            if (item.getAD_PrintFont_ID() != 0 && item.getAD_PrintFont_ID() != format.getAD_PrintFont_ID()) {
                MPrintFont font = MPrintFont.get(item.getAD_PrintFont_ID());
                rowColFont.put(new Point(-1, col), font.getFont());
            }
            if (item.getAD_PrintColor_ID() != 0 && item.getAD_PrintColor_ID() != format.getAD_PrintColor_ID()) {
                MPrintColor color = MPrintColor.get((Ctx)this.getCtx(), (int)item.getAD_PrintColor_ID());
                rowColColor.put(new Point(-1, col), color.getColor());
            }
            ++col;
        }
        int rows = printData.getRowCount();
        Object[][] data = new Object[rows][columnCount];
        KeyNamePair[] pk = new KeyNamePair[rows];
        String pkColumnName = null;
        ArrayList<Integer> functionRows = new ArrayList<Integer>();
        ArrayList<Integer> pageBreak = new ArrayList<Integer>();
        for (int row = 0; row < rows; ++row) {
            printData.setRowIndex(row);
            if (printData.isFunctionRow()) {
                functionRows.add(new Integer(row));
                rowColFont.put(new Point(row, -1), tf.getFunct_Font());
                rowColColor.put(new Point(row, -1), tf.getFunctFG_Color());
                rowColBackground.put(new Point(row, -1), tf.getFunctBG_Color());
                if (printData.isPageBreak()) {
                    pageBreak.add(new Integer(row));
                    log.finer("PageBreak row=" + row);
                }
            } else {
                int levelNo = printData.getLineLevelNo();
                if (levelNo != 0) {
                    if (levelNo < 0) {
                        levelNo = -levelNo;
                    }
                    Font base = printFont.getFont();
                    if (levelNo == 1) {
                        rowColFont.put(new Point(row, -1), new Font(base.getName(), 2, base.getSize() - levelNo));
                    } else if (levelNo == 2) {
                        rowColFont.put(new Point(row, -1), new Font(base.getName(), 0, base.getSize() - levelNo));
                    }
                }
            }
            col = 0;
            for (int c = 0; c < format.getItemCount(); ++c) {
                PrintElement element;
                PrintDataElement pde;
                Object obj;
                MPrintFormatItem item = format.getItem(c);
                Object dataElement = null;
                if (!item.isPrinted() || item.getAD_Column_ID() <= 0) continue;
                if (item.isTypePrintFormat()) {
                    log.warning("Unsupported: PrintFormat in Table: " + (Object)((Object)item));
                } else if (item.isTypeImage()) {
                    if (item.isImageField()) {
                        obj = printData.getNode(new Integer(item.getAD_Column_ID()));
                        if (obj != null && obj instanceof PrintDataElement) {
                            pde = (PrintDataElement)obj;
                            data[row][col] = ImageElement.get((String)pde.getValue());
                        }
                    } else {
                        data[row][col] = item.isImageIsAttached() ? ImageElement.get(item.get_ID()) : ImageElement.get(item.getImageURL());
                    }
                } else if (item.isQRCode()) {
                    obj = printData.getNode(new Integer(item.getAD_Column_ID()));
                    if (obj != null && obj instanceof PrintDataElement && ((QRCodeElement)(element = new QRCodeElement((String)(pde = (PrintDataElement)obj).getValue(), item))).isValid()) {
                        data[row][col] = element;
                    }
                } else if (item.isBarcode()) {
                    obj = printData.getNode(new Integer(item.getAD_Column_ID()));
                    if (obj != null && obj instanceof PrintDataElement && ((BarcodeElement)(element = new BarcodeElement((String)(pde = (PrintDataElement)obj).getValue(), item))).isValid()) {
                        data[row][col] = element;
                    }
                } else {
                    obj = printData.getNode(new Integer(item.getAD_Column_ID()));
                    if (obj != null) {
                        if (obj instanceof PrintDataElement) {
                            pde = (PrintDataElement)obj;
                            dataElement = pde.isID() || pde.isYesNo() ? pde.getValue() : pde.getValueDisplay(format.getLanguage(), this.m_data.getCurrencyPrecision());
                        } else {
                            log.log(Level.SEVERE, "Element not PrintDataElement " + obj.getClass());
                        }
                    }
                    data[row][col] = dataElement;
                }
                ++col;
            }
            PrintDataElement pde = printData.getPKey();
            if (pde == null) continue;
            if (pde.getValue() instanceof KeyNamePair) {
                pk[row] = (KeyNamePair)pde.getValue();
            }
            if (pkColumnName != null) continue;
            pkColumnName = pde.getColumnName();
        }
        TableElement table2 = new TableElement(columnHeader, columnMaxWidth, columnMaxHeight, columnJustification, fixedWidth, functionRows, multiLineHeader, data, pk, pkColumnName, pageNoStart, firstPage, nextPages, repeatedColumns, additionalLines, rowColFont, rowColColor, rowColBackground, tf, pageBreak);
        table2.layout(0.0f, 0.0f, false, "L");
        if (this.m_tableElement == null) {
            this.m_tableElement = table2;
        }
        return table2;
    }

    private PrintElement layoutParameter() {
        if (this.m_query == null || !this.m_query.isActive()) {
            return null;
        }
        ParameterElement pe = new ParameterElement(this.m_query, this.m_printCtx, this.m_format.getTableFormat());
        pe.layout(0.0f, 0.0f, false, null);
        return pe;
    }

    protected void setRelativePosition(Point2D p) {
        if (p == null) {
            return;
        }
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        this.m_position[this.m_area].setLocation((double)part.x + p.getX(), (double)part.y + p.getY());
        log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
    }

    protected void setRelativePosition(float x, float y) {
        this.setRelativePosition(new Point2D.Float(x, y));
    }

    public Point2D getPosition() {
        return this.m_position[this.m_area];
    }

    protected void setX(float x) {
        this.m_position[this.m_area].x = x;
        log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
    }

    protected void addX(float xOffset) {
        if (xOffset == 0.0f) {
            return;
        }
        this.m_position[this.m_area].x += (double)xOffset;
        log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
    }

    public float getX() {
        return (float)this.m_position[this.m_area].x;
    }

    protected void setY(int y) {
        this.m_position[this.m_area].y = y;
        log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
    }

    protected void addY(int yOffset) {
        if ((float)yOffset == 0.0f) {
            return;
        }
        if (this.isYspaceFor(yOffset)) {
            this.m_position[this.m_area].y += (double)yOffset;
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        } else if (this.m_area == 1) {
            log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            this.newPage(true, true);
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        } else {
            this.m_position[this.m_area].y += (double)yOffset;
            log.log(Level.SEVERE, "Outside of Area: " + this.m_position);
        }
    }

    public float getY() {
        return (float)this.m_position[this.m_area].y;
    }

    public float getXspace() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return (float)((double)(part.x + part.width) - this.m_position[this.m_area].x);
    }

    public boolean isXspaceFor(float width) {
        return this.getXspace() - width > 0.0f;
    }

    public float getYspace() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return (float)((double)(part.y + part.height) - this.m_position[this.m_area].y);
    }

    public boolean isYspaceFor(float height) {
        return this.getYspace() - height > 0.0f;
    }

    public void setPrintFormat(MPrintFormat format, boolean doLayout) {
        this.m_format = format;
        this.m_printCtx = new Ctx((Map)format.getCtx());
        boolean tempHasLayout = this.m_hasLayout;
        this.m_hasLayout = false;
        MPrintPaper mPaper = MPrintPaper.get(format.getAD_PrintPaper_ID());
        if (this.m_format.isStandardHeaderFooter()) {
            this.setPaper(mPaper.getCPaper());
        } else {
            this.setPaper(mPaper.getCPaper(), this.m_format.getHeaderMargin(), this.m_format.getFooterMargin());
        }
        this.m_hasLayout = tempHasLayout;
        this.m_printColor = MPrintColor.get((Ctx)this.getCtx(), (int)format.getAD_PrintColor_ID());
        this.m_printFont = MPrintFont.get(format.getAD_PrintFont_ID());
        this.m_printCtx.setContext("*ReportName", this.m_format.getName());
        this.m_printCtx.setContext("*Header", Env.getHeader((Ctx)this.m_printCtx, (int)0));
        this.m_printCtx.setContext("#AD_Language", this.m_format.getLanguage().getAD_Language());
        if (this.m_hasLayout && doLayout) {
            this.layout();
        }
    }

    public void setPrintData(PrintData data, Query query, boolean doLayout) {
        this.m_data = data;
        this.m_query = query;
        if (this.m_hasLayout && doLayout) {
            this.layout();
        }
    }

    public void setPaper(CPaper paper) {
        this.setPaper(paper, this.m_headerHeight, this.m_footerHeight);
    }

    public void setPaper(CPaper paper, int headerHeight, int footerHeight) {
        boolean paperChange;
        if (paper == null) {
            return;
        }
        boolean bl = paperChange = headerHeight != this.m_headerHeight || footerHeight != this.m_footerHeight;
        if (!paperChange) {
            paperChange = !paper.equals(this.m_paper);
        }
        log.fine(paper + " - Header=" + headerHeight + ", Footer=" + footerHeight);
        this.m_paper = paper;
        this.m_headerHeight = headerHeight;
        this.m_footerHeight = footerHeight;
        this.calculateSize();
        if (this.m_hasLayout && paperChange) {
            this.layout();
        }
    }

    protected void setPageFormat(PageFormat pf) {
        if (pf != null) {
            this.setPaper(new CPaper(pf));
        } else {
            this.setPaper(null);
        }
    }

    public PageFormat getPageFormat() {
        return this.m_paper.getPageFormat();
    }

    @Override
    public DocFlavor getDocFlavor() {
        return DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    }

    @Override
    public Object getPrintData() throws IOException {
        return this;
    }

    @Override
    public DocAttributeSet getAttributes() {
        return null;
    }

    @Override
    public Reader getReaderForText() throws IOException {
        return null;
    }

    @Override
    public InputStream getStreamForBytes() throws IOException {
        return null;
    }

    public Color getColor() {
        if (this.m_printColor == null) {
            return Color.BLACK;
        }
        return this.m_printColor.getColor();
    }

    @Override
    public boolean calculateSize() {
        int x = (int)this.m_paper.getImageableX(true);
        int w = (int)this.m_paper.getImageableWidth(true);
        int y = (int)this.m_paper.getImageableY(true);
        int h = (int)this.m_paper.getImageableHeight(true);
        int height = this.m_headerHeight;
        this.m_header.setBounds(x, y, w, height);
        y += height;
        height = h - this.m_headerHeight - this.m_footerHeight;
        this.m_content.setBounds(x, y, w, height);
        y += height;
        height = this.m_footerHeight;
        this.m_footer.setBounds(x, y, w, height);
        log.fine("Paper=" + this.m_paper + ",HeaderHeight=" + this.m_headerHeight + ",FooterHeight=" + this.m_footerHeight + " => Header=" + this.m_header + ",Contents=" + this.m_content + ",Footer=" + this.m_footer);
        this.p_width = w;
        this.p_height = h;
        return true;
    }

    public CPaper getPaper() {
        return this.m_paper;
    }

    public boolean isPrinted(PrintData pd, String printLogic) {
        if (printLogic == null || "".equals(printLogic)) {
            return true;
        }
        boolean retValue = Evaluator.evaluateLogic((Evaluatee)pd, (String)printLogic);
        return retValue;
    }

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = LayoutEngine.class.getResource("true10.gif");
        if (url != null) {
            IMAGE_TRUE = tk.getImage(url);
        }
        if ((url = LayoutEngine.class.getResource("false10.gif")) != null) {
            IMAGE_FALSE = tk.getImage(url);
        }
    }
}

