/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;
import org.compiere.print.layout.QRCompnent;
import org.compiere.util.Ctx;

public class QRCodeElement
extends PrintElement {
    private boolean m_valid = true;
    private QRCompnent m_qrcomponent = null;
    int cellsize = 1;

    public QRCodeElement(String code, MPrintFormatItem item) {
        if (code == null || code.length() == 0 || item == null || item.getBarcodeType() == null || item.getBarcodeType().length() == 0) {
            this.m_valid = false;
        }
        this.createQRCode(code, item);
        if (this.m_qrcomponent == null) {
            this.m_valid = false;
        }
    }

    private void createQRCode(String code, MPrintFormatItem item) {
        String type = item.getBarcodeType();
        try {
            this.m_qrcomponent = new QRCompnent(code, 10, 2);
        }
        catch (Exception e) {
            this.log.warning(code + " - " + e.toString());
            this.m_valid = false;
        }
        if (this.m_valid && this.m_qrcomponent != null) {
            MPrintFont mFont;
            this.p_info = "QRCodeType=" + type;
            if (item.getAD_PrintFont_ID() != 0 && (mFont = MPrintFont.get(item.getAD_PrintFont_ID())) != null) {
                int size = mFont.getFont().getSize();
                this.cellsize = size <= 8 ? 1 : (size <= 10 ? 2 : (size <= 12 ? 3 : (size <= 14 ? 4 : (size <= 16 ? 5 : (size <= 18 ? 6 : (size <= 20 ? 7 : (size <= 22 ? 8 : (size <= 24 ? 9 : size - 15))))))));
                this.m_qrcomponent.setCellSize(this.cellsize);
            }
            this.m_qrcomponent.calculatesize();
            this.p_width = this.m_qrcomponent.getWidth();
            this.p_height = this.m_qrcomponent.getHeight();
            this.log.fine(type + " height=" + this.p_height + ", width=" + this.p_width);
        }
    }

    public QRCompnent getQRComponent() {
        return this.m_qrcomponent;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    protected boolean calculateSize() {
        return true;
    }

    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Ctx ctx, boolean isView) {
        if (!this.m_valid || this.m_qrcomponent == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        this.m_qrcomponent.draw(g2D, x, y, this);
    }

    public String toString() {
        if (this.m_qrcomponent == null) {
            return super.toString();
        }
        return super.toString() + " " + this.m_qrcomponent.getData();
    }
}

