/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import com.d_project.qrcode.QRCode;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;

public class QRCompnent
extends JComponent {
    private QRCode m_qrcode = null;
    int m_typeNumber = 1;
    int m_cellSize = 1;
    int m_margin = 1;
    String m_data = null;
    BufferedImage m_image = null;
    int m_errorCorrectLevel = 2;

    public QRCompnent(String code) {
        this.m_data = code;
        this.m_typeNumber = 1;
        this.m_cellSize = 1;
        this.m_margin = 1;
        this.m_errorCorrectLevel = 2;
        this.m_qrcode = QRCompnent.getQRCode(code, this.m_typeNumber, this.m_errorCorrectLevel);
    }

    public QRCompnent(String code, int typeNumber, int errorCorrectLevel) {
        this.m_data = code;
        this.m_typeNumber = typeNumber;
        this.m_cellSize = 1;
        this.m_margin = 1;
        this.m_errorCorrectLevel = errorCorrectLevel;
        this.m_qrcode = QRCompnent.getQRCode(code, this.m_typeNumber, this.m_errorCorrectLevel);
    }

    public QRCompnent(String code, int typeNumber, int errorCorrectLevel, int cellSize, int margen) {
        this.m_data = code;
        this.m_typeNumber = typeNumber;
        this.m_cellSize = cellSize;
        this.m_margin = margen;
        this.m_errorCorrectLevel = errorCorrectLevel;
        this.m_qrcode = QRCompnent.getQRCode(code, this.m_typeNumber, this.m_errorCorrectLevel);
    }

    private static QRCode getQRCode(String text, int typeNumber, int errorCorrectLevel) {
        if (typeNumber == 0) {
            return QRCode.getMinimumQRCode((String)text, (int)errorCorrectLevel);
        }
        QRCode qr = new QRCode();
        qr.setTypeNumber(typeNumber);
        qr.setErrorCorrectLevel(errorCorrectLevel);
        qr.addData(text);
        qr.make();
        return qr;
    }

    public boolean calculatesize() {
        try {
            this.m_image = this.m_qrcode.createImage(this.m_cellSize, this.m_margin);
        }
        catch (Exception e) {
            this.m_image = null;
        }
        return this.m_image != null;
    }

    public int getWidth() {
        return this.m_image.getWidth();
    }

    public int getHeight() {
        return this.m_image.getHeight();
    }

    public void draw(Graphics2D g2D, int x, int y, ImageObserver observer) {
        if (this.m_image != null) {
            g2D.drawImage((Image)this.m_image, x, y, observer);
        }
    }

    public QRCode getQRCode() {
        return this.m_qrcode;
    }

    public void setQRCode(QRCode m_qrcode) {
        this.m_qrcode = m_qrcode;
    }

    public int getTypeNumber() {
        return this.m_typeNumber;
    }

    public void setTypeNumber(int number) {
        this.m_typeNumber = number;
    }

    public int getCellSize() {
        return this.m_cellSize;
    }

    public void setCellSize(int size) {
        this.m_cellSize = size;
    }

    public int getMargin() {
        return this.m_margin;
    }

    public void setMargin(int m_margin) {
        this.m_margin = m_margin;
    }

    public int getErrorCorrectLevel() {
        return this.m_errorCorrectLevel;
    }

    public void setErrorCorrectLevel(int correctLevel) {
        this.m_errorCorrectLevel = correctLevel;
    }

    public String getData() {
        return this.m_data;
    }

    public void setData(String m_data) {
        this.m_data = m_data;
    }
}

