/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.esb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

class GwtServerUtil {
    private static CLogger log = CLogger.getCLogger(GwtServerUtil.class);

    GwtServerUtil() {
    }

    static int getRequests(Ctx ctx) {
        int retValue = 0;
        String requestSQL = MRole.getDefault().addAccessSQL("SELECT COUNT(*) FROM R_Request WHERE (SalesRep_ID=? OR AD_Role_ID=?) AND Processed='N' AND (DateNextAction IS NULL OR TRUNC(DateNextAction, 'DD') <= TRUNC(SysDate, 'DD')) AND (R_Status_ID IS NULL OR R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N'))", "R_Request", false, true);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)requestSQL, null);
            pstmt.setInt(1, ctx.getAD_User_ID());
            pstmt.setInt(2, ctx.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, requestSQL, (Throwable)e);
        }
        return retValue;
    }

    static int getNotes(Ctx ctx) {
        int retValue = 0;
        String sql = "SELECT COUNT(*) FROM AD_Note WHERE AD_Client_ID=? AND AD_User_ID IN (0,?) AND Processed='N'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ctx.getAD_Client_ID());
            pstmt.setInt(2, ctx.getAD_User_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return retValue;
    }
}

