/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutBankStatement
extends CalloutEngine {
    public String bankAccount(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int C_BankAccount_ID = (Integer)value;
        MBankAccount ba = MBankAccount.get(ctx, C_BankAccount_ID);
        mTab.setValue("BeginningBalance", (Object)ba.getCurrentBalance());
        return "";
    }

    public String amount(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal trx;
        if (CalloutBankStatement.isCalloutActive()) {
            return "";
        }
        CalloutBankStatement.setCalloutActive(true);
        BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
        if (stmt == null) {
            stmt = Env.ZERO;
        }
        if ((trx = (BigDecimal)mTab.getValue("TrxAmt")) == null) {
            trx = Env.ZERO;
        }
        BigDecimal bd = stmt.subtract(trx);
        if (!mField.getColumnName().equals("InterestAmt")) {
            BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
            if (charge == null) {
                charge = Env.ZERO;
            }
            bd = bd.subtract(charge);
            mTab.setValue("InterestAmt", (Object)bd);
        } else {
            Integer C_Payment_ID = (Integer)mTab.getValue("C_Payment_ID");
            if (C_Payment_ID == null || C_Payment_ID == 0) {
                BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
                if (interest == null) {
                    interest = Env.ZERO;
                }
                bd = stmt.subtract(interest);
                BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
                if (charge == null) {
                    charge = Env.ZERO;
                }
                bd = bd.subtract(charge);
                mTab.setValue("TrxAmt", (Object)bd);
            } else {
                BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
                if (interest == null) {
                    interest = Env.ZERO;
                }
                bd = trx.add(interest);
                BigDecimal charge = (BigDecimal)mTab.getValue("ChargeAmt");
                if (charge == null) {
                    charge = Env.ZERO;
                }
                bd = bd.add(charge);
                mTab.setValue("StmtAmt", (Object)bd);
            }
        }
        CalloutBankStatement.setCalloutActive(false);
        return "";
    }

    public String payment(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Payment_ID = (Integer)value;
        if (C_Payment_ID == null || C_Payment_ID == 0) {
            return "";
        }
        BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
        if (stmt == null) {
            stmt = Env.ZERO;
        }
        String sql = "SELECT PayAmt, DateTrx FROM C_Payment_v WHERE C_Payment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Payment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal bd = rs.getBigDecimal(1);
                mTab.setValue("TrxAmt", (Object)bd);
                if (stmt.compareTo(Env.ZERO) == 0) {
                    mTab.setValue("StmtAmt", (Object)bd);
                }
                Timestamp dateTrx = rs.getTimestamp(2);
                mTab.setValue("StatementLineDate", (Object)dateTrx);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BankStmt_Payment", (Throwable)e);
            return e.getLocalizedMessage();
        }
        this.amount(ctx, WindowNo, mTab, mField, value);
        return "";
    }

    public String charge(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        CalloutBankStatement.setCalloutActive(true);
        String sql = "SELECT IsTaxIncluded, ChargeAmt FROM C_Charge WHERE C_Charge_ID=? AND IsActive='Y' ";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal chargeAmt = rs.getBigDecimal("ChargeAmt");
                if (chargeAmt != null && chargeAmt.floatValue() != 0.0f) {
                    mTab.setValue("ChargeAmt", (Object)chargeAmt);
                }
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString("IsTaxIncluded"))));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutBankStatement.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutBankStatement.setCalloutActive(false);
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Tax_ID = (Integer)mTab.getValue("C_Tax_ID");
        if (C_Tax_ID == null || C_Tax_ID == 0) {
            return "";
        }
        CalloutBankStatement.setCalloutActive(true);
        MTax tax = MTax.get(ctx, C_Tax_ID);
        int C_Currency_ID = ctx.getContextAsInt(WindowNo, "C_Currency_ID");
        if (C_Currency_ID == 0) {
            MClient client = MClient.get((Ctx)ctx);
            C_Currency_ID = client.getC_Currency_ID();
        }
        int scale = MCurrency.getStdPrecision((Ctx)ctx, (int)C_Currency_ID);
        BigDecimal chargeAmt = (BigDecimal)mTab.getValue("ChargeAmt");
        if (chargeAmt == null) {
            chargeAmt = BigDecimal.ZERO;
        }
        boolean isTaxIncluded = true;
        Object obj = mTab.getValue("IsTaxIncluded");
        isTaxIncluded = (Boolean)obj;
        BigDecimal taxAmt = BigDecimal.ZERO;
        Integer C_BPartner_ID = (Integer)mTab.getValue("C_BPartner_ID");
        if (C_BPartner_ID != null && C_BPartner_ID != 0) {
            MBPartner bpartner = MBPartner.get(ctx, C_BPartner_ID);
            taxAmt = tax.calculateTax(chargeAmt, isTaxIncluded, scale, bpartner.getTaxRoundModeAsInt());
        } else {
            taxAmt = tax.calculateTax(chargeAmt, isTaxIncluded, scale, 4);
        }
        mTab.setValue("TaxAmt", (Object)taxAmt);
        if (!isTaxIncluded) {
            BigDecimal totalAmt = chargeAmt.add(taxAmt);
            mTab.setValue("TotalAmt", (Object)totalAmt);
        } else {
            mTab.setValue("TotalAmt", (Object)chargeAmt);
        }
        CalloutBankStatement.setCalloutActive(false);
        return "";
    }
}

