/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.MBilling;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutBilling
extends CalloutEngine {
    public String invoice(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MInvoice invoice;
        Integer C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
        if (IsSOTrx != (invoice = MInvoice.get(ctx, C_Invoice_ID)).isSOTrx()) {
            return "";
        }
        int billingDocType = 0;
        if (IsSOTrx) {
            MDocType[] docTypes = MDocType.getOfDocBaseType((Ctx)ctx, (String)"BRI");
            billingDocType = docTypes[0].getC_DocType_ID();
        } else {
            MDocType[] docTypes = MDocType.getOfDocBaseType((Ctx)ctx, (String)"BPI");
            billingDocType = docTypes[0].getC_DocType_ID();
        }
        mTab.setValue("C_DocTypeTarget_ID", (Object)new Integer(billingDocType));
        mTab.setValue("DateInvoiced", (Object)invoice.getDateInvoiced());
        if (invoice.getC_Activity_ID() != 0) {
            mTab.setValue("C_Activity_ID", (Object)new Integer(invoice.getC_Activity_ID()));
        }
        if (invoice.getC_Campaign_ID() != 0) {
            mTab.setValue("C_Campaign_ID", (Object)new Integer(invoice.getC_Campaign_ID()));
        }
        if (invoice.getC_Project_ID() != 0) {
            mTab.setValue("C_Project_ID", (Object)new Integer(invoice.getC_Project_ID()));
        }
        if (invoice.getC_Order_ID() != 0) {
            mTab.setValue("C_Order_ID", (Object)new Integer(invoice.getC_Order_ID()));
        }
        if (invoice.getC_Charge_ID() != 0) {
            mTab.setValue("C_Charge_ID", (Object)new Integer(invoice.getC_Charge_ID()));
        }
        if (invoice.getC_ConversionType_ID() != 0) {
            mTab.setValue("C_ConversionType_ID", (Object)new Integer(invoice.getC_ConversionType_ID()));
        }
        if (invoice.getC_CashLine_ID() != 0) {
            mTab.setValue("C_CashLine_ID", (Object)new Integer(invoice.getC_CashLine_ID()));
        }
        mTab.setValue("DateOrdered", (Object)invoice.getDateOrdered());
        mTab.setValue("Description", (Object)invoice.getDescription());
        mTab.setValue("POReference", (Object)invoice.getPOReference());
        if (invoice.getSalesRep_ID() != 0) {
            mTab.setValue("SalesRep_ID", (Object)new Integer(invoice.getSalesRep_ID()));
        }
        if (invoice.getUser1_ID() != 0) {
            mTab.setValue("User1_ID", (Object)new Integer(invoice.getUser1_ID()));
        }
        if (invoice.getUser2_ID() != 0) {
            mTab.setValue("User2_ID", (Object)new Integer(invoice.getUser2_ID()));
        }
        mTab.setValue("C_BPartner_ID", (Object)new Integer(invoice.getC_BPartner_ID()));
        mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(invoice.getC_BPartner_Location_ID()));
        mTab.setValue("AD_User_ID", (Object)new Integer(invoice.getAD_User_ID()));
        mTab.setValue("M_PriceList_ID", (Object)new Integer(invoice.getM_PriceList_ID()));
        mTab.setValue("C_Currency_ID", (Object)new Integer(invoice.getC_Currency_ID()));
        mTab.setValue("C_PaymentTerm_ID", (Object)new Integer(invoice.getC_PaymentTerm_ID()));
        mTab.setValue("PaymentRule", (Object)invoice.getPaymentRule());
        return "";
    }

    public String docType(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext, d.DocBaseType FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_DocType_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ctx.setContext(WindowNo, "HasCharges", rs.getString(1));
                if (rs.getString(3).equals("Y")) {
                    mTab.setValue("DocumentNo", (Object)("<" + rs.getString(4) + ">"));
                }
                String s = rs.getString(5);
                ctx.setContext(WindowNo, "DocBaseType", s);
                if (s.startsWith("BP")) {
                    mTab.setValue("PaymentRule", (Object)"S");
                } else if (s.endsWith("C")) {
                    mTab.setValue("PaymentRule", (Object)"P");
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String bPartner(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, l.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                double CreditLimit;
                String cont;
                String loc;
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = ctx.getContextAsInt("#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                if (s != null && s.length() != 0) {
                    if (ctx.getContext(WindowNo, "DocBaseType").endsWith("C")) {
                        s = "P";
                    } else if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                        s = "P";
                    }
                    mTab.setValue("PaymentRule", (Object)s);
                }
                ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                }
                int locID = rs.getInt("C_BPartner_Location_ID");
                if (C_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (loc = ctx.getContext(1113, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    locID = Integer.parseInt(loc);
                }
                if (locID == 0) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(locID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (C_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (cont = ctx.getContext(1113, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                } else {
                    mTab.setValue("POReference", null);
                }
                s = rs.getString("SO_Description");
                if (s != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
            }
            rs.close();
            pstmt.close();
            if (IsSOTrx) {
                Timestamp billingDate = (Timestamp)mTab.getValue("DateBilling");
                MBilling lastBilling = MBilling.getLastBilling(ctx, C_BPartner_ID, billingDate, null);
                if (lastBilling != null) {
                    BigDecimal lastInvoicedAmt = lastBilling.getTotalInvoiceAmt();
                    mTab.setValue("LastInvoicedAmt", (Object)lastBilling.getTotalInvoiceAmt());
                    BigDecimal lastPaid = MPayment.getSumOfBPartner(ctx, C_BPartner_ID, lastBilling.getDateBilling(), billingDate, null);
                    mTab.setValue("LastPaidAmt", (Object)lastPaid);
                    BigDecimal adjustAmt = (BigDecimal)mTab.getValue("AdjustAmt");
                    if (adjustAmt == null) {
                        adjustAmt = BigDecimal.ZERO;
                        mTab.setValue("AdjustAmt", (Object)adjustAmt);
                    }
                    BigDecimal lastTansferedAmt = lastInvoicedAmt.subtract(lastPaid).add(adjustAmt);
                    mTab.setValue("LastTransferedAmt", (Object)lastTansferedAmt);
                    mTab.setValue("IsAdjusted", (Object)"N");
                }
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "bPartner", (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String paymentTerm(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_PaymentTerm_ID = (Integer)value;
        int C_Billing_ID = ctx.getContextAsInt(WindowNo, "C_Billing_ID");
        if (C_PaymentTerm_ID == null || C_PaymentTerm_ID == 0 || C_Billing_ID == 0) {
            return "";
        }
        MPaymentTerm pt = new MPaymentTerm(ctx, C_PaymentTerm_ID, null);
        if (pt.get_ID() == 0) {
            return "PaymentTerm not found";
        }
        return "";
    }

    public String transferedAmt(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutBilling.isCalloutActive() || value == null) {
            return "";
        }
        CalloutBilling.setCalloutActive(true);
        BigDecimal LastInvoicedAmt = (BigDecimal)mTab.getValue("LastInvoicedAmt");
        BigDecimal LastPaidAmt = (BigDecimal)mTab.getValue("LastPaidAmt");
        BigDecimal AdjustAmt = (BigDecimal)mTab.getValue("AdjustAmt");
        if (LastInvoicedAmt == null) {
            LastInvoicedAmt = BigDecimal.ZERO;
            mTab.setValue("LastInvoicedAmt", (Object)LastInvoicedAmt);
        }
        if (LastPaidAmt == null) {
            LastPaidAmt = BigDecimal.ZERO;
            mTab.setValue("LastPaidAmt", (Object)LastPaidAmt);
        }
        if (AdjustAmt == null) {
            AdjustAmt = BigDecimal.ZERO;
            mTab.setValue("AdjustAmt", (Object)AdjustAmt);
        }
        BigDecimal LastTransferedAmt = LastInvoicedAmt.subtract(LastPaidAmt).add(AdjustAmt);
        mTab.setValue("LastTransferedAmt", (Object)LastTransferedAmt);
        BigDecimal RevenueNetAmt = (BigDecimal)mTab.getValue("RevenueNetAmt");
        BigDecimal TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        if (RevenueNetAmt == null) {
            RevenueNetAmt = BigDecimal.ZERO;
            mTab.setValue("RevenueNetAmt", (Object)RevenueNetAmt);
        }
        if (TaxAmt == null) {
            TaxAmt = BigDecimal.ZERO;
            mTab.setValue("TaxAmt", (Object)TaxAmt);
        }
        BigDecimal TotalInvoiceAmt = LastTransferedAmt.add(RevenueNetAmt).add(TaxAmt);
        mTab.setValue("TotalInvoiceAmt", (Object)TotalInvoiceAmt);
        CalloutBilling.setCalloutActive(false);
        return "";
    }

    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        CalloutBilling.setCalloutActive(true);
        mTab.setValue("C_Charge_ID", null);
        if (ctx.getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID.intValue() && ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID")));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
        int C_BPartner_ID = ctx.getContextAsInt(WindowNo, WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyBilling");
        MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp date = ctx.getContextAsDate(WindowNo, "DateBilling");
        pp.setPriceDate(date);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        ctx.setContext(WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        CalloutBilling.setCalloutActive(false);
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        ctx.setContext(WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceLimit", (Object)Env.ZERO);
                mTab.setValue("PriceList", (Object)Env.ZERO);
                mTab.setValue("Discount", (Object)Env.ZERO);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql + e);
            return e.getLocalizedMessage();
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        int billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        Timestamp billDate = ctx.getContextAsDate(WindowNo, "DateBilling");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = billDate;
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = ctx.getContextAsInt("#M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, ctx.getContext(WindowNo, "IsSOTrx").equals("Y"));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        if (CalloutBilling.isCalloutActive() || value == null) {
            return "";
        }
        CalloutBilling.setCalloutActive(true);
        int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getPricePrecision(ctx, M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyBilling = (BigDecimal)mTab.getValue("QtyBilling");
        this.log.fine("QtyEntered=" + QtyEntered + ", Billing=" + QtyBilling + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual);
        if ((mField.getColumnName().equals("QtyBilling") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(ctx.getContext(WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyBilling = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyBilling == null) {
                QtyBilling = QtyEntered;
            }
            boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, QtyBilling, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = ctx.getContextAsDate(WindowNo, "DateBilling");
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("amt - QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("amt - PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("amt - PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        String epl = ctx.getContext(WindowNo, "EnforcePriceLimit");
        boolean bl = enforce = ctx.isSOTrx(WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            BigDecimal Discount;
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("amt =(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0 && (Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0)).scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
        }
        if ((LineNetAmt = QtyBilling.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("amt = LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        boolean IsSOTrx = "Y".equals(ctx.getContext(WindowNo, "IsSOTrx"));
        if (!IsSOTrx) {
            BigDecimal TaxAmt = Env.ZERO;
            if (mField.getColumnName().equals("TaxAmt")) {
                TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
            } else {
                Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
                Integer partnerID = (Integer)mTab.getValue("C_BPartner_ID");
                if (taxID != null) {
                    int C_Tax_ID = taxID;
                    MTax tax = new MTax(ctx, C_Tax_ID, null);
                    int roundingmode = 4;
                    if (partnerID != 0) {
                        MBPartner partner = MBPartner.get(ctx, partnerID);
                        roundingmode = partner.getTaxRoundModeAsInt();
                    }
                    TaxAmt = tax.calculateTax(LineNetAmt, this.isTaxIncluded(ctx, WindowNo), StdPrecision, roundingmode);
                    mTab.setValue("TaxAmt", (Object)TaxAmt);
                }
            }
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        CalloutBilling.setCalloutActive(false);
        return "";
    }

    private boolean isTaxIncluded(Ctx ctx, int WindowNo) {
        String ss = ctx.getContext(WindowNo, "IsTaxIncluded");
        if (ss.length() == 0) {
            int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
            if (M_PriceList_ID == 0) {
                return false;
            }
            ss = DB.getSQLValueString(null, (String)"SELECT IsTaxIncluded FROM M_PriceList WHERE M_PriceList_ID=?", (int)M_PriceList_ID);
            if (ss == null) {
                ss = "N";
            }
            ctx.setContext(WindowNo, "IsTaxIncluded", ss);
        }
        return "Y".equals(ss);
    }

    public String qty(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutBilling.isCalloutActive() || value == null) {
            return "";
        }
        CalloutBilling.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyBilling", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyBilling;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyBilling = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyBilling = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyBilling) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyBilling/PriceEntered=" + QtyBilling + "/" + PriceEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyBilling", (Object)QtyBilling);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyBilling;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyBilling = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyBilling = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyBilling) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyBilling=" + QtyBilling);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyBilling", (Object)QtyBilling);
        } else if (mField.getColumnName().equals("QtyBilling")) {
            BigDecimal QtyEntered;
            int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            BigDecimal QtyBilling = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyBilling1 = QtyBilling.setScale(precision, 4);
            if (QtyBilling.compareTo(QtyBilling1) != 0) {
                this.log.fine("Corrected QtyBilling Scale " + QtyBilling + "->" + QtyBilling1);
                QtyBilling = QtyBilling1;
                mTab.setValue("QtyBilling", (Object)QtyBilling);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyBilling)) == null) {
                QtyEntered = QtyBilling;
            }
            boolean conversion = QtyBilling.compareTo(QtyEntered) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyBilling=" + QtyBilling + " -> " + conversion + " QtyEntered=" + QtyEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        CalloutBilling.setCalloutActive(false);
        return "";
    }

    public String invoiceline(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_InvoiceLine_ID = (Integer)value;
        if (C_InvoiceLine_ID == null || C_InvoiceLine_ID == 0) {
            return "";
        }
        if (CalloutBilling.isCalloutActive() || value == null) {
            return "";
        }
        CalloutBilling.setCalloutActive(true);
        MInvoiceLine invoiceline = new MInvoiceLine(ctx, C_InvoiceLine_ID, null);
        mTab.setValue("Description", (Object)invoiceline.getDescription());
        if (invoiceline.getC_Activity_ID() != 0) {
            mTab.setValue("C_Activity_ID", (Object)new Integer(invoiceline.getC_Activity_ID()));
        }
        if (invoiceline.getC_Campaign_ID() != 0) {
            mTab.setValue("C_Campaign_ID", (Object)new Integer(invoiceline.getC_Campaign_ID()));
        }
        if (invoiceline.getC_Project_ID() != 0) {
            mTab.setValue("C_Project_ID", (Object)new Integer(invoiceline.getC_Project_ID()));
        }
        if (invoiceline.getC_ProjectPhase_ID() != 0) {
            mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(invoiceline.getC_ProjectPhase_ID()));
        }
        if (invoiceline.getC_ProjectTask_ID() != 0) {
            mTab.setValue("C_ProjectTask_ID", (Object)new Integer(invoiceline.getC_ProjectTask_ID()));
        }
        if (invoiceline.getC_OrderLine_ID() != 0) {
            mTab.setValue("C_OrderLine_ID", (Object)new Integer(invoiceline.getC_OrderLine_ID()));
        }
        if (invoiceline.getC_Charge_ID() != 0) {
            mTab.setValue("C_Charge_ID", (Object)new Integer(invoiceline.getC_Charge_ID()));
        }
        if (invoiceline.getUser1_ID() != 0) {
            mTab.setValue("User1_ID", (Object)new Integer(invoiceline.getUser1_ID()));
        }
        if (invoiceline.getUser2_ID() != 0) {
            mTab.setValue("User2_ID", (Object)new Integer(invoiceline.getUser2_ID()));
        }
        if (invoiceline.getM_Product_ID() != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(invoiceline.getM_Product_ID()));
        }
        if (invoiceline.getC_Tax_ID() != 0) {
            mTab.setValue("C_Tax_ID", (Object)new Integer(invoiceline.getC_Tax_ID()));
        }
        if (invoiceline.getC_Tax_ID() != 0) {
            mTab.setValue("C_UOM_ID", (Object)new Integer(invoiceline.getC_UOM_ID()));
        }
        mTab.setValue("QtyEntered", (Object)invoiceline.getQtyEntered());
        mTab.setValue("QtyBilling", (Object)invoiceline.getQtyInvoiced());
        mTab.setValue("PriceEntered", (Object)invoiceline.getPriceEntered());
        mTab.setValue("PriceActual", (Object)invoiceline.getPriceActual());
        mTab.setValue("PriceLimit", (Object)invoiceline.getPriceLimit());
        mTab.setValue("PriceList", (Object)invoiceline.getPriceList());
        mTab.setValue("LineNetAmt", (Object)invoiceline.getLineNetAmt());
        mTab.setValue("LineTotalAmt", (Object)invoiceline.getLineTotalAmt());
        mTab.setValue("PriceList", (Object)invoiceline.getPriceList());
        mTab.setValue("RRAmt", (Object)invoiceline.getRRAmt());
        mTab.setValue("RRStartDate", (Object)invoiceline.getRRStartDate());
        if (invoiceline.getC_Charge_ID() != 0) {
            mTab.setValue("C_Charge_ID", (Object)new Integer(invoiceline.getC_Charge_ID()));
        }
        CalloutBilling.setCalloutActive(false);
        return "";
    }
}

