/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutCashJournal
extends CalloutEngine {
    public String cashbook(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Cash_ID;
        if (CalloutCashJournal.isCalloutActive()) {
            return "";
        }
        CalloutCashJournal.setCalloutActive(true);
        Integer C_CashBook_ID = (Integer)mTab.getValue("C_CashBook_ID");
        if (C_CashBook_ID == null || C_CashBook_ID == 0) {
            mTab.setValue("C_Currency_ID", null);
            CalloutCashJournal.setCalloutActive(false);
            return "";
        }
        Timestamp statementDate = (Timestamp)mTab.getValue("StatementDate");
        if (statementDate == null) {
            statementDate = new Timestamp(Calendar.getInstance().getTimeInMillis());
        }
        if ((C_Cash_ID = (Integer)mTab.getValue("C_Cash_ID")) == null) {
            C_Cash_ID = 0;
        }
        BigDecimal beginningBalance = MCash.getBalance(C_CashBook_ID, statementDate, C_Cash_ID);
        mTab.setValue("BeginningBalance", (Object)beginningBalance);
        CalloutCashJournal.setCalloutActive(false);
        return "";
    }

    public String invoice(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutCashJournal.isCalloutActive()) {
            return "";
        }
        CalloutCashJournal.setCalloutActive(true);
        Integer C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == null || C_Invoice_ID == 0) {
            mTab.setValue("C_Currency_ID", null);
            CalloutCashJournal.setCalloutActive(false);
            return "";
        }
        Timestamp ts = new Timestamp(ctx.getContextAsTime(WindowNo, "DateAcct"));
        String sql = "SELECT C_BPartner_ID, C_Currency_ID,invoiceOpen(C_Invoice_ID, 0), IsSOTrx, paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0),C_Currency_ID,C_PaymentTerm_ID,DateInvoiced,?) FROM C_Invoice WHERE C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("C_BPartner_ID", (Object)new Integer(rs.getInt(1)));
                mTab.setValue("C_Currency_ID", (Object)new Integer(rs.getInt(2)));
                BigDecimal PayAmt = rs.getBigDecimal(3);
                BigDecimal DiscountAmt = rs.getBigDecimal(5);
                boolean isSOTrx = "Y".equals(rs.getString(4));
                if (!isSOTrx) {
                    PayAmt = PayAmt.negate();
                    DiscountAmt = DiscountAmt.negate();
                }
                mTab.setValue("Amount", (Object)PayAmt.subtract(DiscountAmt));
                mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
                ctx.setContext(WindowNo, "InvTotalAmt", PayAmt.toString());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "invoice", (Throwable)e);
            CalloutCashJournal.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutCashJournal.setCalloutActive(false);
        return "";
    }

    public String amounts(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutCashJournal.isCalloutActive() || !"I".equals(mTab.getValue("CashType"))) {
            return "";
        }
        String total = ctx.getContext(WindowNo, "InvTotalAmt");
        if (total == null || total.length() == 0) {
            return "";
        }
        BigDecimal InvTotalAmt = new BigDecimal(total);
        CalloutCashJournal.setCalloutActive(true);
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        String colName = mField.getColumnName();
        this.log.fine(colName + " - Invoice=" + InvTotalAmt + " - Amount=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
        if (colName.equals("Amount")) {
            WriteOffAmt = InvTotalAmt.subtract(PayAmt).subtract(DiscountAmt);
            mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
        } else {
            PayAmt = InvTotalAmt.subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("Amount", (Object)PayAmt);
        }
        CalloutCashJournal.setCalloutActive(false);
        return "";
    }

    public String charge(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        CalloutCashJournal.setCalloutActive(true);
        String sql = "SELECT IsTaxIncluded, ChargeAmt FROM C_Charge WHERE C_Charge_ID=? AND IsActive='Y' ";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal chargeAmt = rs.getBigDecimal("ChargeAmt");
                if (chargeAmt != null && chargeAmt.floatValue() != 0.0f) {
                    mTab.setValue("Amount", (Object)chargeAmt);
                }
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString("IsTaxIncluded"))));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutCashJournal.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutCashJournal.setCalloutActive(false);
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String cashType = (String)mTab.getValue("CashType");
        if ("C".equals(cashType)) {
            Integer C_Tax_ID = (Integer)mTab.getValue("C_Tax_ID");
            if (C_Tax_ID == null || C_Tax_ID == 0) {
                return "";
            }
            CalloutCashJournal.setCalloutActive(true);
            MTax tax = MTax.get(ctx, C_Tax_ID);
            int C_Currency_ID = ctx.getContextAsInt(WindowNo, "C_Currency_ID");
            if (C_Currency_ID == 0) {
                MClient client = MClient.get((Ctx)ctx);
                C_Currency_ID = client.getC_Currency_ID();
            }
            int scale = MCurrency.getStdPrecision((Ctx)ctx, (int)C_Currency_ID);
            BigDecimal amount = (BigDecimal)mTab.getValue("Amount");
            if (amount == null) {
                amount = BigDecimal.ZERO;
            }
            boolean isTaxIncluded = true;
            Object obj = mTab.getValue("IsTaxIncluded");
            isTaxIncluded = (Boolean)obj;
            BigDecimal taxAmt = BigDecimal.ZERO;
            Integer C_BPartner_ID = (Integer)mTab.getValue("C_BPartner_ID");
            if (C_BPartner_ID != null && C_BPartner_ID != 0) {
                MBPartner bpartner = MBPartner.get(ctx, C_BPartner_ID);
                taxAmt = tax.calculateTax(amount, isTaxIncluded, scale, bpartner.getTaxRoundModeAsInt());
            } else {
                taxAmt = tax.calculateTax(amount, isTaxIncluded, scale, 4);
            }
            mTab.setValue("TaxAmt", (Object)taxAmt);
            if (!isTaxIncluded) {
                BigDecimal totalAmt = amount.add(taxAmt);
                mTab.setValue("TotalAmt", (Object)totalAmt);
            } else {
                mTab.setValue("TotalAmt", (Object)amount);
            }
            CalloutCashJournal.setCalloutActive(false);
        } else {
            CalloutCashJournal.setCalloutActive(true);
            BigDecimal amount = (BigDecimal)mTab.getValue("Amount");
            BigDecimal taxAmt = BigDecimal.ZERO;
            mTab.setValue("TaxAmt", (Object)taxAmt);
            mTab.setValue("TotalAmt", (Object)amount);
            CalloutCashJournal.setCalloutActive(false);
        }
        return "";
    }
}

