/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductLocator;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInOut
extends CalloutEngine {
    private boolean steps = false;

    public String order(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        MOrder order = new MOrder(ctx, C_Order_ID, null);
        if (order.get_ID() != 0) {
            boolean isReturnTrx;
            MDocType docType = new MDocType(ctx, order.getC_DocType_ID(), null);
            if (docType != null) {
                mTab.setValue("C_DocType_ID", (Object)docType.getC_DocTypeShipment_ID());
            }
            mTab.setValue("DateOrdered", (Object)order.getDateOrdered());
            mTab.setValue("POReference", (Object)order.getPOReference());
            mTab.setValue("AD_Org_ID", (Object)new Integer(order.getAD_Org_ID()));
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            if (order.getM_Shipper_ID() != 0) {
                mTab.setValue("M_Shipper_ID", (Object)new Integer(order.getM_Shipper_ID()));
            }
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            mTab.setValue("C_BPartner_ID", (Object)new Integer(order.getC_BPartner_ID()));
            mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(order.getC_BPartner_Location_ID()));
            if (order.getAD_OrgTrx_ID() != 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(order.getAD_OrgTrx_ID()));
            }
            if (order.getC_Activity_ID() != 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(order.getC_Activity_ID()));
            }
            if (order.getC_Campaign_ID() != 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(order.getC_Campaign_ID()));
            }
            if (order.getC_Campaign_ID() != 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(order.getC_Project_ID()));
            }
            if (order.getUser1_ID() != 0) {
                mTab.setValue("User1_ID", (Object)new Integer(order.getUser1_ID()));
            }
            if (order.getUser2_ID() != 0) {
                mTab.setValue("User2_ID", (Object)new Integer(order.getUser2_ID()));
            }
            if (order.getM_Warehouse_ID() != 0) {
                mTab.setValue("M_Warehouse_ID", (Object)new Integer(order.getM_Warehouse_ID()));
            }
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            mTab.setValue("M_PriceList_ID", (Object)new Integer(order.getM_PriceList_ID()));
            mTab.setValue("C_Currency_ID", (Object)new Integer(order.getC_Currency_ID()));
            mTab.setValue("IsTaxIncluded", (Object)new Boolean(order.isTaxIncluded()));
            mTab.setValue("IsDropShip", (Object)order.isDropShip());
            mTab.setValue("DeliveryTo_ID", (Object)order.getDeliveryTo_ID());
            mTab.setValue("DeliveryToLoc_ID", (Object)order.getDeliveryToLoc_ID());
            mTab.setValue("DeliverTo", (Object)order.getDeliverTo());
            mTab.setValue("DeliverToPostal", (Object)order.getDeliverToPostal());
            mTab.setValue("DeliverToAddress", (Object)order.getDeliverToAddress());
            mTab.setValue("DeliverToPhone", (Object)order.getDeliverToPhone());
            mTab.setValue("DeliverToFax", (Object)order.getDeliverToFax());
            mTab.setValue("Description", (Object)order.getDescription());
            if (order.getDatePromised() != null) {
                mTab.setValue("DateArrival", (Object)order.getDatePromised());
            }
            if (isReturnTrx = ((Boolean)mTab.getValue("IsReturnTrx")).booleanValue()) {
                mTab.setValue("Orig_Order_ID", (Object)order.getOrig_Order_ID());
                mTab.setValue("Orig_InOut_ID", (Object)order.getOrig_InOut_ID());
            }
        }
        CalloutInOut.setCalloutActive(false);
        Integer C_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
        return this.docType(ctx, WindowNo, mTab, mField, C_DocType_ID);
    }

    public String docType(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.CurrentNext, d.IsReturnTrx FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        try {
            ctx.setContext(WindowNo, "C_DocTypeTarget_ID", C_DocType_ID.intValue());
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_DocType_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String DocBaseType = rs.getString("DocBaseType");
                Boolean isReturnTrx = rs.getString("IsReturnTrx").equals("Y");
                if (DocBaseType.equals("MMS") && !isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"C-");
                } else if (DocBaseType.equals("MMS") && isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"C+");
                } else if (DocBaseType.equals("MMR") && !isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"V+");
                } else if (DocBaseType.equals("MMR") && isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"V-");
                }
                if (rs.getString("IsDocNoControlled").equals("Y")) {
                    mTab.setValue("DocumentNo", (Object)("<" + rs.getString("CurrentNext") + ">"));
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String bpartner(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
        Integer order = (Integer)mTab.getValue("C_Order_ID");
        String sql = "SELECT p.Name,p.AD_Language, p.POReference,p.M_PriceList_ID,p.PO_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,l.C_BPartner_Location_ID, l.Phone, l.Fax, l.C_Location_ID, c.AD_User_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID) LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=?";
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt("C_BPartner_Location_ID"));
                if (order == null) {
                    if (rs.wasNull()) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)ii);
                    }
                }
                Integer priceList = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)priceList);
                } else {
                    int i = ctx.getContextAsInt("#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                mTab.setValue("Deliveryto_ID", (Object)C_BPartner_ID);
                if (ii == 0) {
                    mTab.setValue("DeliveryToLoc_ID", null);
                } else {
                    mTab.setValue("DeliveryToLoc_ID", (Object)new Integer(ii));
                }
                if (IsSOTrx && !IsDropShip) {
                    String name = rs.getString("Name");
                    mTab.setValue("DeliverTo", (Object)name);
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Phone");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
                ii = new Integer(rs.getInt("AD_User_ID"));
                if (rs.wasNull()) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)ii);
                }
                if (!isReturnTrx) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String bPartnerLocation(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer C_BPartner_Location_ID = (Integer)value;
        if (C_BPartner_Location_ID == null || C_BPartner_Location_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        mTab.setValue("DeliverToLoc_ID", (Object)C_BPartner_Location_ID);
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        if (IsSOTrx && !IsDropShip) {
            String sql = "SELECT C_Location_ID, Phone, Fax  FROM C_BPartner_Location WHERE C_BPartner_Location_ID=? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_Location_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                CalloutInOut.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String bPartnerDeliverTo(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        String sql = "SELECT p.Name,  lship.C_Location_ID, lship.Phone, lship.Fax, lship.C_BPartner_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y')WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (shipTo_ID == 0) {
                    mTab.setValue("DeliveryToLoc_ID", null);
                } else {
                    mTab.setValue("DeliveryToLoc_ID", (Object)new Integer(shipTo_ID));
                }
                if (IsSOTrx && !IsDropShip || !IsSOTrx && IsDropShip) {
                    String name = rs.getString("Name");
                    mTab.setValue("DeliverTo", (Object)name);
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String bPartnerDeliverToLocation(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer C_BPartner_Location_ID = (Integer)value;
        if (C_BPartner_Location_ID == null || C_BPartner_Location_ID == 0) {
            return "";
        }
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        if (IsSOTrx && !IsDropShip || !IsSOTrx && IsDropShip) {
            CalloutInOut.setCalloutActive(true);
            String sql = "SELECT C_Location_ID, Phone, Fax  FROM C_BPartner_Location WHERE C_BPartner_Location_ID=? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_Location_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                CalloutInOut.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
            CalloutInOut.setCalloutActive(false);
        }
        return "";
    }

    public String warehouse(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID, o.Name,  w.C_Location_ID, w.Phone, w.Fax FROM AD_Org o, M_Warehouse w LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') WHERE w.AD_ORG_ID=o.AD_ORG_ID AND w.M_Warehouse_ID=?";
        boolean IsSOTrx = "Y".equals(ctx.getContext(WindowNo, "IsSOTrx"));
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt(1));
                int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
                if (AD_Org_ID != ii) {
                    mTab.setValue("AD_Org_ID", (Object)ii);
                }
                ii = new Integer(rs.getInt(2));
                if (rs.wasNull()) {
                    ctx.setContext(WindowNo, 0, "M_Locator_ID", null);
                } else {
                    this.log.config("M_Locator_ID=" + ii);
                    ctx.setContext(WindowNo, "M_Locator_ID", ii.intValue());
                }
                if (!IsSOTrx && !IsDropShip) {
                    String name = rs.getString("Name");
                    mTab.setValue("DeliverTo", (Object)name);
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    if (C_Location_ID != 0) {
                        String phone = rs.getString("Phone");
                        String fax = rs.getString("Fax");
                        MLocation location = new MLocation(ctx, C_Location_ID, null);
                        String postal = location.getPostalConcated();
                        String address = location.getAddressConcated();
                        mTab.setValue("DeliverToPostal", (Object)postal);
                        mTab.setValue("DeliverToAddress", (Object)address);
                        mTab.setValue("DeliverToPhone", (Object)phone);
                        mTab.setValue("DeliverToFax", (Object)fax);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String orderLine(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer C_OrderLine_ID = (Integer)value;
        if (C_OrderLine_ID == null || C_OrderLine_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        MOrderLine ol = new MOrderLine(ctx, C_OrderLine_ID, null);
        if (ol.get_ID() != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(ol.getM_Product_ID()));
            if (ol.getM_AttributeSetInstance_ID() != 0) {
                mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ol.getM_AttributeSetInstance_ID()));
            }
            mTab.setValue("C_UOM_ID", (Object)new Integer(ol.getC_UOM_ID()));
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            BigDecimal shippingQty = MInOutLine.getShippingQty(ctx, C_OrderLine_ID, null);
            MovementQty = MovementQty.subtract(shippingQty);
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, 4);
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            if (ol.getC_Activity_ID() != 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(ol.getC_Activity_ID()));
            }
            if (ol.getC_Campaign_ID() != 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(ol.getC_Campaign_ID()));
            }
            if (ol.getC_Project_ID() != 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(ol.getC_Project_ID()));
            }
            if (ol.getC_ProjectPhase_ID() != 0) {
                mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(ol.getC_ProjectPhase_ID()));
            }
            if (ol.getC_ProjectTask_ID() != 0) {
                mTab.setValue("C_ProjectTask_ID", (Object)new Integer(ol.getC_ProjectTask_ID()));
            }
            if (ol.getAD_OrgTrx_ID() != 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(ol.getAD_OrgTrx_ID()));
            }
            if (ol.getUser1_ID() != 0) {
                mTab.setValue("User1_ID", (Object)new Integer(ol.getUser1_ID()));
            }
            if (ol.getUser2_ID() != 0) {
                mTab.setValue("User2_ID", (Object)new Integer(ol.getUser2_ID()));
            }
            if (ol.getParent().isReturnTrx()) {
                mTab.setValue("Orig_OrderLine_ID", (Object)new Integer(ol.getOrig_OrderLine_ID()));
                MInOutLine ioLine = new MInOutLine(ctx, ol.getOrig_InOutLine_ID(), null);
                mTab.setValue("M_Locator_ID", (Object)ioLine.getM_Locator_ID());
            }
            if (ol.getC_Currency_ID() != 0) {
                mTab.setValue("C_Currency_ID", (Object)new Integer(ol.getC_Currency_ID()));
            }
            if (ol.getC_Tax_ID() != 0) {
                mTab.setValue("C_Tax_ID", (Object)new Integer(ol.getC_Tax_ID()));
            }
            mTab.setValue("PriceEntered", (Object)ol.getPriceEntered());
            mTab.setValue("PriceActual", (Object)ol.getPriceActual());
            mTab.setValue("PriceCost", (Object)ol.getPriceCost());
            mTab.setValue("PriceLimit", (Object)ol.getPriceLimit());
            mTab.setValue("PriceList", (Object)ol.getPriceList());
            mTab.setValue("Discount", (Object)ol.getDiscount());
            if (ol.getPriceActual() != null) {
                BigDecimal lineNetAmt = MovementQty.multiply(ol.getPriceActual());
                mTab.setValue("LineNetAmt", (Object)lineNetAmt);
            } else {
                mTab.setValue("LineNetAmt", (Object)ol.getLineNetAmt());
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String pricelist(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_PriceList_ID = (Integer)value;
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        if (this.steps) {
            this.log.warning("init");
        }
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString(1))));
                ctx.setContext(WindowNo, "EnforcePriceLimit", rs.getString(2));
                Integer ii = new Integer(rs.getInt(3));
                mTab.setValue("C_Currency_ID", (Object)ii);
                ctx.setContext(WindowNo, "M_PriceList_Version_ID", rs.getInt(5));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Locator_ID = 0;
        if (ctx.getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID.intValue() && ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID")));
            M_Locator_ID = ctx.getContextAsInt(1113, 1113, "M_Locator_ID");
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            }
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("MovementQty");
        int AD_Client_ID = ctx.getContextAsInt(WindowNo, "AD_Client_ID");
        int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
        MProductPricing pp = new MProductPricing(AD_Client_ID, AD_Org_ID, M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp movementDate = (Timestamp)mTab.getValue("MovementDate");
        pp.setPriceDate(movementDate);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        ctx.setContext(WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        if (IsSOTrx) {
            CalloutInOut.setCalloutActive(false);
            return "";
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)new Integer(product.getC_UOM_ID()));
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        mTab.setValue("MovementQty", (Object)QtyEntered);
        if (M_Locator_ID == 0) {
            int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
            M_Locator_ID = MProductLocator.getFirstM_Locator_ID(product, M_Warehouse_ID);
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            } else {
                MWarehouse wh = MWarehouse.get((Ctx)ctx, (int)M_Warehouse_ID);
                mTab.setValue("M_Locator_ID", (Object)new Integer(wh.getDefaultM_Locator_ID()));
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String tax(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp orderDate = ctx.getContextAsDate(WindowNo, "DateOrdered");
        this.log.fine("Order Date=" + orderDate);
        Timestamp movementDate = ctx.getContextAsDate(WindowNo, "MovementDate");
        this.log.fine("Ship Date=" + movementDate);
        int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = ctx.getContextAsInt(WindowNo, "Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, orderDate, movementDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, "Y".equals(ctx.getContext(WindowNo, "IsSOTrx")));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        if (CalloutInOut.isCalloutActive() || value == null) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        if (this.steps) {
            this.log.warning("init");
        }
        int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        Timestamp MovementDate = ctx.getContextAsDate(WindowNo, "MovementDate");
        int StdPrecision = MPriceList.getPricePrecision(ctx, M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal MovementQty = (BigDecimal)mTab.getValue("MovementQty");
        this.log.fine("QtyEntered=" + QtyEntered + ", movement=" + MovementQty + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        if ((mField.getColumnName().equals("MovementQty") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(ctx.getContext(WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                MovementQty = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (MovementQty == null) {
                MovementQty = QtyEntered;
            }
            boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
            int AD_Client_ID = ctx.getContextAsInt(WindowNo, "AD_Client_ID");
            int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
            MProductPricing pp = new MProductPricing(AD_Client_ID, AD_Org_ID, M_Product_ID, C_BPartner_ID, MovementQty, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            pp.setPriceDate(MovementDate);
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("Discount", (Object)pp.getDiscount());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else {
            Discount = PriceList.intValue() == 0 ? Env.ZERO : new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
            mTab.setValue("Discount", (Object)Discount);
        }
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        String epl = ctx.getContext(WindowNo, "EnforcePriceLimit");
        boolean bl = enforce = ctx.isSOTrx(WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        } else {
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        if ((LineNetAmt = MovementQty.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String qty(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MInOutLine orig_IOLine;
        BigDecimal shippedQty;
        Integer orig_IOLine_ID;
        Integer oLine_ID;
        MOrderLine oLine;
        BigDecimal MovementQty;
        int C_UOM_To_ID;
        BigDecimal QtyEntered;
        if (CalloutInOut.isCalloutActive() || value == null) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (ctx.getContextAsInt(WindowNo, "C_UOM_ID") == 0) {
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            MovementQty = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal MovementQty1 = MovementQty.setScale(precision, 4);
            if (MovementQty.compareTo(MovementQty1) != 0) {
                this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                MovementQty = MovementQty1;
                mTab.setValue("MovementQty", (Object)MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));
        if (M_Product_ID != 0 && isReturnTrx && (oLine = new MOrderLine(ctx, oLine_ID = (Integer)mTab.getValue("C_OrderLine_ID"), null)).get_ID() != 0 && (orig_IOLine_ID = Integer.valueOf(oLine.getOrig_InOutLine_ID())) != 0 && (shippedQty = (orig_IOLine = new MInOutLine(ctx, orig_IOLine_ID, null)).getMovementQty()).compareTo(MovementQty = (BigDecimal)mTab.getValue("MovementQty")) < 0) {
            if (ctx.isSOTrx(WindowNo)) {
                mTab.fireDataStatusEEvent("QtyShippedLessThanQtyReturned", shippedQty.toString(), false);
            } else {
                mTab.fireDataStatusEEvent("QtyReceivedLessThanQtyReturned", shippedQty.toString(), false);
            }
            mTab.setValue("MovementQty", (Object)shippedQty);
            MovementQty = shippedQty;
            int C_UOM_To_ID2 = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID2, MovementQty);
            if (QtyEntered == null) {
                QtyEntered = MovementQty;
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("MovementQty", (Object)MovementQty);
            this.log.fine("QtyEntered : " + QtyEntered.toString() + "MovementQty : " + MovementQty.toString());
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String asi(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int selectedM_Locator_ID;
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_ASI_ID = (Integer)value;
        if (M_ASI_ID == null || M_ASI_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
        int M_Locator_ID = ctx.getContextAsInt(WindowNo, "M_Locator_ID");
        this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_ASI_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        int M_AttributeSetInstance_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_Locator_ID")) != 0) {
            this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            mTab.setValue("M_Locator_ID", (Object)new Integer(selectedM_Locator_ID));
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }
}

