/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class CalloutOrder
extends CalloutEngine {
    private boolean steps = false;

    public String docType(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean newDocNo;
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String oldDocNo = (String)mTab.getValue("DocumentNo");
        boolean bl = newDocNo = oldDocNo == null;
        if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
            newDocNo = true;
        }
        Integer oldC_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
        String sql = "SELECT d.DocSubTypeSO,d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext,s.CurrentNextSys,s.AD_Sequence_ID,d.IsSOTrx, d.IsReturnTrx FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        try {
            ResultSet rs;
            CPreparedStatement pstmt;
            int AD_Sequence_ID = 0;
            if (!newDocNo && oldC_DocType_ID != 0) {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, oldC_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    AD_Sequence_ID = rs.getInt(6);
                }
                rs.close();
                pstmt.close();
            }
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_DocType_ID);
            rs = pstmt.executeQuery();
            String DocSubTypeSO = "";
            boolean IsSOTrx = true;
            boolean isReturnTrx = false;
            if (rs.next()) {
                DocSubTypeSO = rs.getString(1);
                if (DocSubTypeSO == null) {
                    DocSubTypeSO = "--";
                }
                ctx.setContext(WindowNo, "OrderType", DocSubTypeSO);
                if (!DocSubTypeSO.equals("SO")) {
                    mTab.setValue("IsDropShip", (Object)"N");
                }
                if ("N".equals(rs.getString(8))) {
                    IsSOTrx = false;
                }
                if (!(isReturnTrx = "Y".equals(rs.getString(9)))) {
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("DeliveryRule", (Object)"F");
                    } else if (DocSubTypeSO.equals("PR")) {
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else {
                        mTab.setValue("DeliveryRule", (Object)"A");
                    }
                    if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR") || DocSubTypeSO.equals("WI")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else {
                        mTab.setValue("InvoiceRule", (Object)"D");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                    ctx.setContext(WindowNo, "HasCharges", rs.getString(2));
                } else if (DocSubTypeSO.equals("WR")) {
                    mTab.setValue("DeliveryRule", (Object)"F");
                } else {
                    mTab.setValue("DeliveryRule", (Object)"M");
                }
                if (rs.getString(4).equals("Y")) {
                    if (!newDocNo && AD_Sequence_ID != rs.getInt(7)) {
                        newDocNo = true;
                    }
                    if (newDocNo) {
                        if (Ini.isPropertyBool((String)"CompiereSys") && Env.getCtx().getAD_Client_ID() < 1000000) {
                            mTab.setValue("DocumentNo", (Object)("<" + rs.getString(6) + ">"));
                        } else {
                            mTab.setValue("DocumentNo", (Object)("<" + rs.getString(5) + ">"));
                        }
                    }
                }
            }
            rs.close();
            pstmt.close();
            if (isReturnTrx) {
                return "";
            }
            if (!DocSubTypeSO.equals("WR") && !DocSubTypeSO.equals("PR")) {
                sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                pstmt = DB.prepareStatement((String)sql, null);
                int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (IsSOTrx && (s.equals("B") || s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        if (!IsSOTrx && s.equals("B")) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString(3)) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                    if ((s = rs.getString(4)) != null && s.length() != 0) {
                        mTab.setValue("DeliveryRule", (Object)s);
                    }
                    if ((s = rs.getString(5)) != null && s.length() != 0) {
                        mTab.setValue("FreightCostRule", (Object)s);
                    }
                    if ((s = rs.getString(6)) != null && s.length() != 0) {
                        mTab.setValue("DeliveryViaRule", (Object)s);
                    }
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String bPartner(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
        if (isReturnTrx) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus, lbill.IsShipTo , p.Name, lship.C_Location_ID, lship.Phone, lship.Fax FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String s;
                double CreditLimit;
                String cont;
                String loc;
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = ctx.getContextAsInt("#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                mTab.setValue("Bill_BPartner_ID", (Object)C_BPartner_ID);
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (C_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (loc = ctx.getContext(1113, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    shipTo_ID = Integer.parseInt(loc);
                }
                if (shipTo_ID == 0) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                    if ("Y".equals(rs.getString("IsShipTo"))) {
                        mTab.setValue("Bill_Location_ID", (Object)new Integer(shipTo_ID));
                    }
                }
                mTab.setValue("Deliveryto_ID", (Object)C_BPartner_ID);
                if (shipTo_ID == 0) {
                    mTab.setValue("DeliveryToLoc_ID", null);
                } else {
                    mTab.setValue("DeliveryToLoc_ID", (Object)new Integer(shipTo_ID));
                }
                if (IsSOTrx && !IsDropShip) {
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String name = rs.getString("Name");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    mTab.setValue("DeliverTo", (Object)name);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                }
                int contID = rs.getInt("AD_User_ID");
                if (C_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (cont = ctx.getContext(1113, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                }
                if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = ctx.getContext(WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("DeliveryRule", (Object)"A");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                    mTab.setValue("DeliveryRule", (Object)"R");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryRule", (Object)s);
                    }
                    if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                        mTab.setValue("FreightCostRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryViaRule", (Object)s);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutOrder.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String bPartnerDeliverTo(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        String sql = "SELECT p.Name,  lship.C_Location_ID, lship.Phone, lship.Fax, lship.C_BPartner_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y')WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (shipTo_ID == 0) {
                    mTab.setValue("DeliveryToLoc_ID", null);
                } else {
                    mTab.setValue("DeliveryToLoc_ID", (Object)new Integer(shipTo_ID));
                }
                if (IsSOTrx && !IsDropShip || !IsSOTrx && IsDropShip) {
                    String name = rs.getString("Name");
                    mTab.setValue("DeliverTo", (Object)name);
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutOrder.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String bPartnerLocation(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutOrder.isCalloutActive()) {
            return "";
        }
        Integer C_BPartner_Location_ID = (Integer)value;
        if (C_BPartner_Location_ID == null || C_BPartner_Location_ID == 0) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        mTab.setValue("DeliverToLoc_ID", (Object)C_BPartner_Location_ID);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        if (IsSOTrx && !IsDropShip) {
            String sql = "SELECT C_Location_ID, Phone, Fax  FROM C_BPartner_Location WHERE C_BPartner_Location_ID=? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_Location_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliveryToLoc_ID", (Object)C_BPartner_Location_ID);
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                CalloutOrder.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
        }
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String bPartnerDeliverToLocation(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutOrder.isCalloutActive()) {
            return "";
        }
        Integer C_BPartner_Location_ID = (Integer)value;
        if (C_BPartner_Location_ID == null || C_BPartner_Location_ID == 0) {
            return "";
        }
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        if (IsSOTrx && !IsDropShip || !IsSOTrx && IsDropShip) {
            CalloutOrder.setCalloutActive(true);
            String sql = "SELECT C_Location_ID, Phone, Fax  FROM C_BPartner_Location WHERE C_BPartner_Location_ID=? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_Location_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    String phone = rs.getString("Phone");
                    String fax = rs.getString("Fax");
                    MLocation location = new MLocation(ctx, C_Location_ID, null);
                    String postal = location.getPostalConcated();
                    String address = location.getAddressConcated();
                    mTab.setValue("DeliverToPostal", (Object)postal);
                    mTab.setValue("DeliverToAddress", (Object)address);
                    mTab.setValue("DeliverToPhone", (Object)phone);
                    mTab.setValue("DeliverToFax", (Object)fax);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                CalloutOrder.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
            CalloutOrder.setCalloutActive(false);
        } else if (!IsSOTrx && !IsDropShip) {
            CalloutOrder.setCalloutActive(true);
            Integer M_Warehouse_ID = (Integer)mTab.getValue("M_Warehouse_ID");
            if (M_Warehouse_ID != null) {
                String sql = "SELECT o.Name, w.C_Location_ID, w.Phone, w.Fax  FROM M_Warehouse w, AD_Org o WHERE w.AD_ORG_ID=o.AD_ORG_ID AND w.M_Warehouse_ID=? ";
                try {
                    CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String name = rs.getString("Name");
                        mTab.setValue("DeliverTo", (Object)name);
                        int C_Location_ID = rs.getInt("C_Location_ID");
                        if (C_Location_ID != 0) {
                            String phone = rs.getString("Phone");
                            String fax = rs.getString("Phone");
                            MLocation location = new MLocation(ctx, C_Location_ID, null);
                            String postal = location.getPostalConcated();
                            String address = location.getAddressConcated();
                            mTab.setValue("DeliverToPostal", (Object)postal);
                            mTab.setValue("DeliverToAddress", (Object)address);
                            mTab.setValue("DeliverToPhone", (Object)phone);
                            mTab.setValue("DeliverToFax", (Object)fax);
                        }
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    CalloutOrder.setCalloutActive(false);
                    return e.getLocalizedMessage();
                }
            }
            CalloutOrder.setCalloutActive(false);
        }
        return "";
    }

    public String bPartnerBill(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutOrder.isCalloutActive()) {
            return "";
        }
        Integer bill_BPartner_ID = (Integer)value;
        if (bill_BPartner_ID == null || bill_BPartner_ID == 0) {
            return "";
        }
        boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
        if (isReturnTrx) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,c.AD_User_ID,p.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,lbill.C_BPartner_Location_ID AS Bill_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, bill_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                double CreditLimit;
                String cont;
                String loc;
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = ctx.getContextAsInt("#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (loc = ctx.getContext(1113, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    bill_Location_ID = Integer.parseInt(loc);
                }
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (bill_BPartner_ID.toString().equals(ctx.getContext(1113, 1113, "C_BPartner_ID")) && (cont = ctx.getContext(1113, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("Bill_User_ID", null);
                } else {
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                    }
                }
                String s = rs.getString("POReference");
                s = rs.getString("SO_Description");
                if (s != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = ctx.getContext(WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "bPartnerBill", (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String warehouse(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean IsSOTrx = ctx.isSOTrx(WindowNo);
        if (IsSOTrx) {
            return "";
        }
        if (CalloutOrder.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        boolean IsDropShip = "Y".equals(ctx.getContext(WindowNo, "IsDropShip"));
        if (!IsDropShip) {
            String sql = "SELECT o.Name, w.C_Location_ID, w.Phone, w.Fax  FROM M_Warehouse w, AD_Org o WHERE w.AD_ORG_ID=o.AD_ORG_ID AND w.M_Warehouse_ID=? ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Warehouse_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    String name = rs.getString("Name");
                    mTab.setValue("DeliverTo", (Object)name);
                    int C_Location_ID = rs.getInt("C_Location_ID");
                    if (C_Location_ID != 0) {
                        String phone = rs.getString("Phone");
                        String fax = rs.getString("Phone");
                        MLocation location = new MLocation(ctx, C_Location_ID, null);
                        String postal = location.getPostalConcated();
                        String address = location.getAddressConcated();
                        mTab.setValue("DeliverToPostal", (Object)postal);
                        mTab.setValue("DeliverToAddress", (Object)address);
                        mTab.setValue("DeliverToPhone", (Object)phone);
                        mTab.setValue("DeliverToFax", (Object)fax);
                    }
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                CalloutOrder.setCalloutActive(false);
                return e.getLocalizedMessage();
            }
        }
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String priceList(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_PriceList_ID = (Integer)value;
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString(1))));
                ctx.setContext(WindowNo, "EnforcePriceLimit", rs.getString(2));
                Integer ii = new Integer(rs.getInt(3));
                mTab.setValue("C_Currency_ID", (Object)ii);
                ctx.setContext(WindowNo, "M_PriceList_Version_ID", rs.getInt(5));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return "";
    }

    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));
        if (isReturnTrx) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        if (this.steps) {
            this.log.warning("init");
        }
        mTab.setValue("C_Charge_ID", null);
        if (ctx.getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID.intValue() && ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID")));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
        MProductPricing pp = new MProductPricing(ctx.getAD_Client_ID(), ctx.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        pp.setPriceDate(orderDate);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        mTab.setValue("QtyOrdered", mTab.getValue("QtyEntered"));
        ctx.setContext(WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        if (ctx.isSOTrx(WindowNo) && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
            int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
            int M_AttributeSetInstance_ID = ctx.getContextAsInt(WindowNo, "M_AttributeSetInstance_ID");
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Ctx)ctx, (String)("@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        CalloutOrder.setCalloutActive(false);
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        boolean isReturnTrx = "Y".equals(ctx.getContext("IsReturnTrx"));
        if (isReturnTrx) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        ctx.setContext(WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceLimit", (Object)Env.ZERO);
                mTab.setValue("PriceList", (Object)Env.ZERO);
                mTab.setValue("Discount", (Object)Env.ZERO);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? ((Integer)value).intValue() : ctx.getContextAsInt(WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp billDate = new Timestamp(ctx.getContextAsTime(WindowNo, "DateOrdered"));
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = new Timestamp(ctx.getContextAsTime(WindowNo, "DatePromised"));
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = ctx.getContextAsInt(WindowNo, "Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, "Y".equals(ctx.getContext(WindowNo, "IsSOTrx")));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        if (CalloutOrder.isCalloutActive() || value == null) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        if (this.steps) {
            this.log.warning("init");
        }
        int C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int M_PriceList_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getPricePrecision(ctx, M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        this.log.fine("QtyEntered=" + QtyEntered + ", Ordered=" + QtyOrdered + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(ctx.getContext(WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyOrdered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyOrdered == null) {
                QtyOrdered = QtyEntered;
            }
            boolean IsSOTrx = ctx.getContext(WindowNo, "IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(ctx.getAD_Client_ID(), ctx.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("Discount", (Object)pp.getDiscount());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            ctx.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else {
            Discount = PriceList.intValue() == 0 ? Env.ZERO : new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
            mTab.setValue("Discount", (Object)Discount);
        }
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        String epl = ctx.getContext(WindowNo, "EnforcePriceLimit");
        boolean enforce = ctx.isSOTrx(WindowNo) && epl != null && epl.equals("Y");
        boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));
        if (enforce && (MRole.getDefault().isOverwritePriceLimit() || isReturnTrx)) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String qty(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        MInOutLine inOutLine;
        BigDecimal shippedQty;
        Integer inOutLine_ID;
        int C_UOM_To_ID;
        if (CalloutOrder.isCalloutActive() || value == null) {
            return "";
        }
        CalloutOrder.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + M_Product_ID + " - ");
        }
        BigDecimal QtyOrdered = Env.ZERO;
        BigDecimal QtyEntered = Env.ZERO;
        boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));
        if (M_Product_ID == 0) {
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && isReturnTrx && (inOutLine_ID = (Integer)mTab.getValue("Orig_InOutLine_ID")) != 0 && (shippedQty = (inOutLine = new MInOutLine(ctx, inOutLine_ID, null)).getMovementQty()).compareTo(QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered")) < 0) {
            if (ctx.isSOTrx(WindowNo)) {
                mTab.fireDataStatusEEvent("QtyShippedLessThanQtyReturned", shippedQty.toString(), false);
            } else {
                mTab.fireDataStatusEEvent("QtyReceivedLessThanQtyReturned", shippedQty.toString(), false);
            }
            mTab.setValue("QtyOrdered", (Object)shippedQty);
            QtyOrdered = shippedQty;
            int C_UOM_To_ID2 = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID2, QtyOrdered);
            if (QtyEntered == null) {
                QtyEntered = QtyOrdered;
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            this.log.fine("QtyEntered : " + QtyEntered.toString() + "QtyOrdered : " + QtyOrdered.toString());
        }
        if (M_Product_ID != 0 && ctx.isSOTrx(WindowNo) && QtyOrdered.signum() > 0 && !isReturnTrx && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            int M_AttributeSetInstance_ID;
            int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = ctx.getContextAsInt(WindowNo, "M_AttributeSetInstance_ID"), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Ctx)ctx, (String)("@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        CalloutOrder.setCalloutActive(false);
        return "";
    }

    public String Orig_Order(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        MOrder order = new MOrder(ctx, C_Order_ID, null);
        MBPartner bpartner = new MBPartner(ctx, order.getC_BPartner_ID(), null);
        mTab.setValue("Orig_InOut_ID", null);
        mTab.setValue("C_BPartner_ID", (Object)order.getC_BPartner_ID());
        mTab.setValue("C_BPartner_Location_ID", (Object)order.getC_BPartner_Location_ID());
        mTab.setValue("Bill_BPartner_ID", (Object)order.getBill_BPartner_ID());
        mTab.setValue("Bill_Location_ID", (Object)order.getBill_Location_ID());
        if (order.getAD_User_ID() != 0) {
            mTab.setValue("AD_User_ID", (Object)order.getAD_User_ID());
        }
        if (order.getBill_User_ID() != 0) {
            mTab.setValue("Bill_User_ID", (Object)order.getBill_User_ID());
        }
        if (ctx.isSOTrx(WindowNo)) {
            mTab.setValue("M_ReturnPolicy_ID", (Object)bpartner.getM_ReturnPolicy_ID());
        } else {
            mTab.setValue("M_ReturnPolicy_ID", (Object)bpartner.getPO_ReturnPolicy_ID());
        }
        mTab.setValue("M_PriceList_ID", (Object)order.getM_PriceList_ID());
        mTab.setValue("PaymentRule", (Object)order.getPaymentRule());
        mTab.setValue("C_PaymentTerm_ID", (Object)order.getC_PaymentTerm_ID());
        mTab.setValue("Bill_Location_ID", (Object)order.getBill_Location_ID());
        mTab.setValue("InvoiceRule", (Object)order.getInvoiceRule());
        mTab.setValue("PaymentRule", (Object)order.getPaymentRule());
        mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
        mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
        return "";
    }

    public String Orig_InOut(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer Orig_InOut_ID = (Integer)value;
        if (Orig_InOut_ID == null || Orig_InOut_ID == 0) {
            return "";
        }
        MInOut io = new MInOut(ctx, (int)Orig_InOut_ID, null);
        mTab.setValue("C_Project_ID", (Object)io.getC_Project_ID());
        mTab.setValue("C_Campaign_ID", (Object)io.getC_Campaign_ID());
        mTab.setValue("C_Activity_ID", (Object)io.getC_Activity_ID());
        mTab.setValue("AD_OrgTrx_ID", (Object)io.getAD_OrgTrx_ID());
        mTab.setValue("User1_ID", (Object)io.getUser1_ID());
        mTab.setValue("User2_ID", (Object)io.getUser2_ID());
        return "";
    }

    public String Orig_OrderLine(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer Orig_OrderLine_ID = (Integer)value;
        if (Orig_OrderLine_ID == null || Orig_OrderLine_ID == 0) {
            return "";
        }
        MOrderLine orderline = new MOrderLine(ctx, Orig_OrderLine_ID, null);
        mTab.setValue("Orig_InOutLine_ID", null);
        mTab.setValue("C_Tax_ID", (Object)orderline.getC_Tax_ID());
        mTab.setValue("PriceList", (Object)orderline.getPriceList());
        mTab.setValue("PriceLimit", (Object)orderline.getPriceLimit());
        mTab.setValue("PriceActual", (Object)orderline.getPriceActual());
        mTab.setValue("PriceEntered", (Object)orderline.getPriceEntered());
        mTab.setValue("C_Currency_ID", (Object)orderline.getC_Currency_ID());
        mTab.setValue("Discount", (Object)orderline.getDiscount());
        mTab.setValue("Discount", (Object)orderline.getDiscount());
        return "";
    }

    public String Orig_InOutLine(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer Orig_InOutLine_ID = (Integer)value;
        if (Orig_InOutLine_ID == null || Orig_InOutLine_ID == 0) {
            return "";
        }
        MInOutLine Orig_InOutLine = new MInOutLine(ctx, Orig_InOutLine_ID, null);
        if (Orig_InOutLine != null && Orig_InOutLine.get_ID() != 0) {
            mTab.setValue("C_Project_ID", (Object)Orig_InOutLine.getC_Project_ID());
            mTab.setValue("C_Campaign_ID", (Object)Orig_InOutLine.getC_Campaign_ID());
            mTab.setValue("M_Product_ID", (Object)Orig_InOutLine.getM_Product_ID());
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Orig_InOutLine.getM_AttributeSetInstance_ID());
            mTab.setValue("C_UOM_ID", (Object)Orig_InOutLine.getC_UOM_ID());
        }
        return "";
    }
}

