/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutPaySelection
extends CalloutEngine {
    public String payAmt(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutPaySelection.isCalloutActive() || value == null) {
            return "";
        }
        Integer ii = (Integer)mTab.getValue("C_Invoice_ID");
        if (ii == null) {
            return "";
        }
        int C_Invoice_ID = ii;
        if (C_Invoice_ID == 0) {
            return "";
        }
        BigDecimal OpenAmt = (BigDecimal)mTab.getValue("OpenAmt");
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("PayAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        CalloutPaySelection.setCalloutActive(true);
        BigDecimal DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt);
        this.log.fine(" - OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", Difference=" + DifferenceAmt);
        mTab.setValue("DifferenceAmt", (Object)DifferenceAmt);
        CalloutPaySelection.setCalloutActive(false);
        return "";
    }

    public String invoice(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutPaySelection.isCalloutActive() || value == null) {
            return "";
        }
        int C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == 0) {
            return "";
        }
        int C_BankAccount_ID = ctx.getContextAsInt(WindowNo, "C_BankAccount_ID");
        Timestamp PayDate = new Timestamp(ctx.getContextAsTime("PayDate"));
        CalloutPaySelection.setCalloutActive(true);
        BigDecimal OpenAmt = Env.ZERO;
        BigDecimal DiscountAmt = Env.ZERO;
        Boolean IsSOTrx = Boolean.FALSE;
        String sql = "SELECT currencyConvert(invoiceOpen(i.C_Invoice_ID, 0), i.C_Currency_ID,ba.C_Currency_ID, i.DateInvoiced, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID), paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?), i.IsSOTrx FROM C_Invoice_v i, C_BankAccount ba WHERE i.C_Invoice_ID=? AND ba.C_BankAccount_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, PayDate);
            pstmt.setInt(2, C_Invoice_ID);
            pstmt.setInt(3, C_BankAccount_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                OpenAmt = rs.getBigDecimal(1);
                DiscountAmt = rs.getBigDecimal(2);
                IsSOTrx = new Boolean("Y".equals(rs.getString(3)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine(" - OpenAmt=" + OpenAmt + " (Invoice=" + C_Invoice_ID + ",BankAcct=" + C_BankAccount_ID + ")");
        mTab.setValue("OpenAmt", (Object)OpenAmt);
        mTab.setValue("PayAmt", (Object)OpenAmt.subtract(DiscountAmt));
        mTab.setValue("DiscountAmt", (Object)DiscountAmt);
        mTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        mTab.setValue("IsSOTrx", (Object)IsSOTrx);
        CalloutPaySelection.setCalloutActive(false);
        return "";
    }
}

