/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.swing.Icon;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.h3;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.controller.GridTabVO;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MColor;
import org.compiere.model.MImage;
import org.compiere.model.MSession;
import org.compiere.plaf.CompiereColor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;

public class GridWindow
implements Serializable {
    private GridWindowVO m_vo;
    private ArrayList<GridTab> m_tabs = new ArrayList();
    private Timestamp m_modelUpdated = null;
    private static CLogger log = CLogger.getCLogger(GridWindow.class);

    public static GridWindow get(Ctx ctx, int WindowNo, int AD_Window_ID) {
        log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        GridWindowVO mWindowVO = GridWindowVO.create((Ctx)ctx, (int)WindowNo, (int)AD_Window_ID);
        if (mWindowVO == null) {
            return null;
        }
        return new GridWindow(mWindowVO);
    }

    public GridWindow(GridWindowVO vo) {
        this.m_vo = vo;
        if (this.loadTabData()) {
            this.enableEvents();
        }
    }

    public void dispose() {
        log.info("AD_Window_ID=" + this.m_vo.AD_Window_ID);
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).dispose();
        }
        this.m_tabs.clear();
        this.m_tabs = null;
    }

    public void loadCompete() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).getMTable().loadComplete();
        }
    }

    private boolean loadTabData() {
        log.config("");
        if (this.m_vo.Tabs == null) {
            return false;
        }
        for (int t = 0; t < this.m_vo.Tabs.size(); ++t) {
            ArrayList<String> parents;
            GridTabVO mTabVO = (GridTabVO)this.m_vo.Tabs.get(t);
            if (mTabVO == null) continue;
            int onlyCurrentDays = 0;
            if (t == 0 && this.isTransaction()) {
                onlyCurrentDays = 1;
            }
            GridTab mTab = new GridTab(mTabVO, onlyCurrentDays);
            mTabVO.ctx.setContext(mTabVO.WindowNo, mTabVO.TabNo, "KeyColumnName", mTab.getKeyColumnName());
            if (mTab.getLinkColumnName().length() == 0 && (parents = mTab.getParentColumnNames()).size() != 0) {
                if (parents.size() == 1) {
                    mTab.setLinkColumnName(parents.get(0));
                } else {
                    block1: for (int i = 0; i < this.m_tabs.size(); ++i) {
                        GridTab tab = this.m_tabs.get(i);
                        String tabKey = tab.getKeyColumnName();
                        block2: for (int j = 0; j < parents.size(); ++j) {
                            String parent = parents.get(j);
                            if (parent.equals(tabKey)) {
                                mTab.setLinkColumnName(parent);
                                continue block1;
                            }
                            if (!tabKey.equals("")) continue;
                            for (int k = 0; k < tab.getParentColumnNames().size(); ++k) {
                                if (!parent.equals(tab.getParentColumnNames().get(k))) continue;
                                mTab.setLinkColumnName(parent);
                                continue block2;
                            }
                        }
                    }
                }
            }
            mTab.setLinkColumnName(null);
            this.m_tabs.add(mTab);
        }
        this.logAccess();
        return true;
    }

    private void logAccess() {
        MSession session = MSession.get((Ctx)this.m_vo.ctx, (boolean)true);
        session.windowLog(this.m_vo.ctx.getAD_Client_ID(), this.m_vo.ctx.getAD_Org_ID(), this.getAD_Window_ID(), 0);
    }

    public Image getImage() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(this.m_vo.ctx, this.m_vo.AD_Image_ID);
        return mImage.getImage();
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(this.m_vo.ctx, this.m_vo.AD_Image_ID);
        return mImage.getIcon();
    }

    public CompiereColor getColor() {
        if (this.m_vo.AD_Color_ID == 0) {
            return null;
        }
        MColor mc = new MColor(this.m_vo.ctx, this.m_vo.AD_Color_ID, null);
        return mc.getCompiereColor();
    }

    public boolean isSOTrx() {
        return this.m_vo.IsSOTrx;
    }

    public void query() {
        log.info("");
        GridTab tab = this.getTab(0);
        tab.query(0, 0, false);
        if (tab.getRowCount() > 0) {
            tab.navigate(0);
        }
    }

    private void enableEvents() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).enableEvents();
        }
    }

    public int getTabCount() {
        return this.m_tabs.size();
    }

    public GridTab getTab(int i) {
        if (i < 0 || i + 1 > this.m_tabs.size()) {
            return null;
        }
        return this.m_tabs.get(i);
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public String getWindowType() {
        return this.m_vo.WindowType;
    }

    public boolean isTransaction() {
        return this.m_vo.WindowType.equals("T");
    }

    public Dimension getWindowSize() {
        if (this.m_vo.WinWidth != 0 && this.m_vo.WinHeight != 0) {
            return new Dimension(this.m_vo.WinWidth, this.m_vo.WinHeight);
        }
        return null;
    }

    public String toString() {
        return "MWindow[" + this.m_vo.WindowNo + "," + this.m_vo.Name + " (" + this.m_vo.AD_Window_ID + ")]";
    }

    public WebDoc getHelpDoc(boolean javaClient) {
        return this.getHelpDoc(javaClient, null);
    }

    public WebDoc getHelpDoc(boolean javaClient, HttpServletRequest request) {
        int i;
        String title = Msg.getMsg((Ctx)this.m_vo.ctx, (String)"Window") + ": " + this.getName();
        WebDoc doc = null;
        if (javaClient) {
            doc = WebDoc.create(false, title, javaClient);
        } else {
            if (request != null) {
                request.setAttribute("BODY_ID", (Object)"popup");
                doc = WebDoc.createPopup(title, request);
            } else {
                doc = WebDoc.createPopup(title);
            }
            doc.addPopupClose();
        }
        td tdCenter = doc.addTd();
        div center = (div)new div().setID("body");
        tdCenter.addElement((Element)center);
        div msgDiv = (div)new div().setClass("topMsgLeft");
        center.addElement((Element)msgDiv);
        if (this.getDescription().length() != 0) {
            msgDiv.addElement((Element)new p().addElement(this.getDescription()));
        }
        if (this.getHelp().length() != 0) {
            msgDiv.addElement((Element)new p().addElement(this.getHelp()));
        }
        int size = this.getTabCount();
        p p2 = new p();
        for (i = 0; i < size; ++i) {
            GridTab tab = this.getTab(i);
            if (i > 0) {
                p2.addElement(" - ");
            }
            p2.addElement((Element)new a("#Tab" + i).addElement(tab.getName()));
        }
        msgDiv.addElement((Element)p2).addElement((Element)new p().addElement("&nbsp;"));
        for (i = 0; i < size; ++i) {
            String hdr;
            GridField field;
            int j;
            div tableDiv = (div)new div().setClass("help");
            table table2 = new table();
            tableDiv.addElement((Element)table2);
            GridTab tab = this.getTab(i);
            div alignLeftDiv = (div)new div().setClass("align-left");
            tr tr2 = new tr().addElement((Element)new th().addElement((Element)new a().setName("Tab" + i).addElement((Element)alignLeftDiv.addElement((Element)new h2(Msg.getMsg((Ctx)this.m_vo.ctx, (String)"Tab") + ": " + tab.getName())))));
            if (tab.getDescription().length() != 0) {
                tr2.addElement((Element)new th().addElement((Element)new div().addElement(tab.getDescription())));
            } else {
                tr2.addElement((Element)new th().addElement((Element)new div().addElement("&nbsp;")));
            }
            table2.addElement((Element)tr2);
            td td2 = new td().setColSpan(2);
            if (tab.getHelp().length() != 0) {
                td2.addElement((Element)new p().addElement(tab.getHelp()));
            }
            p2 = new p();
            for (j = 0; j < tab.getFieldCount(); ++j) {
                field = tab.getField(j);
                hdr = field.getHeader();
                if (hdr == null || hdr.length() <= 0) continue;
                if (j > 0) {
                    p2.addElement(" - ");
                }
                p2.addElement((Element)new a("#Field" + i + j, hdr));
            }
            td2.addElement((Element)p2);
            table2.addElement((Element)new tr().addElement((Element)td2));
            for (j = 0; j < tab.getFieldCount(); ++j) {
                field = tab.getField(j);
                hdr = field.getHeader();
                if (hdr == null || hdr.length() <= 0) continue;
                td2 = new td().setColSpan(2).addElement((Element)new a().setName("Field" + i + j).addElement((Element)new h3(Msg.getMsg((Ctx)this.m_vo.ctx, (String)"Field") + ": " + hdr)));
                if (field.getDescription().length() != 0) {
                    td2.addElement(field.getDescription());
                }
                if (field.getHelp().length() != 0) {
                    td2.addElement((Element)new p().addElement(field.getHelp()));
                }
                table2.addElement((Element)new tr().addElement((Element)td2));
            }
            center.addElement((Element)tableDiv);
        }
        if (!javaClient) {
            doc.addPopupClose();
        }
        return doc;
    }

    public Timestamp getModelUpdated(boolean recalc) {
        if (recalc || this.m_modelUpdated == null) {
            String sql = "SELECT MAX(w.Updated), MAX(t.Updated), MAX(tt.Updated), MAX(f.Updated), MAX(c.Updated) FROM AD_Window w INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) INNER JOIN AD_Field f ON (t.AD_Tab_ID=f.AD_Tab_ID) INNER JOIN AD_Column c ON (f.AD_Column_ID=c.AD_Column_ID) WHERE w.AD_Window_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.getAD_Window_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_modelUpdated = rs.getTimestamp(1);
                    Timestamp ts = rs.getTimestamp(2);
                    if (ts.after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(3)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(4)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(5)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
        return this.m_modelUpdated;
    }
}

