/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_C_BP_Group;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBPGroup
extends X_C_BP_Group {
    private static CCache<Integer, MBPGroup> s_cache = new CCache("BP_Group", 10);
    private static CCache<Integer, MBPGroup> s_cacheDefault = new CCache("BP_Group", 5);
    private static CLogger s_log = CLogger.getCLogger(MBPGroup.class);

    public static MBPGroup get(Ctx ctx, int C_BP_Group_ID) {
        Integer key = new Integer(C_BP_Group_ID);
        MBPGroup retValue = (MBPGroup)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBPGroup(ctx, C_BP_Group_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MBPGroup getDefault(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        Integer key = new Integer(AD_Client_ID);
        MBPGroup retValue = (MBPGroup)((Object)s_cacheDefault.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM C_BP_Group g WHERE IsDefault='Y' AND AD_Client_ID=? ORDER BY IsActive DESC";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && (retValue = new MBPGroup(ctx, rs, null)).get_ID() != 0) {
                s_cacheDefault.put((Object)key, (Object)retValue);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.warning("No Default BP Group for AD_Client_ID=" + AD_Client_ID);
        }
        return retValue;
    }

    public static MBPGroup getOfBPartner(Ctx ctx, int C_BPartner_ID) {
        MBPGroup retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM C_BP_Group g WHERE EXISTS (SELECT * FROM C_BPartner p WHERE p.C_BPartner_ID=? AND p.C_BP_Group_ID=g.C_BP_Group_ID)";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MBPGroup(ctx, rs, null);
                Integer key = new Integer(retValue.getC_BP_Group_ID());
                if (retValue.get_ID() != 0) {
                    s_cache.put((Object)key, (Object)retValue);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MBPGroup(Ctx ctx, int C_BP_Group_ID, String trxName) {
        super(ctx, C_BP_Group_ID, trxName);
        if (C_BP_Group_ID == 0) {
            this.setIsConfidentialInfo(false);
            this.setIsDefault(false);
            this.setPriorityBase("S");
        }
    }

    public MBPGroup(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public BigDecimal getCreditWatchPercent() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd != null) {
            return bd;
        }
        return new BigDecimal(90);
    }

    public BigDecimal getCreditWatchRatio() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd != null) {
            return bd.divide(Env.ONEHUNDRED, 2, 4);
        }
        return new BigDecimal(0.9);
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            return this.insert_Accounting("C_BP_Group_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_BP_Group_Acct");
    }
}

