/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MClientInfo;
import org.compiere.model.MLocation;
import org.compiere.model.X_C_Bank;
import org.compiere.util.BankVerificationInterface;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MBank
extends X_C_Bank {
    private static CCache<Integer, MBank> s_cache = new CCache("C_Bank", 3);
    private static CLogger s_log = CLogger.getCLogger(MBPBankAccount.class);
    private BankVerificationInterface m_verify = null;
    private boolean m_verifySearched = false;
    private MLocation m_loc = null;

    public static MBank get(Ctx ctx, int C_Bank_ID) {
        Integer key = new Integer(C_Bank_ID);
        MBank retValue = (MBank)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBank(ctx, C_Bank_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MBank(Ctx ctx, int C_Bank_ID, String trxName) {
        super(ctx, C_Bank_ID, trxName);
    }

    public static MBank[] getByRoutingNo(Ctx ctx, String routingNo) {
        String sql = "SELECT * FROM C_Bank WHERE RoutingNo LIKE ? AND IsActive='Y'";
        ArrayList<MBank> list = new ArrayList<MBank>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, routingNo);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBank(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBank[] retValue = new MBank[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBank(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected BankVerificationInterface getVerificationClass() {
        if (this.m_verify == null && !this.m_verifySearched) {
            String className = this.getBankVerificationClass();
            if (className == null || className.length() == 0) {
                className = MClientInfo.get((Ctx)this.getCtx(), (int)this.getAD_Client_ID()).getBankVerificationClass();
            }
            if (className != null && className.length() > 0) {
                try {
                    Class<?> clazz = Class.forName(className);
                    this.m_verify = (BankVerificationInterface)clazz.newInstance();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, className, (Throwable)e);
                }
            }
            this.m_verifySearched = true;
        }
        return this.m_verify;
    }

    public int getC_Country_ID() {
        if (this.m_loc == null) {
            this.m_loc = MLocation.get((Ctx)this.getCtx(), (int)this.getC_Location_ID(), null);
        }
        if (this.m_loc == null) {
            return 0;
        }
        return this.m_loc.getC_Country_ID();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBank[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        BankVerificationInterface verify = this.getVerificationClass();
        if (verify != null) {
            String errorMsg = verify.verifyRoutingNo(this.getC_Country_ID(), this.getRoutingNo());
            if (errorMsg != null) {
                this.log.saveError("Error", "@Invalid@ @RoutingNo@ " + errorMsg);
                return false;
            }
            errorMsg = verify.verifySwiftCode(this.getSwiftCode());
            if (errorMsg != null) {
                this.log.saveError("Error", "@Invalid@ @SwiftCode@ " + errorMsg);
                return false;
            }
        }
        return true;
    }
}

