/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.X_C_BankStatementCharge;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MBankStatementCharge
extends X_C_BankStatementCharge {
    public MBankStatementCharge(Ctx ctx, int C_BankStatementCharge_ID, String trxName) {
        super(ctx, C_BankStatementCharge_ID, trxName);
    }

    public MBankStatementCharge(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatementCharge(MBankStatementLine statementLine) {
        this(statementLine.getCtx(), 0, statementLine.get_TrxName());
        this.setC_BankStatement_ID(statementLine.getC_BankStatement_ID());
        this.setC_BankStatementLine_ID(statementLine.getC_BankStatementLine_ID());
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_BankStatementCharge WHERE C_BankStatementLine_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_BankStatementLine_ID());
            this.setLine(ii);
        }
        BigDecimal chargeAmt = this.getChargeAmt();
        Ctx ctx = this.getCtx();
        MCharge charge = MCharge.get(ctx, this.getC_Charge_ID());
        this.setIsTaxIncluded(charge.isTaxIncluded());
        MTax tax = MTax.get(ctx, this.getC_Tax_ID());
        MBPartner bartner = MBPartner.get(ctx, this.getC_BPartner_ID());
        MBankStatementLine bsl = new MBankStatementLine(ctx, this.getC_BankStatementLine_ID(), this.get_TrxName());
        MCurrency currency = MCurrency.get((Ctx)ctx, (int)bsl.getC_Currency_ID());
        boolean taxIncluded = this.isTaxIncluded();
        BigDecimal taxAmt = tax.calculateTax(chargeAmt, taxIncluded, currency.getStdPrecision(), bartner.getTaxRoundModeAsInt());
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTotalAmt(chargeAmt);
        } else {
            this.setTotalAmt(chargeAmt.add(taxAmt));
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateChargeAmt();
        MBankStatementLine bsl = new MBankStatementLine(this.getCtx(), this.getC_BankStatementLine_ID(), this.get_TrxName());
        this.updateTrxAmt(bsl);
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.updateChargeAmt();
        MBankStatementLine bsl = new MBankStatementLine(this.getCtx(), this.getC_BankStatementLine_ID(), this.get_TrxName());
        this.updateTrxAmt(bsl);
        return success;
    }

    private void updateChargeAmt() {
        String sql = "UPDATE C_BankStatementLine bsl SET ChargeAmt=(SELECT NVL(SUM(TotalAmt),0) FROM C_BankStatementCharge bsc WHERE bsc.C_BankStatementLine_ID = " + this.getC_BankStatementLine_ID() + ") " + "WHERE bsl.C_BankStatementLine_ID = " + this.getC_BankStatementLine_ID() + " ";
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }

    private void updateTrxAmt(MBankStatementLine bsl) {
        if (bsl.getC_Payment_ID() == 0) {
            bsl.setTrxAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getInterestAmt()));
        } else {
            MPayment payment = new MPayment(this.getCtx(), bsl.getC_Payment_ID(), this.get_TrxName());
            if (!payment.isProcessed()) {
                bsl.setTrxAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getInterestAmt()));
                payment.setPayAmt(bsl.getTrxAmt().abs());
                payment.save();
            } else {
                bsl.setInterestAmt(bsl.getStmtAmt().subtract(bsl.getChargeAmt()).subtract(bsl.getTrxAmt()));
            }
        }
        bsl.save();
    }
}

