/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBillingLine;
import org.compiere.model.MBillingTax;
import org.compiere.model.MCashBook;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MRefList;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.X_C_Billing;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MBilling
extends X_C_Billing
implements DocAction {
    private static CCache<Integer, MBilling> s_cache = new CCache("C_Billing", 20, 2);
    private MBillingLine[] m_lines;
    private MBillingTax[] m_taxes;
    private static CLogger s_log = CLogger.getCLogger(MBilling.class);
    private boolean m_reversal = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MBilling[] getOfBPartner(Ctx ctx, int C_BPartner_ID, String trxName) {
        ArrayList<MBilling> list = new ArrayList<MBilling>();
        String sql = "SELECT * FROM C_Billing WHERE C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBilling(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBilling[] retValue = new MBilling[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static String getPDFFileName(String documentDir, int C_Billing_ID) {
        StringBuffer sb = new StringBuffer(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("C_Billing_ID_").append(C_Billing_ID).append(".pdf");
        return sb.toString();
    }

    public static MBilling get(Ctx ctx, int C_Billing_ID) {
        Integer key = new Integer(C_Billing_ID);
        MBilling retValue = (MBilling)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBilling(ctx, C_Billing_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MBilling(Ctx ctx, int C_Billing_ID, String trxName) {
        super(ctx, C_Billing_ID, trxName);
        if (C_Billing_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPaymentRule("P");
            this.setDateBilling(new Timestamp(System.currentTimeMillis()));
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setIsDiscountPrinted(false);
            this.setIsPaid(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsPayScheduleValid(false);
            this.setIsInDispute(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MBilling(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBilling(MBPartner partner, MInvoice invoice, int C_DocTypeTarget_ID, Timestamp billingDate) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        int C_BPartner_ID;
        this.setClientOrg((PO)invoice);
        this.setInvoice(invoice);
        if (C_DocTypeTarget_ID == 0) {
            C_DocTypeTarget_ID = DB.getSQLValue(null, (String)("SELECT MIN(C_DOCTYPE_ID) FROM C_DOCTYPE WHERE ISACTIVE='Y' AND DOCBASETYPE IN ('BRI', 'BPI') AND ISSOTRX='" + (invoice.isSOTrx() ? (char)'Y' : 'N') + "'"));
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        this.setIsSOTrx(invoice.isSOTrx());
        if (billingDate != null) {
            this.setDateBilling(billingDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(invoice.getSalesRep_ID());
        int C_Invoice_Partner_ID = C_BPartner_ID = invoice.getC_BPartner_ID();
        MBPartner invoicepartner = MBPartner.get(this.getCtx(), C_Invoice_Partner_ID);
        invoicepartner.getPrimaryC_BPartner_Location_ID();
        this.setC_BPartner_ID(C_Invoice_Partner_ID);
        this.setC_BPartner_Location_ID(invoicepartner.getPrimaryC_BPartner_Location_ID());
        this.setAD_User_ID(invoicepartner.getPrimaryAD_User_ID());
        if (invoice.isSOTrx()) {
            MBilling lastBilling = MBilling.getLastBilling(this.getCtx(), C_Invoice_Partner_ID, billingDate, invoice.get_TrxName());
            BigDecimal lastInvoicedAmt = BigDecimal.ZERO;
            Timestamp lastDateBilling = this.getDateBilling();
            if (lastBilling != null) {
                lastInvoicedAmt = lastBilling.getTotalInvoiceAmt();
                this.setLastInvoicedAmt(lastBilling.getTotalInvoiceAmt());
            } else {
                Calendar lastBillingCal = TimeUtil.getToday();
                if (lastBillingCal != null) {
                    lastBillingCal.setTimeInMillis(this.getDateBilling().getTime());
                    lastBillingCal.set(14, 0);
                    lastBillingCal.set(13, 0);
                    lastBillingCal.set(12, 0);
                    lastBillingCal.set(11, 0);
                    lastBillingCal.add(5, -1);
                    lastDateBilling = new Timestamp(lastBillingCal.getTimeInMillis());
                }
            }
            BigDecimal lastPaid = MPayment.getSumOfBPartner(this.getCtx(), C_BPartner_ID, lastDateBilling, billingDate, invoice.get_TrxName());
            this.setLastPaidAmt(lastPaid);
            this.setAdjustAmt(BigDecimal.ZERO);
            BigDecimal lastTansferedAmt = lastInvoicedAmt.subtract(lastPaid);
            this.setLastTransferedAmt(lastTansferedAmt);
        }
    }

    public static MBilling getLastBilling(Ctx ctx, int C_BPartner_ID, Timestamp billingDate, String trxName) {
        MBilling retValue = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String billingDateStr = format.format(billingDate);
        String sql = "SELECT * FROM C_Billing WHERE C_BPartner_ID=? AND TO_CHAR(DateBilling, 'YYYYMMDD')<'" + billingDateStr + "'" + " AND IsSOTrx='Y' AND DOCSTATUS IN ('CO', 'CL', 'DR') ORDER BY DateBilling DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MBilling(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((locs = bp.getLocations(false)) != null) {
            for (int i = 0; i < locs.length; ++i) {
                if ((!locs[i].isBillTo() || !this.isSOTrx()) && (!locs[i].isPayFrom() || this.isSOTrx())) continue;
                this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "Has no To Address: " + (Object)((Object)bp));
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setInvoice(MInvoice invoice) {
        if (invoice == null) {
            return;
        }
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setC_Order_ID(invoice.getC_Order_ID());
        this.setIsSOTrx(invoice.isSOTrx());
        this.setIsDiscountPrinted(invoice.isDiscountPrinted());
        this.setIsSelfService(invoice.isSelfService());
        this.setSendEMail(invoice.isSendEMail());
        this.setM_PriceList_ID(invoice.getM_PriceList_ID());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setC_Currency_ID(invoice.getC_Currency_ID());
        this.setC_ConversionType_ID(invoice.getC_ConversionType_ID());
        this.setPaymentRule(invoice.getPaymentRule());
        this.setC_PaymentTerm_ID(invoice.getC_PaymentTerm_ID());
        this.setPOReference(invoice.getPOReference());
        this.setDescription(invoice.getDescription());
        this.setDateOrdered(invoice.getDateOrdered());
        this.setDateInvoiced(invoice.getDateInvoiced());
        this.setDateAcct(invoice.getDateAcct());
        this.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
        this.setC_Project_ID(invoice.getC_Project_ID());
        this.setC_Campaign_ID(invoice.getC_Campaign_ID());
        this.setC_Activity_ID(invoice.getC_Activity_ID());
        this.setUser1_ID(invoice.getUser1_ID());
        this.setUser2_ID(invoice.getUser2_ID());
    }

    public void setC_DocTypeTarget_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AC_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine(DocBaseType);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            boolean isSOTrx = "BRI".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID("BRI");
        } else {
            this.setC_DocTypeTarget_ID("BPI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBillingLine[] getLines(String whereClause) {
        ArrayList<MBillingLine> list = new ArrayList<MBillingLine>();
        String sql = "SELECT * FROM C_BillingLine WHERE C_Billing_ID=? ";
        if (whereClause != null) {
            sql = sql + whereClause;
        }
        sql = sql + " ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Billing_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MBillingLine il = new MBillingLine(this.getCtx(), rs, this.get_TrxName());
                il.setBilling(this);
                list.add(il);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MBillingLine[] lines = new MBillingLine[list.size()];
        list.toArray(lines);
        return lines;
    }

    public MBillingLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        return this.m_lines;
    }

    public MBillingLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MBillingLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MBillingLine line = lines[i];
            line.setLine(number);
            line.save();
            number += step;
        }
        this.m_lines = null;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    public MBillingTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String sql = "SELECT * FROM C_BillingTax WHERE C_Billing_ID=?";
        ArrayList<MBillingTax> list = new ArrayList<MBillingTax>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Billing_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBillingTax(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getTaxes", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_taxes = new MBillingTax[list.size()];
        list.toArray(this.m_taxes);
        return this.m_taxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Billing_ID=" + this.getC_Billing_ID();
        int noLine = DB.executeUpdate((String)("UPDATE C_BillingLine " + set), (String)this.get_TrxName());
        int noTax = DB.executeUpdate((String)("UPDATE C_BillingTax " + set), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine(processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        String sql;
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getM_PriceList_ID() == 0) {
            int ii2 = this.getCtx().getContextAsInt("#M_PriceList_ID");
            if (ii2 != 0) {
                this.setM_PriceList_ID(ii2);
            } else {
                sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii2 = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii2 != 0) {
                    this.setM_PriceList_ID(ii2);
                }
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql2 = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, (String)sql2, (int)this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(this.getCtx().getContextAsInt("#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = this.getCtx().getContextAsInt("#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(this.isSOTrx() ? "BRI" : "BPI");
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = this.getCtx().getContextAsInt("#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        BigDecimal invoiceAmt = this.getLastTransferedAmt();
        invoiceAmt = invoiceAmt.add(this.getGrandTotal());
        this.setTotalInvoiceAmt(invoiceAmt);
        return true;
    }

    protected boolean beforeDelete() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBilling[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE C_BillingLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM C_Billing o WHERE ol.C_Billing_ID=o.C_Billing_ID) WHERE C_Billing_ID=" + this.getC_Billing_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setM_PriceList_ID(int M_PriceList_ID) {
        String sql = "SELECT M_PriceList_ID, C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                super.setM_PriceList_ID(rs.getInt(1));
                this.setC_Currency_ID(rs.getInt(2));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "setM_PriceList_ID", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
    }

    public static void setIsPaid(Ctx ctx, int C_BPartner_ID, String trxName) {
        int counter = 0;
        String sql = "SELECT * FROM C_Billing WHERE IsPaid='N' AND DocStatus IN ('CO','CL')";
        sql = C_BPartner_ID > 1 ? sql + " AND C_BPartner_ID=?" : sql + " AND AD_Client_ID=" + ctx.getAD_Client_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            if (C_BPartner_ID > 1) {
                pstmt.setInt(1, C_BPartner_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MBilling billing = new MBilling(ctx, rs, trxName);
                if (!billing.save()) continue;
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.config("#" + counter);
    }

    public String getDocStatusName() {
        return MRefList.getListName((Ctx)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Ctx)this.getCtx(), (int)2, (int)this.getC_Invoice_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MBilling.getPDFFileName(documentDir, this.getC_Invoice_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Ctx)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Ctx)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MBPartner bp;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MBillingLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if ("B".equals(this.getPaymentRule()) && MCashBook.get(this.getCtx(), this.getAD_Org_ID(), this.getC_Currency_ID()) == null) {
            this.m_processMsg = "@NoCashBook@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (this.getC_DocType_ID() == 0) {
            this.m_processMsg = "No Document Type";
            return "IN";
        }
        this.explodeBOM();
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating Tax";
            return "IN";
        }
        if (this.isSOTrx() && !this.isReversal() && "S".equals((bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null)).getSOCreditStatus())) {
            this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void explodeBOM() {
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_BillingLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_BillingLine WHERE C_Billing_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Billing_ID());
        while (count != 0) {
            this.renumberLines(100);
            MBillingLine[] lines = this.getLines(where);
            for (int i = 0; i < lines.length; ++i) {
                MBillingLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MProductBOM[] boms = MProductBOM.getBOMLines(product);
                for (int j = 0; j < boms.length; ++j) {
                    MProductBOM bom = boms[j];
                    MBillingLine newLine = new MBillingLine(this);
                    newLine.setLine(++lineNo);
                    newLine.setM_Product_ID(bom.getProduct().getM_Product_ID(), bom.getProduct().getC_UOM_ID());
                    newLine.setQty(line.getQtyBilling().multiply(bom.getBOMQty()));
                    if (bom.getDescription() != null) {
                        newLine.setDescription(bom.getDescription());
                    }
                    newLine.setPrice();
                    newLine.save(this.get_TrxName());
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPriceEntered(Env.ZERO);
                line.setPriceActual(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = description + " " + line.getDescription();
                }
                line.setDescription(description);
                line.save(this.get_TrxName());
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Billing_ID());
            this.renumberLines(10);
        }
    }

    private boolean calculateTaxTotal() {
        MBillingTax iTax;
        this.log.fine("");
        DB.executeUpdate((String)("DELETE FROM C_BillingTax WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MBillingLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MBillingLine line = lines[i];
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (iTax = MBillingTax.get(line, this.getPrecision(), false, this.get_TrxName())) != null) {
                iTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!iTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!iTax.save()) {
                    return false;
                }
                taxList.add(taxID);
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        BigDecimal grandTotal = totalLines;
        MBillingTax[] taxes = this.getTaxes(true);
        for (int i = 0; i < taxes.length; ++i) {
            iTax = taxes[i];
            MTax tax = iTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                for (int j = 0; j < cTaxes.length; ++j) {
                    MTax cTax = cTaxes[j];
                    MBPartner partner = MBPartner.get(this.getCtx(), this.getC_BPartner_ID());
                    BigDecimal taxAmt = cTax.calculateTax(iTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
                    MBillingTax newITax = new MBillingTax(this.getCtx(), 0, this.get_TrxName());
                    newITax.setClientOrg((PO)this);
                    newITax.setC_Billing_ID(this.getC_Billing_ID());
                    newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newITax.setPrecision(this.getPrecision());
                    newITax.setIsTaxIncluded(this.isTaxIncluded());
                    newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                    newITax.setTaxAmt(taxAmt);
                    if (!newITax.save(this.get_TrxName())) {
                        return false;
                    }
                    if (this.isTaxIncluded()) continue;
                    grandTotal = grandTotal.add(taxAmt);
                }
                if (iTax.delete(true, this.get_TrxName())) continue;
                return false;
            }
            if (this.isTaxIncluded()) continue;
            grandTotal = grandTotal.add(iTax.getTaxAmt());
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        MClientInfo clientinfo;
        int taxAdjustCharge_ID;
        MInvoiceTax tax;
        int t;
        Object[] taxs;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            if (!"IP".equals(status)) {
                return status;
            }
        } else if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating Tax";
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        BigDecimal taxInvoice = BigDecimal.ZERO;
        HashMap<Integer, Integer> taxIDs = new HashMap<Integer, Integer>();
        MBillingLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MBillingLine line = lines[i];
            MInvoiceLine invoiceline = new MInvoiceLine(this.getCtx(), line.getC_InvoiceLine_ID(), this.get_TrxName());
            invoiceline.setIsBilled(true);
            invoiceline.save();
            this.log.fine(" Set Billed for Line=" + invoiceline.getC_InvoiceLine_ID());
            Integer C_Invoice_ID = (Integer)taxIDs.get(invoiceline.getC_Invoice_ID());
            if (C_Invoice_ID != null) continue;
            MInvoice invoice = new MInvoice(this.getCtx(), invoiceline.getC_Invoice_ID(), this.get_TrxName());
            taxIDs.put(invoiceline.getC_Invoice_ID(), invoiceline.getC_Invoice_ID());
            this.log.fine(" get tax for invoice=" + invoice.getDocumentNo());
            taxs = invoice.getTaxes(true);
            for (t = 0; t < taxs.length; ++t) {
                tax = taxs[t];
                taxInvoice = taxInvoice.add(tax.getTaxAmt());
                this.log.fine(" Added Tax=" + tax.getTaxAmt());
            }
        }
        taxInvoice = taxInvoice.subtract(this.getTaxAmt());
        this.log.fine(" Tax Diff=" + taxInvoice);
        if (!taxInvoice.equals(BigDecimal.ZERO) && (taxAdjustCharge_ID = (clientinfo = new MClientInfo(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName())).getC_TaxAdjustCharge_ID()) != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
            invoice.setAD_Org_ID(this.getAD_Org_ID());
            invoice.setAD_OrgTrx_ID(this.getAD_OrgTrx_ID());
            invoice.setAD_User_ID(this.getAD_User_ID());
            invoice.setC_Activity_ID(this.getC_Activity_ID());
            invoice.setC_BPartner_ID(this.getC_BPartner_ID());
            invoice.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
            invoice.setC_ConversionType_ID(this.getC_ConversionType_ID());
            invoice.setC_Currency_ID(this.getC_Currency_ID());
            MInvoice firstInvoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            invoice.setC_DocTypeTarget_ID(firstInvoice.getC_DocTypeTarget_ID());
            invoice.setC_DocType_ID(firstInvoice.getC_DocType_ID());
            invoice.setC_Order_ID(this.getC_Order_ID());
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
            invoice.setC_Currency_ID(this.getC_Currency_ID());
            invoice.setDateAcct(this.getDateAcct());
            invoice.setDateInvoiced(this.getDateInvoiced());
            invoice.setDateOrdered(this.getDateOrdered());
            invoice.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"C_Billing_ID") + ":" + this.getDocumentNo() + " ==> " + Msg.translate((Ctx)this.getCtx(), (String)"C_TaxAdjustInvoice_ID"));
            invoice.setIsSOTrx(this.isSOTrx());
            invoice.setM_PriceList_ID(this.getM_PriceList_ID());
            invoice.setPaymentRule(this.getPaymentRule());
            invoice.setSalesRep_ID(this.getSalesRep_ID());
            if (invoice.save()) {
                MInvoiceLine invoiceline = new MInvoiceLine(invoice);
                invoiceline.setC_Charge_ID(taxAdjustCharge_ID);
                invoiceline.setQty(new BigDecimal(1));
                invoiceline.setPriceList(taxInvoice);
                invoiceline.setPrice(taxInvoice);
                this.log.fine(" Set Tax Revenue line=" + taxInvoice);
                taxs = MTax.getAll(this.getCtx());
                for (t = 0; t < taxs.length; ++t) {
                    tax = taxs[t];
                    if (!BigDecimal.ZERO.equals(tax.getRate()) && !tax.isTaxExempt()) continue;
                    invoiceline.setC_Tax_ID(tax.getC_Tax_ID());
                    break;
                }
                invoiceline.setIsBilled(true);
                invoiceline.setIsPrinted(true);
                if (invoiceline.save()) {
                    this.log.fine(" Saved Tax Revenue Line Amt=" + invoiceline.getPriceActual());
                }
                invoice.processIt("CO");
                if (invoice.save()) {
                    this.log.fine(" Saved Tax Amt=" + invoice.getGrandTotal());
                    this.setC_TaxAdjustInvoice_ID(invoice.getC_Invoice_ID());
                }
            }
        }
        this.m_processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MBillingLine[] lines = this.getLines(false);
            for (int i = 0; i < lines.length; ++i) {
                MBillingLine line = lines[i];
                BigDecimal old = line.getQtyBilling();
                if (old.compareTo(Env.ZERO) == 0) continue;
                line.setQty(Env.ZERO);
                line.setTaxAmt(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setLineTotalAmt(Env.ZERO);
                line.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided") + " (" + old + ")");
                if (line.getC_InvoiceLine_ID() != 0) {
                    MInvoiceLine invoiceline = new MInvoiceLine(this.getCtx(), line.getC_InvoiceLine_ID(), this.get_TrxName());
                    invoiceline.setIsBilled(false);
                    invoiceline.save();
                }
                line.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided"));
        this.setIsPaid(true);
        this.setC_Payment_ID(0);
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        MBillingLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MBillingLine line = lines[i];
            BigDecimal old = line.getQtyBilling();
            if (old.compareTo(Env.ZERO) == 0) continue;
            line.setQty(Env.ZERO);
            line.setTaxAmt(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.setLineTotalAmt(Env.ZERO);
            line.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided") + " (" + old + ")");
            if (line.getC_InvoiceLine_ID() != 0) {
                MInvoiceLine invoiceline = new MInvoiceLine(this.getCtx(), line.getC_InvoiceLine_ID(), this.get_TrxName());
                invoiceline.setIsBilled(false);
                invoiceline.save();
            }
            line.save(this.get_TrxName());
        }
        this.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided"));
        this.setIsPaid(true);
        this.setC_Payment_ID(0);
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }
}

