/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBilling;
import org.compiere.model.MBillingTax;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.Tax;
import org.compiere.model.X_C_BillingLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBillingLine
extends X_C_BillingLine {
    private static CLogger s_log = CLogger.getCLogger(MBillingLine.class);
    private int m_M_PriceList_ID = 0;
    private Timestamp m_DateInvoiced = null;
    private Timestamp m_DateBilling = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner_Location_ID = 0;
    private boolean m_IsSOTrx = true;
    private boolean m_priceSet = false;
    private MProduct m_product = null;
    private String m_name = null;
    private Integer m_precision = null;
    private MProductPricing m_productPricing = null;
    private MBilling m_parent = null;

    public static MBillingLine getOfInvoiceLine(MInvoiceLine iLine) {
        if (iLine == null) {
            return null;
        }
        MBillingLine retValue = null;
        String sql = "SELECT * FROM C_BillingLine WHERE C_InvoiceLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)iLine.get_TrxName());
            pstmt.setInt(1, iLine.getC_InvoiceLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MBillingLine(iLine.getCtx(), rs, iLine.get_TrxName());
                if (rs.next()) {
                    s_log.warning("More than one C_BillingLine of " + (Object)((Object)iLine));
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MBillingLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        MBillingLine retValue = null;
        String sql = "SELECT * FROM C_BillingLine WHERE M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)sLine.get_TrxName());
            pstmt.setInt(1, sLine.getM_InOutLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MBillingLine(sLine.getCtx(), rs, sLine.get_TrxName());
                if (rs.next()) {
                    s_log.warning("More than one C_BillingLine of " + (Object)((Object)sLine));
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MBillingLine(Ctx ctx, int C_BillingLine_ID, String trxName) {
        super(ctx, C_BillingLine_ID, trxName);
        if (C_BillingLine_ID == 0) {
            this.setIsDescription(false);
            this.setIsPrinted(true);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setTaxAmt(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.setQtyBilling(Env.ZERO);
        }
    }

    public MBillingLine(MBilling billing) {
        this(billing.getCtx(), 0, billing.get_TrxName());
        if (billing.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(billing.getAD_Client_ID(), billing.getAD_Org_ID());
        this.setC_Billing_ID(billing.getC_Billing_ID());
        this.setBilling(billing);
    }

    public MBillingLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setBilling(MBilling billing) {
        this.m_parent = billing;
        this.m_M_PriceList_ID = billing.getM_PriceList_ID();
        this.m_DateInvoiced = billing.getDateInvoiced();
        this.m_DateBilling = billing.getDateBilling();
        this.m_C_BPartner_ID = billing.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = billing.getC_BPartner_Location_ID();
        this.m_IsSOTrx = billing.isSOTrx();
        this.m_precision = new Integer(billing.getPrecision());
    }

    public MBilling getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MBilling(this.getCtx(), this.getC_Billing_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setInvoiceLine(MInvoice invoice, MInvoiceLine iLine) {
        this.setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(iLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        this.setIsDescription(iLine.isDescription());
        this.setDescription(iLine.getDescription());
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setC_UOM_ID(iLine.getC_UOM_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(iLine.getS_ResourceAssignment_ID());
        this.setC_Charge_ID(iLine.getC_Charge_ID());
        this.setPriceActual(iLine.getPriceActual());
        this.setPriceEntered(iLine.getPriceEntered());
        this.setPriceLimit(iLine.getPriceLimit());
        this.setPriceList(iLine.getPriceList());
        this.setC_Tax_ID(iLine.getC_Tax_ID());
        if (!invoice.isReturnTrx()) {
            this.setQtyEntered(iLine.getQtyEntered());
            this.setQtyBilling(iLine.getQtyInvoiced());
            this.setLineNetAmt(iLine.getLineNetAmt());
            this.setLineTotalAmt(iLine.getLineTotalAmt());
        } else {
            this.setQtyEntered(iLine.getQtyEntered().negate());
            this.setQtyBilling(iLine.getQtyInvoiced().negate());
            this.setLineNetAmt(iLine.getLineNetAmt().negate());
            this.setLineTotalAmt(iLine.getLineTotalAmt().negate());
        }
        this.setRRAmt(iLine.getRRAmt());
        this.setRRStartDate(iLine.getRRStartDate());
        this.setA_Asset_ID(iLine.getA_Asset_ID());
        this.setC_Project_ID(iLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(iLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(iLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(iLine.getC_Activity_ID());
        this.setC_Campaign_ID(iLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(iLine.getAD_OrgTrx_ID());
        this.setUser1_ID(iLine.getUser1_ID());
        this.setUser2_ID(iLine.getUser2_ID());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", new Integer(0));
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setBilling(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        this.m_productPricing = new MProductPricing(this.getM_Product_ID(), C_BPartner_ID, this.getQtyBilling(), this.m_IsSOTrx);
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPricing.setPriceDate(this.m_DateInvoiced);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyBilling()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyBilling().divide(this.getQtyEntered(), 6, 4)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        int M_Warehouse_ID = this.getCtx().getContextAsInt("#M_Warehouse_ID");
        int C_Tax_ID = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.m_DateInvoiced, this.m_DateInvoiced, this.getAD_Org_ID(), M_Warehouse_ID, this.m_C_BPartner_Location_ID, this.m_C_BPartner_Location_ID, this.m_IsSOTrx);
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        if (this.m_IsSOTrx) {
            // empty if block
        }
        return true;
    }

    public void setTaxAmt() {
        MTax tax;
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MBilling billing = this.getParent();
        MBPartner partner = MBPartner.get(this.getCtx(), billing.getC_BPartner_ID());
        if (partner.isTaxDocumentLevel((tax = MTax.get(this.getCtx(), this.getC_Tax_ID())).isDocumentLevel()) && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision(), partner.getTaxRoundModeAsInt());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setLineNetAmt() {
        BigDecimal net = this.getPriceActual().multiply(this.getQtyBilling());
        if (net.scale() > this.getPrecision()) {
            net = net.setScale(this.getPrecision(), 4);
        }
        super.setLineNetAmt(net);
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyBilling(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setQtyBilling(BigDecimal QtyBilling) {
        MProduct product = this.getProduct();
        if (QtyBilling != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyBilling = QtyBilling.setScale(precision, 4);
        }
        super.setQtyBilling(QtyBilling);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBillingLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyBilling=").append(this.getQtyBilling()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.m_name == null) {
            String sql = "SELECT COALESCE (p.Name, c.Name) FROM C_BillingLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE C_BillingLine_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getC_BillingLine_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (this.m_name == null) {
                    this.m_name = "??";
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getName", (Throwable)e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {}
                pstmt = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Billing x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Billing_ID=?";
        int i = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Billing_ID());
        if (i < 0) {
            this.log.warning("getPrecision = " + i + " - set to 2");
            i = 2;
        }
        this.m_precision = new Integer(i);
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM C_Billing WHERE C_Billing_ID=?", (int)this.getC_Billing_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("New=" + newRecord);
        if (this.getC_Charge_ID() != 0) {
            if (this.getM_Product_ID() != 0) {
                this.setM_Product_ID(0);
            }
        } else if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
            this.setPrice();
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_BillingLine WHERE C_Billing_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Billing_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyBilling")) {
            this.setQtyBilling(this.getQtyBilling());
        }
        this.setLineNetAmt();
        if (this.getTaxAmt().compareTo(Env.ZERO) == 0) {
            this.setTaxAmt();
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MBillingTax tax;
        if (!success) {
            return success;
        }
        if (!newRecord && this.is_ValueChanged("C_Tax_ID") && (tax = MBillingTax.get(this, this.getPrecision(), true, this.get_TrxName())) != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return true;
            }
        }
        return this.updateHeaderTax();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        String sql;
        int no;
        MBillingTax tax = MBillingTax.get(this, this.getPrecision(), false, this.get_TrxName());
        if (tax != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return false;
            }
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Billing i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_BillingLine il WHERE i.C_Billing_ID=il.C_Billing_ID) WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Billing i SET TaxAmt=(SELECT COALESCE(SUM(TaxAmt),0) FROM C_BillingTax it WHERE i.C_Billing_ID=it.C_Billing_ID) WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = this.isTaxIncluded() ? "UPDATE C_Billing i  SET GrandTotal=TotalLines WHERE C_Billing_ID=" + this.getC_Billing_ID() : "UPDATE C_Billing i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_BillingTax it WHERE i.C_Billing_ID=it.C_Billing_ID) WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(3) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = !this.isTaxIncluded() ? "UPDATE C_Billing i  SET RevenueNetAmt=TotalLines WHERE C_Billing_ID=" + this.getC_Billing_ID() : "UPDATE C_Billing i  SET RevenueNetAmt=TotalLines-(SELECT COALESCE(SUM(TaxAmt),0) FROM C_BillingTax it WHERE i.C_Billing_ID=it.C_Billing_ID) WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(4) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Billing i  SET TotalInvoiceAmt=GrandTotal+LastTransferedAmt WHERE C_Billing_ID=" + this.getC_Billing_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(5) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }
}

